/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.spark.http.source.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.seatunnel.spark.http.source.util.HttpClientResult;

public class HttpClientUtils {
    private static final String ENCODING = "UTF-8";
    private static final int CONNECT_TIMEOUT = 12000;
    private static final int SOCKET_TIMEOUT = 60000;
    private static final int INITIAL_CAPACITY = 16;

    private HttpClientUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static HttpClientResult doGet(String url) throws Exception {
        return HttpClientUtils.doGet(url, null, null);
    }

    public static HttpClientResult doGet(String url, Map<String, String> params) throws Exception {
        return HttpClientUtils.doGet(url, null, params);
    }

    public static HttpClientResult doGet(String url, Map<String, String> headers, Map<String, String> params) throws Exception {
        URIBuilder uriBuilder = new URIBuilder(url);
        if (params != null) {
            Set<Map.Entry<String, String>> entrySet = params.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                uriBuilder.setParameter(entry.getKey(), entry.getValue());
            }
        }
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(12000).setSocketTimeout(60000).build();
        HttpGet httpGet = new HttpGet(uriBuilder.build());
        httpGet.setConfig(requestConfig);
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpClientUtils.packageHeader(headers, (HttpRequestBase)httpGet);
            HttpClientResult httpClientResult = HttpClientUtils.getHttpClientResult(httpClient, (HttpRequestBase)httpGet);
            return httpClientResult;
        }
    }

    public static HttpClientResult doPost(String url) throws Exception {
        return HttpClientUtils.doPost(url, null, null);
    }

    public static HttpClientResult doPost(String url, Map<String, String> params) throws Exception {
        return HttpClientUtils.doPost(url, null, params);
    }

    public static HttpClientResult doPost(String url, Map<String, String> headers, Map<String, String> params) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(12000).setSocketTimeout(60000).build();
        httpPost.setConfig(requestConfig);
        HttpClientUtils.packageHeader(headers, (HttpRequestBase)httpPost);
        HttpClientUtils.packageParam(params, (HttpEntityEnclosingRequestBase)httpPost);
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpClientResult httpClientResult = HttpClientUtils.getHttpClientResult(httpClient, (HttpRequestBase)httpPost);
            return httpClientResult;
        }
    }

    public static HttpClientResult doPut(String url) throws Exception {
        return HttpClientUtils.doPut(url, null);
    }

    public static HttpClientResult doPut(String url, Map<String, String> params) throws Exception {
        HttpPut httpPut = new HttpPut(url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(12000).setSocketTimeout(60000).build();
        httpPut.setConfig(requestConfig);
        HttpClientUtils.packageParam(params, (HttpEntityEnclosingRequestBase)httpPut);
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpClientResult httpClientResult = HttpClientUtils.getHttpClientResult(httpClient, (HttpRequestBase)httpPut);
            return httpClientResult;
        }
    }

    public static HttpClientResult doDelete(String url) throws Exception {
        HttpDelete httpDelete = new HttpDelete(url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(12000).setSocketTimeout(60000).build();
        httpDelete.setConfig(requestConfig);
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpClientResult httpClientResult = HttpClientUtils.getHttpClientResult(httpClient, (HttpRequestBase)httpDelete);
            return httpClientResult;
        }
    }

    public static HttpClientResult doDelete(String url, Map<String, String> params) throws Exception {
        if (params == null) {
            params = new HashMap<String, String>(16);
        }
        params.put("_method", "delete");
        return HttpClientUtils.doPost(url, params);
    }

    public static void packageHeader(Map<String, String> params, HttpRequestBase httpMethod) {
        if (params != null) {
            Set<Map.Entry<String, String>> entrySet = params.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                httpMethod.setHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    public static void packageParam(Map<String, String> params, HttpEntityEnclosingRequestBase httpMethod) throws UnsupportedEncodingException {
        if (params != null) {
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            Set<Map.Entry<String, String>> entrySet = params.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                nvps.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            httpMethod.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, ENCODING));
        }
    }

    public static HttpClientResult getHttpClientResult(CloseableHttpClient httpClient, HttpRequestBase httpMethod) throws Exception {
        try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpMethod);){
            if (httpResponse != null && httpResponse.getStatusLine() != null) {
                String content = "";
                if (httpResponse.getEntity() != null) {
                    content = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)ENCODING);
                }
                HttpClientResult httpClientResult = new HttpClientResult(httpResponse.getStatusLine().getStatusCode(), content);
                return httpClientResult;
            }
        }
        return new HttpClientResult(500);
    }

    public static void release(CloseableHttpResponse httpResponse, CloseableHttpClient httpClient) throws IOException {
        if (httpResponse != null) {
            httpResponse.close();
        }
        if (httpClient != null) {
            httpClient.close();
        }
    }
}

