/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.flink.clickhouse.sink;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.api.common.functions.MapPartitionFunction;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.operators.MapPartitionOperator;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.config.TypesafeConfigUtils;
import org.apache.seatunnel.flink.BaseFlinkSink;
import org.apache.seatunnel.flink.FlinkEnvironment;
import org.apache.seatunnel.flink.batch.FlinkBatchSink;
import org.apache.seatunnel.flink.clickhouse.pojo.ClickhouseFileCopyMethod;
import org.apache.seatunnel.flink.clickhouse.pojo.IntHolder;
import org.apache.seatunnel.flink.clickhouse.pojo.Shard;
import org.apache.seatunnel.flink.clickhouse.pojo.ShardMetadata;
import org.apache.seatunnel.flink.clickhouse.sink.ClickhouseFileOutputFormat;
import org.apache.seatunnel.flink.clickhouse.sink.client.ClickhouseClient;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;
import ru.yandex.clickhouse.ClickHouseConnectionImpl;

@AutoService(value={BaseFlinkSink.class})
public class ClickhouseFileBatchSink
implements FlinkBatchSink {
    private Config config;
    private ShardMetadata shardMetadata;
    private Map<String, String> tableSchema = new HashMap<String, String>();
    private List<String> fields;

    public void setConfig(Config config) {
        this.config = config;
    }

    public Config getConfig() {
        return this.config;
    }

    public CheckResult checkConfig() {
        CheckResult checkResult = CheckConfigUtil.checkAllExists(this.config, "host", "table", "database", "username", "password", "clickhouse_local_path");
        if (!checkResult.isSuccess()) {
            return checkResult;
        }
        ImmutableMap<String, String> defaultConfigs = ImmutableMap.builder().put("copy_method", ClickhouseFileCopyMethod.SCP.getName()).build();
        this.config = this.config.withFallback(ConfigFactory.parseMap(defaultConfigs));
        return CheckResult.success();
    }

    public void prepare(FlinkEnvironment env) {
        ClickhouseClient clickhouseClient = new ClickhouseClient(this.config);
        String table = this.config.getString("table");
        String database = this.config.getString("database");
        String[] hostAndPort = this.config.getString("host").split(":");
        try (ClickHouseConnectionImpl connection = clickhouseClient.getClickhouseConnection();){
            this.tableSchema = clickhouseClient.getClickhouseTableSchema(connection, table);
            String shardKey = TypesafeConfigUtils.getConfig(this.config, "sharding_key", "");
            String shardKeyType = this.tableSchema.get(shardKey);
            this.shardMetadata = new ShardMetadata(shardKey, shardKeyType, database, table, false, new Shard(1, 1, 1, hostAndPort[0], hostAndPort[0], hostAndPort[1], database));
            if (this.config.hasPath("fields")) {
                this.fields = this.config.getStringList("fields");
                for (String field2 : this.fields) {
                    if (this.tableSchema.containsKey(field2)) continue;
                    throw new RuntimeException("Field " + field2 + " does not exist in table " + table);
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to connect to clickhouse server", e);
        }
    }

    @Nullable
    public void outputBatch(FlinkEnvironment env, DataSet<Row> dataSet) {
        RowTypeInfo rowTypeInfo = (RowTypeInfo)dataSet.getType();
        String[] fieldNames = rowTypeInfo.getFieldNames();
        final IntHolder shardKeyIndexHolder = new IntHolder();
        for (int i = 0; i < fieldNames.length; ++i) {
            if (!fieldNames[i].equals(this.shardMetadata.getShardKey())) continue;
            shardKeyIndexHolder.setValue(i);
            break;
        }
        MapPartitionOperator mapPartitionOperator = dataSet.partitionCustom((Partitioner)new Partitioner<String>(){

            public int partition(String shardKey, int numPartitions) {
                return shardKey.hashCode() % numPartitions;
            }
        }, (KeySelector)new KeySelector<Row, String>(){

            public String getKey(Row value) {
                int shardKeyIndex = shardKeyIndexHolder.getValue();
                return Objects.toString(value.getField(shardKeyIndex));
            }
        }).mapPartition((MapPartitionFunction)new MapPartitionFunction<Row, Row>(){

            public void mapPartition(Iterable<Row> values, Collector<Row> out) throws Exception {
                new ClickhouseFileOutputFormat(ClickhouseFileBatchSink.this.config, ClickhouseFileBatchSink.this.shardMetadata, ClickhouseFileBatchSink.this.fields).writeRecords(values);
            }
        });
        mapPartitionOperator.output((OutputFormat)new OutputFormat<Row>(){

            public void configure(Configuration parameters) {
            }

            public void open(int taskNumber, int numTasks) {
            }

            public void writeRecord(Row record) {
            }

            public void close() {
            }
        });
    }

    public void close() {
    }

    public String getPluginName() {
        return "ClickhouseFile";
    }
}

