/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.flink.clickhouse.sink;

import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.io.RichOutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.types.Row;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.flink.clickhouse.pojo.IntHolder;
import org.apache.seatunnel.flink.clickhouse.pojo.Shard;
import org.apache.seatunnel.flink.clickhouse.pojo.ShardMetadata;
import org.apache.seatunnel.flink.clickhouse.sink.client.ClickhouseBatchStatement;
import org.apache.seatunnel.flink.clickhouse.sink.client.ClickhouseClient;
import org.apache.seatunnel.flink.clickhouse.sink.client.ShardRouter;
import org.apache.seatunnel.flink.clickhouse.sink.inject.ArrayInjectFunction;
import org.apache.seatunnel.flink.clickhouse.sink.inject.BigDecimalInjectFunction;
import org.apache.seatunnel.flink.clickhouse.sink.inject.ClickhouseFieldInjectFunction;
import org.apache.seatunnel.flink.clickhouse.sink.inject.DateInjectFunction;
import org.apache.seatunnel.flink.clickhouse.sink.inject.DateTimeInjectFunction;
import org.apache.seatunnel.flink.clickhouse.sink.inject.DoubleInjectFunction;
import org.apache.seatunnel.flink.clickhouse.sink.inject.FloatInjectFunction;
import org.apache.seatunnel.flink.clickhouse.sink.inject.IntInjectFunction;
import org.apache.seatunnel.flink.clickhouse.sink.inject.LongInjectFunction;
import org.apache.seatunnel.flink.clickhouse.sink.inject.StringInjectFunction;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import ru.yandex.clickhouse.ClickHouseConnectionImpl;
import ru.yandex.clickhouse.ClickHousePreparedStatementImpl;
import ru.yandex.clickhouse.ClickHouseStatement;

public class ClickhouseOutputFormat
extends RichOutputFormat<Row> {
    private static final long serialVersionUID = -1L;
    private final Config config;
    private final List<String> fields;
    private final Map<String, String> tableSchema;
    private final ShardMetadata shardMetadata;
    private final int batchSize;
    private transient RetryUtils.RetryMaterial retryMaterial;
    private transient ShardRouter shardRouter;
    private transient ClickhouseClient clickhouseClient;
    private transient String prepareSql;
    private transient Map<Shard, ClickhouseBatchStatement> statementMap;
    private transient Map<String, ClickhouseFieldInjectFunction> fieldInjectFunctionMap;
    private static final ClickhouseFieldInjectFunction DEFAULT_INJECT_FUNCTION = new StringInjectFunction();

    public ClickhouseOutputFormat(Config config, ShardMetadata shardMetadata, List<String> fields, Map<String, String> tableSchema) {
        this.config = config;
        this.shardMetadata = shardMetadata;
        this.fields = fields;
        this.tableSchema = tableSchema;
        this.batchSize = config.getInt("bulk_size");
    }

    public void configure(Configuration configuration) {
    }

    public void open(int taskNumber, int numTasks) {
        List<Integer> retryCodes = this.config.getIntList("retry_codes");
        this.retryMaterial = new RetryUtils.RetryMaterial(this.config.getInt("retry"), true, exception -> {
            if (exception instanceof SQLException) {
                SQLException sqlException = (SQLException)exception;
                return retryCodes.contains(sqlException.getErrorCode());
            }
            return false;
        });
        this.clickhouseClient = new ClickhouseClient(this.config);
        this.fieldInjectFunctionMap = this.initFieldInjectFunctionMap();
        this.shardRouter = new ShardRouter(this.clickhouseClient, this.shardMetadata);
        this.prepareSql = this.initPrepareSQL();
        this.statementMap = this.initStatementMap();
    }

    public void writeRecord(Row row) {
        ClickhouseBatchStatement batchStatement = this.statementMap.get(this.shardRouter.getShard(row));
        ClickHousePreparedStatementImpl clickHouseStatement = batchStatement.getPreparedStatement();
        IntHolder sizeHolder = batchStatement.getIntHolder();
        this.addIntoBatch(row, clickHouseStatement);
        sizeHolder.setValue(sizeHolder.getValue() + 1);
        if (sizeHolder.getValue() >= this.batchSize) {
            this.flush(clickHouseStatement);
            sizeHolder.setValue(0);
        }
    }

    public void close() {
        for (ClickhouseBatchStatement batchStatement : this.statementMap.values()) {
            try {
                ClickHouseConnectionImpl needClosedConnection = batchStatement.getClickHouseConnection();
                Throwable throwable = null;
                try {
                    ClickHousePreparedStatementImpl needClosedStatement = batchStatement.getPreparedStatement();
                    Throwable throwable2 = null;
                    try {
                        IntHolder intHolder = batchStatement.getIntHolder();
                        if (intHolder.getValue() <= 0) continue;
                        this.flush(needClosedStatement);
                        intHolder.setValue(0);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (needClosedStatement == null) continue;
                        if (throwable2 != null) {
                            try {
                                needClosedStatement.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        needClosedStatement.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (needClosedConnection == null) continue;
                    if (throwable != null) {
                        try {
                            needClosedConnection.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    needClosedConnection.close();
                }
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to close prepared statement.", e);
            }
        }
    }

    private void addIntoBatch(Row row, ClickHousePreparedStatementImpl clickHouseStatement) {
        try {
            for (int i = 0; i < this.fields.size(); ++i) {
                String fieldName = this.fields.get(i);
                Object fieldValue = row.getField(fieldName);
                if (fieldValue == null) {
                    clickHouseStatement.setObject(i + 1, null);
                    continue;
                }
                String fieldType = this.tableSchema.get(fieldName);
                this.fieldInjectFunctionMap.getOrDefault(fieldType, DEFAULT_INJECT_FUNCTION).injectFields(clickHouseStatement, i + 1, fieldValue);
            }
            clickHouseStatement.addBatch();
        }
        catch (SQLException e) {
            throw new RuntimeException("Add row data into batch error", e);
        }
    }

    private void flush(ClickHouseStatement clickHouseStatement) {
        RetryUtils.Execution execution = () -> {
            clickHouseStatement.executeBatch();
            return null;
        };
        try {
            RetryUtils.retryWithException(execution, this.retryMaterial);
        }
        catch (Exception e) {
            throw new RuntimeException("Clickhouse execute batch statement error", e);
        }
    }

    private String initPrepareSQL() {
        Object[] placeholder = new String[this.fields.size()];
        Arrays.fill(placeholder, "?");
        return String.format("INSERT INTO %s (%s) VALUES (%s)", this.shardRouter.getShardTable(), String.join((CharSequence)",", this.fields), String.join((CharSequence)",", (CharSequence[])placeholder));
    }

    private Map<Shard, ClickhouseBatchStatement> initStatementMap() {
        HashMap<Shard, ClickhouseBatchStatement> result2 = new HashMap<Shard, ClickhouseBatchStatement>(16);
        this.shardRouter.getShards().forEach((weight, shard) -> {
            try {
                ClickHouseConnectionImpl clickhouseConnection = this.clickhouseClient.getClickhouseConnection();
                ClickHousePreparedStatementImpl preparedStatement = (ClickHousePreparedStatementImpl)clickhouseConnection.prepareStatement(this.prepareSql);
                IntHolder intHolder = new IntHolder();
                ClickhouseBatchStatement batchStatement = new ClickhouseBatchStatement(clickhouseConnection, preparedStatement, intHolder);
                result2.put((Shard)shard, batchStatement);
            }
            catch (SQLException e) {
                throw new RuntimeException("Clickhouse prepare statement error", e);
            }
        });
        return result2;
    }

    private Map<String, ClickhouseFieldInjectFunction> initFieldInjectFunctionMap() {
        HashMap<String, ClickhouseFieldInjectFunction> result2 = new HashMap<String, ClickhouseFieldInjectFunction>(16);
        ArrayList<ClickhouseFieldInjectFunction> clickhouseFieldInjectFunctions = Lists.newArrayList(new ArrayInjectFunction(), new BigDecimalInjectFunction(), new DateInjectFunction(), new DateTimeInjectFunction(), new DoubleInjectFunction(), new FloatInjectFunction(), new IntInjectFunction(), new LongInjectFunction(), new StringInjectFunction());
        StringInjectFunction defaultFunction = new StringInjectFunction();
        for (String field2 : this.fields) {
            ClickhouseFieldInjectFunction function = defaultFunction;
            String fieldType = this.tableSchema.get(field2);
            for (ClickhouseFieldInjectFunction clickhouseFieldInjectFunction : clickhouseFieldInjectFunctions) {
                if (!clickhouseFieldInjectFunction.isCurrentFieldType(fieldType)) continue;
                function = clickhouseFieldInjectFunction;
                break;
            }
            result2.put(fieldType, function);
        }
        return result2;
    }
}

