/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.flink.clickhouse.sink.client;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.seatunnel.common.config.TypesafeConfigUtils;
import org.apache.seatunnel.flink.clickhouse.pojo.DistributedEngine;
import org.apache.seatunnel.flink.clickhouse.pojo.Shard;
import org.apache.seatunnel.flink.clickhouse.sink.file.ClickhouseTable;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValue;
import ru.yandex.clickhouse.BalancedClickhouseDataSource;
import ru.yandex.clickhouse.ClickHouseConnection;
import ru.yandex.clickhouse.ClickHouseConnectionImpl;
import ru.yandex.clickhouse.ClickHouseStatement;
import ru.yandex.clickhouse.settings.ClickHouseProperties;

public class ClickhouseClient {
    private final BalancedClickhouseDataSource balancedClickhouseDataSource;
    private Map<Shard, BalancedClickhouseDataSource> shardToDataSource = new ConcurrentHashMap<Shard, BalancedClickhouseDataSource>(16);

    public ClickhouseClient(Config config) {
        Properties clickhouseProperties = new Properties();
        if (TypesafeConfigUtils.hasSubConfig(config, "clickhouse.")) {
            TypesafeConfigUtils.extractSubConfig(config, "clickhouse.", false).entrySet().forEach(e -> clickhouseProperties.put(e.getKey(), String.valueOf(((ConfigValue)e.getValue()).unwrapped())));
        }
        clickhouseProperties.put("user", config.getString("username"));
        clickhouseProperties.put("password", config.getString("password"));
        String jdbcUrl = "jdbc:clickhouse://" + config.getString("host") + "/" + config.getString("database");
        this.balancedClickhouseDataSource = new BalancedClickhouseDataSource(jdbcUrl, clickhouseProperties);
    }

    public ClickHouseConnectionImpl getClickhouseConnection() {
        try {
            return (ClickHouseConnectionImpl)this.balancedClickhouseDataSource.getConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot connect to clickhouse server", e);
        }
    }

    public ClickHouseConnectionImpl getClickhouseConnection(Shard shard) {
        BalancedClickhouseDataSource shardDatasource = this.shardToDataSource.computeIfAbsent(shard, s2 -> {
            ClickHouseProperties properties = this.balancedClickhouseDataSource.getProperties();
            return new BalancedClickhouseDataSource(s2.getJdbcUrl(), properties);
        });
        try {
            return (ClickHouseConnectionImpl)shardDatasource.getConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException("Connot connect to target shard + " + shard.getJdbcUrl(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DistributedEngine getClickhouseDistributedTable(String database, String table) {
        try (ClickHouseConnectionImpl connection = this.getClickhouseConnection();){
            DistributedEngine distributedEngine = this.getClickhouseDistributedTable(connection, database, table);
            return distributedEngine;
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot get distributed table from clickhouse", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DistributedEngine getClickhouseDistributedTable(ClickHouseConnection connection, String database, String table) {
        String sql = String.format("select engine_full from system.tables where database = '%s' and name = '%s' and engine = 'Distributed'", database, table);
        try (ClickHouseStatement statement = connection.createStatement();){
            ResultSet resultSet = statement.executeQuery(sql);
            if (resultSet.next()) {
                String engineFull = resultSet.getString(1);
                List infos = Arrays.stream(engineFull.substring(12).split(",")).map(s2 -> s2.replace("'", "").trim()).collect(Collectors.toList());
                DistributedEngine distributedEngine = new DistributedEngine((String)infos.get(0), (String)infos.get(1), ((String)infos.get(2)).replace("\\)", "").trim());
                return distributedEngine;
            }
            throw new RuntimeException("Cannot get distributed table from clickhouse, resultSet is empty");
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot get distributed table from clickhouse", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, String> getClickhouseTableSchema(String table) {
        try (ClickHouseConnectionImpl connection = this.getClickhouseConnection();){
            Map<String, String> map2 = this.getClickhouseTableSchema(connection, table);
            return map2;
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot get table schema from clickhouse", e);
        }
    }

    public Map<String, String> getClickhouseTableSchema(ClickHouseConnection connection, String table) {
        String sql = "desc " + table;
        LinkedHashMap<String, String> schema = new LinkedHashMap<String, String>();
        try (ClickHouseStatement clickHouseStatement = connection.createStatement();){
            ResultSet resultSet = clickHouseStatement.executeQuery(sql);
            while (resultSet.next()) {
                schema.put(resultSet.getString(1), resultSet.getString(2));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot get table schema from clickhouse", e);
        }
        return schema;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Shard> getClusterShardList(ClickHouseConnection connection, String clusterName, String database, String port) {
        String sql = "select shard_num,shard_weight,replica_num,host_name,host_address,port from system.clusters where cluster = '" + clusterName + "'";
        ArrayList<Shard> shardList = new ArrayList<Shard>();
        try (ClickHouseStatement statement = connection.createStatement();){
            ResultSet resultSet = statement.executeQuery(sql);
            while (resultSet.next()) {
                shardList.add(new Shard(resultSet.getInt(1), resultSet.getInt(2), resultSet.getInt(3), resultSet.getString(4), resultSet.getString(5), port, database));
            }
            ArrayList<Shard> arrayList = shardList;
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot get cluster shard list from clickhouse", e);
        }
    }

    /*
     * Exception decompiling
     */
    public ClickhouseTable getClickhouseTable(String database, String table) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String localizationEngine(String engine, String ddl) {
        if ("ReplicatedMergeTree".equalsIgnoreCase(engine)) {
            return ddl.replaceAll("ReplicatedMergeTree(\\([^\\)]*\\))", "MergeTree()");
        }
        return ddl;
    }
}

