/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.flink.clickhouse.sink.client;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import net.jpountz.xxhash.XXHash64;
import net.jpountz.xxhash.XXHashFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.types.Row;
import org.apache.seatunnel.flink.clickhouse.pojo.DistributedEngine;
import org.apache.seatunnel.flink.clickhouse.pojo.Shard;
import org.apache.seatunnel.flink.clickhouse.pojo.ShardMetadata;
import org.apache.seatunnel.flink.clickhouse.sink.client.ClickhouseClient;
import ru.yandex.clickhouse.ClickHouseConnectionImpl;

public class ShardRouter
implements Serializable {
    private static final long serialVersionUID = -1L;
    private String shardTable;
    private final String table;
    private int shardWeightCount;
    private final TreeMap<Integer, Shard> shards;
    private final String shardKey;
    private final String shardKeyType;
    private final boolean splitMode;
    private final XXHash64 hashInstance = XXHashFactory.fastestInstance().hash64();
    private final ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();

    public ShardRouter(ClickhouseClient clickhouseClient, ShardMetadata shardMetadata) {
        this.shards = new TreeMap();
        this.shardKey = shardMetadata.getShardKey();
        this.shardKeyType = shardMetadata.getShardKeyType();
        this.splitMode = shardMetadata.getSplitMode();
        this.table = shardMetadata.getTable();
        if (StringUtils.isNotEmpty(this.shardKey) && StringUtils.isEmpty(this.shardKeyType)) {
            throw new IllegalArgumentException("Shard key " + this.shardKey + " not found in table " + this.table);
        }
        try (ClickHouseConnectionImpl connection = clickhouseClient.getClickhouseConnection();){
            if (this.splitMode) {
                DistributedEngine localTable = clickhouseClient.getClickhouseDistributedTable(connection, shardMetadata.getDatabase(), this.table);
                this.shardTable = localTable.getTable();
                List<Shard> shardList = clickhouseClient.getClusterShardList(connection, localTable.getClusterName(), localTable.getDatabase(), shardMetadata.getDefaultShard().getPort());
                int weight = 0;
                for (Shard shard : shardList) {
                    this.shards.put(weight, shard);
                    weight += shard.getShardWeight();
                }
                this.shardWeightCount = weight;
            } else {
                this.shards.put(0, shardMetadata.getDefaultShard());
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getShardTable() {
        return this.splitMode ? this.shardTable : this.table;
    }

    public Shard getShard(Row row) {
        if (!this.splitMode) {
            return this.shards.firstEntry().getValue();
        }
        if (StringUtils.isEmpty(this.shardKey) || row.getField(this.shardKey) == null) {
            return this.shards.lowerEntry(this.threadLocalRandom.nextInt(this.shardWeightCount + 1)).getValue();
        }
        int offset = (int)(this.hashInstance.hash(ByteBuffer.wrap(row.getField(this.shardKey).toString().getBytes(StandardCharsets.UTF_8)), 0L) & Long.MAX_VALUE % (long)this.shardWeightCount);
        return this.shards.lowerEntry(offset + 1).getValue();
    }

    public TreeMap<Integer, Shard> getShards() {
        return this.shards;
    }
}

