/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.flink.clickhouse.sink.inject;

import java.sql.SQLException;
import java.util.regex.Pattern;
import org.apache.seatunnel.flink.clickhouse.sink.inject.ClickhouseFieldInjectFunction;
import ru.yandex.clickhouse.ClickHousePreparedStatementImpl;

public class StringInjectFunction
implements ClickhouseFieldInjectFunction {
    private static final Pattern LOW_CARDINALITY_PATTERN = Pattern.compile("LowCardinality\\((.*)\\)");

    @Override
    public void injectFields(ClickHousePreparedStatementImpl statement, int index, Object value) throws SQLException {
        statement.setString(index, value.toString());
    }

    @Override
    public boolean isCurrentFieldType(String fieldType) {
        return "String".equals(fieldType) || LOW_CARDINALITY_PATTERN.matcher(fieldType).matches();
    }
}

