/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.cipher;

import java.security.Key;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.sshd.common.cipher.Cipher;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.security.SecurityUtils;

public class BaseCipher
implements Cipher {
    private javax.crypto.Cipher cipher;
    private final int ivsize;
    private final int authSize;
    private final int kdfSize;
    private final String algorithm;
    private final int keySize;
    private final int blkSize;
    private final String transformation;
    private String s;

    public BaseCipher(int ivsize, int authSize, int kdfSize, String algorithm, int keySize, String transformation, int blkSize) {
        this.ivsize = ivsize;
        this.authSize = authSize;
        this.kdfSize = kdfSize;
        this.algorithm = ValidateUtils.checkNotNullAndNotEmpty(algorithm, "No algorithm");
        this.keySize = keySize;
        this.transformation = ValidateUtils.checkNotNullAndNotEmpty(transformation, "No transformation");
        this.blkSize = blkSize;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public int getKeySize() {
        return this.keySize;
    }

    @Override
    public String getTransformation() {
        return this.transformation;
    }

    @Override
    public int getIVSize() {
        return this.ivsize;
    }

    @Override
    public int getAuthenticationTagSize() {
        return this.authSize;
    }

    @Override
    public int getKdfSize() {
        return this.kdfSize;
    }

    @Override
    public int getCipherBlockSize() {
        return this.blkSize;
    }

    @Override
    public void init(Cipher.Mode mode, byte[] key, byte[] iv) throws Exception {
        key = this.initializeKeyData(mode, key, this.getKdfSize());
        iv = this.initializeIVData(mode, iv, this.getIVSize());
        this.cipher = this.createCipherInstance(mode, key, iv);
    }

    protected javax.crypto.Cipher getCipherInstance() {
        return this.cipher;
    }

    protected javax.crypto.Cipher createCipherInstance(Cipher.Mode mode, byte[] key, byte[] iv) throws Exception {
        javax.crypto.Cipher instance = SecurityUtils.getCipher(this.getTransformation());
        instance.init(Cipher.Mode.Encrypt.equals((Object)mode) ? 1 : 2, (Key)new SecretKeySpec(key, this.getAlgorithm()), new IvParameterSpec(iv));
        return instance;
    }

    protected byte[] initializeKeyData(Cipher.Mode mode, byte[] key, int reqLen) {
        return BaseCipher.resize(key, reqLen);
    }

    protected byte[] initializeIVData(Cipher.Mode mode, byte[] iv, int reqLen) {
        return BaseCipher.resize(iv, reqLen);
    }

    @Override
    public void update(byte[] input2, int inputOffset, int inputLen) throws Exception {
        this.cipher.update(input2, inputOffset, inputLen, input2, inputOffset);
    }

    @Override
    public void updateAAD(byte[] data, int offset, int length) throws Exception {
        throw new UnsupportedOperationException(this.getClass() + " does not support AAD operations");
    }

    protected static byte[] resize(byte[] data, int size2) {
        if (data.length > size2) {
            byte[] tmp = new byte[size2];
            System.arraycopy(data, 0, tmp, 0, size2);
            data = tmp;
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        BaseCipher baseCipher = this;
        synchronized (baseCipher) {
            if (this.s == null) {
                this.s = this.getClass().getSimpleName() + "[" + this.getAlgorithm() + ", ivSize=" + this.getIVSize() + ", kdfSize=" + this.getKdfSize() + "," + this.getTransformation() + ", blkSize=" + this.getCipherBlockSize() + "]";
            }
        }
        return this.s;
    }
}

