/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config;

import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;

public enum TimeValueConfig {
    SECONDS('s', 'S', TimeUnit.SECONDS.toMillis(1L)),
    MINUTES('m', 'M', TimeUnit.MINUTES.toMillis(1L)),
    HOURS('h', 'H', TimeUnit.HOURS.toMillis(1L)),
    DAYS('d', 'D', TimeUnit.DAYS.toMillis(1L)),
    WEEKS('w', 'W', TimeUnit.DAYS.toMillis(7L));

    public static final Set<TimeValueConfig> VALUES;
    private final char loChar;
    private final char hiChar;
    private final long interval;

    private TimeValueConfig(char lo, char hi, long interval) {
        this.loChar = lo;
        this.hiChar = hi;
        this.interval = interval;
    }

    public final char getLowerCaseValue() {
        return this.loChar;
    }

    public final char getUpperCaseValue() {
        return this.hiChar;
    }

    public final long getInterval() {
        return this.interval;
    }

    public static TimeValueConfig fromValueChar(char ch) {
        if (ch <= ' ' || ch >= '\u007f') {
            return null;
        }
        for (TimeValueConfig v : VALUES) {
            if (v.getLowerCaseValue() != ch && v.getUpperCaseValue() != ch) continue;
            return v;
        }
        return null;
    }

    public static long durationOf(String s2) {
        Map<TimeValueConfig, Long> spec = TimeValueConfig.parse(s2);
        return TimeValueConfig.durationOf(spec);
    }

    public static Map<TimeValueConfig, Long> parse(String s2) throws IllegalArgumentException {
        if (GenericUtils.isEmpty(s2)) {
            return Collections.emptyMap();
        }
        int lastPos = 0;
        EnumMap<TimeValueConfig, Long> spec = new EnumMap<TimeValueConfig, Long>(TimeValueConfig.class);
        for (int curPos = 0; curPos < s2.length(); ++curPos) {
            char ch = s2.charAt(curPos);
            if (ch >= '0' && ch <= '9') continue;
            if (curPos <= lastPos) {
                throw new IllegalArgumentException("parse(" + s2 + ") missing count value at index=" + curPos);
            }
            TimeValueConfig c = TimeValueConfig.fromValueChar(ch);
            if (c == null) {
                throw new IllegalArgumentException("parse(" + s2 + ") unknown time value character: '" + ch + "'");
            }
            String v = s2.substring(lastPos, curPos);
            long count2 = Long.parseLong(v);
            if (count2 < 0L) {
                throw new IllegalArgumentException("parse(" + s2 + ") negative count (" + v + ") for " + c.name());
            }
            Long prev = spec.put(c, count2);
            if (prev != null) {
                throw new IllegalArgumentException("parse(" + s2 + ") " + c.name() + " value re-specified: current=" + count2 + ", previous=" + prev);
            }
            lastPos = curPos + 1;
            if (lastPos >= s2.length()) break;
        }
        if (lastPos < s2.length()) {
            String v = s2.substring(lastPos);
            long count3 = Long.parseLong(v);
            if (count3 < 0L) {
                throw new IllegalArgumentException("parse(" + s2 + ") negative count (" + v + ") for last component");
            }
            Long prev = spec.put(SECONDS, count3);
            if (prev != null) {
                throw new IllegalArgumentException("parse(" + s2 + ") last component (" + SECONDS.name() + ") value re-specified: current=" + count3 + ", previous=" + prev);
            }
        }
        return spec;
    }

    public static long durationOf(Map<TimeValueConfig, ? extends Number> spec) throws IllegalArgumentException {
        if (MapEntryUtils.isEmpty(spec)) {
            return -1L;
        }
        long total = 0L;
        for (Map.Entry<TimeValueConfig, ? extends Number> se : spec.entrySet()) {
            TimeValueConfig v = se.getKey();
            Number c = se.getValue();
            long factor = c.longValue();
            if (factor < 0L) {
                throw new IllegalArgumentException("valueOf(" + spec + ") bad factor (" + c + ") for " + v.name());
            }
            long added = v.getInterval() * factor;
            total += added;
        }
        return total;
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(TimeValueConfig.class));
    }
}

