/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.nio2;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.future.DefaultSshFuture;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoServiceEventListener;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.nio2.Nio2CompletionHandler;
import org.apache.sshd.common.io.nio2.Nio2Service;
import org.apache.sshd.common.io.nio2.Nio2Session;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.ValidateUtils;

public class Nio2Connector
extends Nio2Service
implements IoConnector {
    public Nio2Connector(PropertyResolver propertyResolver, IoHandler handler, AsynchronousChannelGroup group) {
        super(propertyResolver, handler, group);
    }

    @Override
    public IoConnectFuture connect(SocketAddress address, AttributeRepository context, SocketAddress localAddress) {
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("Connecting to {}", (Object)address);
        }
        DefaultIoConnectFuture future = new DefaultIoConnectFuture(address, null);
        AsynchronousSocketChannel channel = null;
        AsynchronousSocketChannel socket = null;
        try {
            AsynchronousChannelGroup group = this.getChannelGroup();
            channel = this.openAsynchronousSocketChannel(address, group);
            socket = this.setSocketOptions(channel);
            if (localAddress != null) {
                socket.bind(localAddress);
            }
            Nio2CompletionHandler<Void, Object> completionHandler = ValidateUtils.checkNotNull(this.createConnectionCompletionHandler(future, socket, context, this.propertyResolver, this.getIoHandler()), "No connection completion handler created for %s", (Object)address);
            socket.connect(address, null, completionHandler);
        }
        catch (Throwable exc) {
            Throwable t;
            block11: {
                block10: {
                    t = ExceptionUtils.peelException(exc);
                    this.debug("connect({}) failed ({}) to schedule connection: {}", address, t.getClass().getSimpleName(), t.getMessage(), t);
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (IOException err) {
                        if (!debugEnabled) break block10;
                        this.log.debug("connect({}) - failed ({}) to close socket: {}", address, err.getClass().getSimpleName(), err.getMessage());
                    }
                }
                try {
                    if (channel != null) {
                        channel.close();
                    }
                }
                catch (IOException err) {
                    if (!debugEnabled) break block11;
                    this.log.debug("connect({}) - failed ({}) to close channel: {}", address, err.getClass().getSimpleName(), err.getMessage());
                }
            }
            future.setException(t);
        }
        return future;
    }

    protected AsynchronousSocketChannel openAsynchronousSocketChannel(SocketAddress address, AsynchronousChannelGroup group) throws IOException {
        return AsynchronousSocketChannel.open(group);
    }

    protected Nio2CompletionHandler<Void, Object> createConnectionCompletionHandler(IoConnectFuture future, AsynchronousSocketChannel socket, AttributeRepository context, PropertyResolver propertyResolver, IoHandler handler) {
        return new ConnectionCompletionHandler(future, socket, context, propertyResolver, handler);
    }

    protected Nio2Session createSession(PropertyResolver propertyResolver, IoHandler handler, AsynchronousSocketChannel socket) throws Throwable {
        return new Nio2Session(this, propertyResolver, handler, socket, null);
    }

    public static class DefaultIoConnectFuture
    extends DefaultSshFuture<IoConnectFuture>
    implements IoConnectFuture {
        public DefaultIoConnectFuture(Object id, Object lock) {
            super(id, lock);
        }

        @Override
        public IoSession getSession() {
            Object v = this.getValue();
            return v instanceof IoSession ? (IoSession)v : null;
        }

        @Override
        public Throwable getException() {
            Object v = this.getValue();
            return v instanceof Throwable ? (Throwable)v : null;
        }

        @Override
        public boolean isConnected() {
            return this.getValue() instanceof IoSession;
        }

        @Override
        public void setSession(IoSession session) {
            this.setValue(session);
        }

        @Override
        public void setException(Throwable exception) {
            this.setValue(exception);
        }
    }

    protected class ConnectionCompletionHandler
    extends Nio2CompletionHandler<Void, Object> {
        protected final IoConnectFuture future;
        protected final AsynchronousSocketChannel socket;
        protected final AttributeRepository context;
        protected final PropertyResolver propertyResolver;
        protected final IoHandler handler;

        protected ConnectionCompletionHandler(IoConnectFuture future, AsynchronousSocketChannel socket, AttributeRepository context, PropertyResolver propertyResolver, IoHandler handler) {
            this.future = future;
            this.socket = socket;
            this.context = context;
            this.propertyResolver = propertyResolver;
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onCompleted(Void result2, Object attachment) {
            block13: {
                Long sessionId = null;
                IoServiceEventListener listener = Nio2Connector.this.getIoServiceEventListener();
                try {
                    if (listener != null) {
                        SocketAddress local = this.socket.getLocalAddress();
                        SocketAddress remote2 = this.socket.getRemoteAddress();
                        listener.connectionEstablished(Nio2Connector.this, local, this.context, remote2);
                    }
                    Nio2Session session = Nio2Connector.this.createSession(this.propertyResolver, this.handler, this.socket);
                    if (this.context != null) {
                        session.setAttribute(AttributeRepository.class, this.context);
                    }
                    this.handler.sessionCreated(session);
                    sessionId = session.getId();
                    Nio2Connector.this.sessions.put(sessionId, session);
                    this.future.setSession(session);
                    if (session.isClosing()) {
                        try {
                            this.handler.sessionClosed(session);
                            break block13;
                        }
                        finally {
                            Nio2Connector.this.unmapSession(sessionId);
                        }
                    }
                    session.startReading();
                }
                catch (Throwable exc) {
                    Throwable t;
                    block15: {
                        boolean debugEnabled;
                        block14: {
                            t = ExceptionUtils.peelException(exc);
                            debugEnabled = Nio2Connector.this.log.isDebugEnabled();
                            if (listener != null) {
                                try {
                                    SocketAddress localAddress = this.socket.getLocalAddress();
                                    SocketAddress remoteAddress = this.socket.getRemoteAddress();
                                    listener.abortEstablishedConnection(Nio2Connector.this, localAddress, this.context, remoteAddress, t);
                                }
                                catch (Exception e) {
                                    if (!debugEnabled) break block14;
                                    Nio2Connector.this.log.debug("onCompleted() listener=" + listener + " ignoring abort event exception", e);
                                }
                            }
                        }
                        Nio2Connector.this.debug("onCompleted - failed {} to start session: {}", t.getClass().getSimpleName(), t.getMessage(), t);
                        try {
                            this.socket.close();
                        }
                        catch (IOException err) {
                            if (!debugEnabled) break block15;
                            Nio2Connector.this.log.debug("onCompleted - failed {} to close socket: {}", (Object)err.getClass().getSimpleName(), (Object)err.getMessage());
                        }
                    }
                    this.future.setException(t);
                    Nio2Connector.this.unmapSession(sessionId);
                }
            }
        }

        @Override
        protected void onFailed(Throwable exc, Object attachment) {
            this.future.setException(exc);
        }
    }
}

