/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public final class MapEntryUtils {
    private static final Comparator<Map.Entry<Comparable, ?>> BY_KEY_COMPARATOR = (o1, o2) -> {
        Comparable k1 = (Comparable)o1.getKey();
        Comparable k2 = (Comparable)o2.getKey();
        return k1.compareTo(k2);
    };
    private static final Supplier CASE_INSENSITIVE_MAP_FACTORY = () -> new TreeMap(String.CASE_INSENSITIVE_ORDER);

    private MapEntryUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static <K extends Comparable<K>, V> Comparator<Map.Entry<K, V>> byKeyEntryComparator() {
        return BY_KEY_COMPARATOR;
    }

    public static int size(Map<?, ?> m) {
        return m == null ? 0 : m.size();
    }

    public static boolean isEmpty(Map<?, ?> m) {
        return MapEntryUtils.size(m) <= 0;
    }

    public static boolean isNotEmpty(Map<?, ?> m) {
        return !MapEntryUtils.isEmpty(m);
    }

    public static <V> Supplier<NavigableMap<String, V>> caseInsensitiveMap() {
        return CASE_INSENSITIVE_MAP_FACTORY;
    }

    public static <K, V, M extends Map<V, K>> M flipMap(Map<? extends K, ? extends V> map2, Supplier<? extends M> mapCreator, boolean allowDuplicates) {
        Map result2 = (Map)Objects.requireNonNull(mapCreator.get(), "No map created");
        map2.forEach((key, value) -> {
            Object prev = result2.put(value, key);
            if (prev != null && !allowDuplicates) {
                ValidateUtils.throwIllegalArgumentException("Multiple values for key=%s: current=%s, previous=%s", value, key, prev);
            }
        });
        return (M)result2;
    }

    @SafeVarargs
    public static <K, V, M extends Map<K, V>> M mapValues(Function<? super V, ? extends K> keyMapper, Supplier<? extends M> mapCreator, V ... values) {
        return MapEntryUtils.mapValues(keyMapper, mapCreator, GenericUtils.isEmpty(values) ? Collections.emptyList() : Arrays.asList(values));
    }

    public static <K, V, M extends Map<K, V>> M mapValues(Function<? super V, ? extends K> keyMapper, Supplier<? extends M> mapCreator, Collection<? extends V> values) {
        Map map2 = (Map)mapCreator.get();
        for (V v : values) {
            K k = keyMapper.apply(v);
            if (k == null) continue;
            map2.put(k, v);
        }
        return (M)map2;
    }

    public static <T, K, U> NavigableMap<K, U> toSortedMap(Iterable<? extends T> values, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, Comparator<? super K> comparator) {
        return GenericUtils.stream(values).collect(MapEntryUtils.toSortedMap(keyMapper, valueMapper, comparator));
    }

    public static <T, K, U> Collector<T, ?, NavigableMap<K, U>> toSortedMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, Comparator<? super K> comparator) {
        return Collectors.toMap(keyMapper, valueMapper, MapEntryUtils.throwingMerger(), () -> new TreeMap(comparator));
    }

    public static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }

    public static class EnumMapBuilder<K extends Enum<K>, V>
    extends GenericMapPopulator<K, V, Map<K, V>> {
        public EnumMapBuilder(Class<K> keyType) {
            super(new EnumMap(Objects.requireNonNull(keyType, "No enum class specified")));
        }

        public EnumMapBuilder<K, V> put(K k, V v) {
            super.put(k, v);
            return this;
        }

        public EnumMapBuilder<K, V> remove(K k) {
            super.remove(k);
            return this;
        }

        public EnumMapBuilder<K, V> putAll(Map<? extends K, ? extends V> other) {
            super.putAll(other);
            return this;
        }

        public EnumMapBuilder<K, V> clear() {
            super.clear();
            return this;
        }

        public Map<K, V> build() {
            return this.get();
        }

        public Map<K, V> immutable() {
            return Collections.unmodifiableMap(this.build());
        }

        public static <K extends Enum<K>, V> EnumMapBuilder<K, V> builder(Class<K> keyType) {
            return new EnumMapBuilder<K, V>(keyType);
        }
    }

    public static class NavigableMapBuilder<K, V>
    extends GenericMapPopulator<K, V, NavigableMap<K, V>> {
        public NavigableMapBuilder(Comparator<? super K> comparator) {
            super(new TreeMap(Objects.requireNonNull(comparator, "No comparator provided")));
        }

        public NavigableMapBuilder<K, V> put(K k, V v) {
            super.put(k, v);
            return this;
        }

        public NavigableMapBuilder<K, V> remove(K k) {
            super.remove(k);
            return this;
        }

        public NavigableMapBuilder<K, V> putAll(Map<? extends K, ? extends V> other) {
            super.putAll(other);
            return this;
        }

        public NavigableMapBuilder<K, V> clear() {
            super.clear();
            return this;
        }

        public NavigableMap<K, V> build() {
            return (NavigableMap)this.get();
        }

        public NavigableMap<K, V> immutable() {
            return Collections.unmodifiableNavigableMap(this.build());
        }

        public static <K extends Comparable<? super K>, V> NavigableMapBuilder<K, V> builder() {
            return NavigableMapBuilder.builder(Comparator.naturalOrder());
        }

        public static <K, V> NavigableMapBuilder<K, V> builder(Comparator<? super K> comparator) {
            return new NavigableMapBuilder<K, V>(comparator);
        }
    }

    public static class MapBuilder<K, V>
    extends GenericMapPopulator<K, V, Map<K, V>> {
        public MapBuilder() {
            super(new LinkedHashMap());
        }

        public MapBuilder<K, V> put(K k, V v) {
            super.put(k, v);
            return this;
        }

        public MapBuilder<K, V> remove(K k) {
            super.remove(k);
            return this;
        }

        public MapBuilder<K, V> putAll(Map<? extends K, ? extends V> other) {
            super.putAll(other);
            return this;
        }

        public MapBuilder<K, V> clear() {
            super.clear();
            return this;
        }

        public Map<K, V> build() {
            return this.get();
        }

        public Map<K, V> immutable() {
            return Collections.unmodifiableMap(this.build());
        }

        public static <K, V> MapBuilder<K, V> builder() {
            return new MapBuilder<K, V>();
        }
    }

    public static class GenericMapPopulator<K, V, M extends Map<K, V>>
    implements Supplier<M> {
        private final M map;

        public GenericMapPopulator(M map2) {
            this.map = (Map)Objects.requireNonNull(map2, "No map provided");
        }

        public GenericMapPopulator<K, V, M> put(K k, V v) {
            this.map.put(k, v);
            return this;
        }

        public GenericMapPopulator<K, V, M> remove(K k) {
            this.map.remove(k);
            return this;
        }

        public GenericMapPopulator<K, V, M> putAll(Map<? extends K, ? extends V> other) {
            this.map.putAll(other);
            return this;
        }

        public GenericMapPopulator<K, V, M> clear() {
            this.map.clear();
            return this;
        }

        @Override
        public M get() {
            return this.map;
        }
    }
}

