/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.util.GenericUtils;

public final class NumberUtils {
    public static final List<Class<?>> NUMERIC_PRIMITIVE_CLASSES = GenericUtils.unmodifiableList(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE);

    private NumberUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static int getNextPowerOf2(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Negative value N/A: " + value);
        }
        int j = 1;
        while (j < value) {
            if ((j <<= 1) > 0) continue;
            return value;
        }
        return j;
    }

    public static int hashCode(long ... values) {
        return Arrays.hashCode(values);
    }

    public static int hashCode(int ... values) {
        return Arrays.hashCode(values);
    }

    public static int hashCode(byte ... values) {
        return Arrays.hashCode(values);
    }

    public static int hashCode(byte[] a, int offset, int len) {
        if (len == 0) {
            return 0;
        }
        int result2 = 1;
        int pos = offset;
        for (int count2 = 0; count2 < len; ++count2) {
            byte element = a[pos];
            result2 = 31 * result2 + element;
            ++pos;
        }
        return result2;
    }

    public static int diffOffset(byte[] a1, int startPos1, byte[] a2, int startPos2, int len) {
        int pos1 = startPos1;
        int pos2 = startPos2;
        for (int count2 = 0; count2 < len; ++count2) {
            byte v1 = a1[pos1];
            byte v2 = a2[pos2];
            if (v1 != v2) {
                return count2;
            }
            ++pos1;
            ++pos2;
        }
        return -1;
    }

    public static boolean isNumericClass(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return true;
        }
        return NUMERIC_PRIMITIVE_CLASSES.indexOf(clazz) >= 0;
    }

    public static Integer toInteger(Number n) {
        if (n == null) {
            return null;
        }
        if (n instanceof Integer) {
            return (Integer)n;
        }
        return n.intValue();
    }

    public static String join(CharSequence separator, long ... values) {
        if (NumberUtils.isEmpty(values)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(values.length * 8);
        for (long v : values) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(v);
        }
        return sb.toString();
    }

    public static String join(char separator, long ... values) {
        if (NumberUtils.isEmpty(values)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(values.length * 8);
        for (long v : values) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(v);
        }
        return sb.toString();
    }

    public static String join(CharSequence separator, boolean unsigned, byte ... values) {
        if (NumberUtils.isEmpty(values)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(values.length * 8);
        for (int n : values) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(unsigned ? n & 0xFF : n);
        }
        return sb.toString();
    }

    public static String join(char separator, boolean unsigned, byte ... values) {
        if (NumberUtils.isEmpty(values)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(values.length * 8);
        for (int n : values) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(unsigned ? n & 0xFF : n);
        }
        return sb.toString();
    }

    public static String join(CharSequence separator, int ... values) {
        if (NumberUtils.isEmpty(values)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(values.length * 8);
        for (int v : values) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(v);
        }
        return sb.toString();
    }

    public static String join(char separator, int ... values) {
        if (NumberUtils.isEmpty(values)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(values.length * 8);
        for (int v : values) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(v);
        }
        return sb.toString();
    }

    public static byte[] emptyIfNull(byte[] a) {
        return a == null ? GenericUtils.EMPTY_BYTE_ARRAY : a;
    }

    public static boolean isEmpty(byte[] a) {
        return NumberUtils.length(a) <= 0;
    }

    public static boolean isEmpty(int[] a) {
        return NumberUtils.length(a) <= 0;
    }

    public static boolean isEmpty(long[] a) {
        return NumberUtils.length(a) <= 0;
    }

    public static int length(byte ... a) {
        return a == null ? 0 : a.length;
    }

    public static int length(int ... a) {
        return a == null ? 0 : a.length;
    }

    public static int length(long ... a) {
        return a == null ? 0 : a.length;
    }

    public static List<Integer> asList(int ... values) {
        int len = NumberUtils.length(values);
        if (len <= 0) {
            return Collections.emptyList();
        }
        ArrayList<Integer> l = new ArrayList<Integer>(len);
        for (int v : values) {
            l.add(v);
        }
        return l;
    }

    public static boolean isIntegerNumber(CharSequence cs) {
        if (GenericUtils.isEmpty(cs)) {
            return false;
        }
        int len = cs.length();
        for (int index = 0; index < len; ++index) {
            char c = cs.charAt(index);
            if (c >= '0' && c <= '9' || (c == '+' || c == '-') && index == 0) continue;
            return false;
        }
        return true;
    }
}

