/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.session;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.ServiceFactory;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.io.IoService;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.kex.KexFactoryManager;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.KexState;
import org.apache.sshd.common.kex.extension.KexExtensionHandler;
import org.apache.sshd.common.keyprovider.HostKeyCertificateProvider;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.session.SessionDisconnectHandler;
import org.apache.sshd.common.session.helpers.AbstractSession;
import org.apache.sshd.common.signature.SignatureFactory;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.ServerAuthenticationManager;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.auth.UserAuthFactory;
import org.apache.sshd.server.auth.WelcomeBannerPhase;
import org.apache.sshd.server.auth.gss.GSSAuthenticator;
import org.apache.sshd.server.auth.hostbased.HostBasedAuthenticator;
import org.apache.sshd.server.auth.keyboard.KeyboardInteractiveAuthenticator;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerProxyAcceptor;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.session.ServerUserAuthService;

public abstract class AbstractServerSession
extends AbstractSession
implements ServerSession {
    private ServerProxyAcceptor proxyAcceptor;
    private SocketAddress clientAddress;
    private PasswordAuthenticator passwordAuthenticator;
    private PublickeyAuthenticator publickeyAuthenticator;
    private KeyboardInteractiveAuthenticator interactiveAuthenticator;
    private GSSAuthenticator gssAuthenticator;
    private HostBasedAuthenticator hostBasedAuthenticator;
    private List<UserAuthFactory> userAuthFactories;
    private KeyPairProvider keyPairProvider;
    private HostKeyCertificateProvider hostKeyCertificateProvider;

    protected AbstractServerSession(ServerFactoryManager factoryManager, IoSession ioSession) {
        super(true, factoryManager, ioSession);
    }

    @Override
    public ServerFactoryManager getFactoryManager() {
        return (ServerFactoryManager)super.getFactoryManager();
    }

    @Override
    public ServerProxyAcceptor getServerProxyAcceptor() {
        return this.resolveEffectiveProvider(ServerProxyAcceptor.class, this.proxyAcceptor, this.getFactoryManager().getServerProxyAcceptor());
    }

    @Override
    public void setServerProxyAcceptor(ServerProxyAcceptor proxyAcceptor) {
        this.proxyAcceptor = proxyAcceptor;
    }

    @Override
    public SocketAddress getClientAddress() {
        return this.resolvePeerAddress(this.clientAddress);
    }

    public void setClientAddress(SocketAddress clientAddress) {
        this.clientAddress = clientAddress;
    }

    @Override
    public PasswordAuthenticator getPasswordAuthenticator() {
        ServerFactoryManager manager = this.getFactoryManager();
        return this.resolveEffectiveProvider(PasswordAuthenticator.class, this.passwordAuthenticator, manager.getPasswordAuthenticator());
    }

    @Override
    public void setPasswordAuthenticator(PasswordAuthenticator passwordAuthenticator) {
        this.passwordAuthenticator = passwordAuthenticator;
    }

    @Override
    public PublickeyAuthenticator getPublickeyAuthenticator() {
        ServerFactoryManager manager = this.getFactoryManager();
        return this.resolveEffectiveProvider(PublickeyAuthenticator.class, this.publickeyAuthenticator, manager.getPublickeyAuthenticator());
    }

    @Override
    public void setPublickeyAuthenticator(PublickeyAuthenticator publickeyAuthenticator) {
        this.publickeyAuthenticator = publickeyAuthenticator;
    }

    @Override
    public KeyboardInteractiveAuthenticator getKeyboardInteractiveAuthenticator() {
        ServerFactoryManager manager = this.getFactoryManager();
        return this.resolveEffectiveProvider(KeyboardInteractiveAuthenticator.class, this.interactiveAuthenticator, manager.getKeyboardInteractiveAuthenticator());
    }

    @Override
    public void setKeyboardInteractiveAuthenticator(KeyboardInteractiveAuthenticator interactiveAuthenticator) {
        this.interactiveAuthenticator = interactiveAuthenticator;
    }

    @Override
    public GSSAuthenticator getGSSAuthenticator() {
        ServerFactoryManager manager = this.getFactoryManager();
        return this.resolveEffectiveProvider(GSSAuthenticator.class, this.gssAuthenticator, manager.getGSSAuthenticator());
    }

    @Override
    public void setGSSAuthenticator(GSSAuthenticator gssAuthenticator) {
        this.gssAuthenticator = gssAuthenticator;
    }

    @Override
    public HostBasedAuthenticator getHostBasedAuthenticator() {
        ServerFactoryManager manager = this.getFactoryManager();
        return this.resolveEffectiveProvider(HostBasedAuthenticator.class, this.hostBasedAuthenticator, manager.getHostBasedAuthenticator());
    }

    @Override
    public void setHostBasedAuthenticator(HostBasedAuthenticator hostBasedAuthenticator) {
        this.hostBasedAuthenticator = hostBasedAuthenticator;
    }

    @Override
    public List<UserAuthFactory> getUserAuthFactories() {
        ServerFactoryManager manager = this.getFactoryManager();
        return this.resolveEffectiveFactories(this.userAuthFactories, manager.getUserAuthFactories());
    }

    @Override
    public void setUserAuthFactories(List<UserAuthFactory> userAuthFactories) {
        this.userAuthFactories = userAuthFactories;
    }

    @Override
    public KeyPairProvider getKeyPairProvider() {
        KexFactoryManager parent = this.getDelegate();
        return this.resolveEffectiveProvider(KeyPairProvider.class, this.keyPairProvider, parent == null ? null : ((ServerAuthenticationManager)((Object)parent)).getKeyPairProvider());
    }

    @Override
    public HostKeyCertificateProvider getHostKeyCertificateProvider() {
        ServerFactoryManager manager = this.getFactoryManager();
        return this.resolveEffectiveProvider(HostKeyCertificateProvider.class, this.hostKeyCertificateProvider, manager.getHostKeyCertificateProvider());
    }

    @Override
    public void setHostKeyCertificateProvider(HostKeyCertificateProvider hostKeyCertificateProvider) {
        this.hostKeyCertificateProvider = hostKeyCertificateProvider;
    }

    @Override
    public void setKeyPairProvider(KeyPairProvider keyPairProvider) {
        this.keyPairProvider = keyPairProvider;
    }

    protected IoWriteFuture sendServerIdentification(List<String> headerLines) throws Exception {
        this.serverVersion = this.resolveIdentificationString(CoreModuleProperties.SERVER_IDENTIFICATION.getName());
        this.signalSendIdentification(this.serverVersion, headerLines);
        return this.sendIdentification(this.serverVersion, headerLines);
    }

    @Override
    protected void checkKeys() {
    }

    @Override
    protected boolean handleServiceRequest(String serviceName, Buffer buffer) throws Exception {
        ServerUserAuthService authService;
        boolean started = super.handleServiceRequest(serviceName, buffer);
        if (!started) {
            return false;
        }
        if ("ssh-userauth".equals(serviceName) && this.currentService instanceof ServerUserAuthService && WelcomeBannerPhase.IMMEDIATE.equals((Object)(authService = (ServerUserAuthService)this.currentService).getWelcomePhase())) {
            authService.sendWelcomeBanner(this);
        }
        return true;
    }

    @Override
    public void startService(String name, Buffer buffer) throws Exception {
        ServerFactoryManager factoryManager = this.getFactoryManager();
        this.currentService = ServiceFactory.create(factoryManager.getServiceFactories(), ValidateUtils.checkNotNullAndNotEmpty(name, "No service name specified"), this);
        if (this.currentService == null) {
            try {
                SessionDisconnectHandler handler = this.getSessionDisconnectHandler();
                if (handler != null && handler.handleUnsupportedServiceDisconnectReason(this, 5, name, buffer)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("startService({}) ignore unknown service={} by handler", (Object)this, (Object)name);
                    }
                    return;
                }
            }
            catch (IOException | RuntimeException e) {
                this.warn("startService({})[{}] failed ({}) to invoke disconnect handler: {}", this, name, e.getClass().getSimpleName(), e.getMessage(), e);
            }
            throw new SshException(7, "Unknown service: " + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoWriteFuture signalAuthenticationSuccess(String username, String authService, Buffer buffer) throws Exception {
        IoWriteFuture future;
        KexState curState = (KexState)((Object)this.kexState.get());
        if (!KexState.DONE.equals((Object)curState)) {
            throw new SshException(2, "Authentication success signalled though KEX state=" + (Object)((Object)curState));
        }
        KexExtensionHandler extHandler = this.getKexExtensionHandler();
        if (extHandler != null && extHandler.isKexExtensionsAvailable(this, KexExtensionHandler.AvailabilityPhase.AUTHOK)) {
            extHandler.sendKexExtensions(this, KexExtensionHandler.KexPhase.AUTHOK);
        }
        Buffer response = this.createBuffer((byte)52, 8);
        IoSession networkSession = this.getIoSession();
        Object object = this.encodeLock;
        synchronized (object) {
            Buffer packet = this.resolveOutputPacket(response);
            this.setUsername(username);
            this.setAuthenticated();
            this.startService(authService, buffer);
            future = networkSession.writeBuffer(packet);
        }
        this.resetIdleTimeout();
        this.log.info("Session {}@{} authenticated", (Object)username, (Object)networkSession.getRemoteAddress());
        return future;
    }

    @Override
    protected void handleServiceAccept(String serviceName, Buffer buffer) throws Exception {
        super.handleServiceAccept(serviceName, buffer);
        try {
            SessionDisconnectHandler handler = this.getSessionDisconnectHandler();
            if (handler != null && handler.handleUnsupportedServiceDisconnectReason(this, 6, serviceName, buffer)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("handleServiceAccept({}) ignore unknown service={} by handler", (Object)this, (Object)serviceName);
                }
                return;
            }
        }
        catch (IOException | RuntimeException e) {
            this.warn("handleServiceAccept({}) failed ({}) to invoke disconnect handler of unknown service={}: {}", this, e.getClass().getSimpleName(), serviceName, e.getMessage(), e);
        }
        this.disconnect(2, "Unsupported packet: SSH_MSG_SERVICE_ACCEPT for " + serviceName);
    }

    @Override
    protected byte[] sendKexInit(Map<KexProposalOption, String> proposal) throws Exception {
        this.mergeProposals(this.serverProposal, proposal);
        return super.sendKexInit(proposal);
    }

    @Override
    protected void setKexSeed(byte ... seed) {
        this.setServerKexData(seed);
    }

    @Override
    protected String resolveAvailableSignaturesProposal(FactoryManager proposedManager) throws IOException, GeneralSecurityException {
        ValidateUtils.checkTrue(proposedManager == this.getFactoryManager(), "Mismatched signatures proposed factory manager");
        KeyPairProvider kpp = this.getKeyPairProvider();
        Collection provided = null;
        try {
            if (kpp != null) {
                provided = GenericUtils.stream(kpp.getKeyTypes(this)).collect(Collectors.toSet());
                HostKeyCertificateProvider hostKeyCertificateProvider = this.getHostKeyCertificateProvider();
                if (hostKeyCertificateProvider != null) {
                    Iterable<OpenSshCertificate> certificates = hostKeyCertificateProvider.loadCertificates(this);
                    for (OpenSshCertificate certificate : certificates) {
                        String rawKeyType = certificate.getRawKeyType();
                        if (provided.contains(rawKeyType)) {
                            provided.add(certificate.getKeyType());
                            continue;
                        }
                        this.log.info("resolveAvailableSignaturesProposal({}) No private key of type={} available in provided certificate", (Object)this, (Object)rawKeyType);
                    }
                }
            }
        }
        catch (Error e) {
            this.warn("resolveAvailableSignaturesProposal({}) failed ({}) to get key types: {}", this, e.getClass().getSimpleName(), e.getMessage(), e);
            throw new RuntimeSshException(e);
        }
        List<String> available = NamedResource.getNameList(this.getSignatureFactories());
        if (provided == null || GenericUtils.isEmpty(available)) {
            return this.resolveEmptySignaturesProposal(available, provided);
        }
        List<String> supported = SignatureFactory.resolveSignatureFactoryNamesProposal(provided, available);
        if (GenericUtils.isEmpty(supported)) {
            return this.resolveEmptySignaturesProposal(available, provided);
        }
        return GenericUtils.join(supported, ',');
    }

    protected String resolveEmptySignaturesProposal(Iterable<String> supported, Iterable<String> provided) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("resolveEmptySignaturesProposal({})[{}] none of the keys appears in supported list: {}", this, provided, supported);
        }
        return null;
    }

    @Override
    protected boolean readIdentification(Buffer buffer) throws Exception {
        SshException err;
        List<String> ident;
        int numLines;
        ServerProxyAcceptor acceptor = this.getServerProxyAcceptor();
        int rpos = buffer.rpos();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (acceptor != null) {
            try {
                boolean completed = acceptor.acceptServerProxyMetadata(this, buffer);
                if (!completed) {
                    buffer.rpos(rpos);
                    return false;
                }
            }
            catch (Throwable t) {
                this.warn("readIdentification({}) failed ({}) to accept proxy metadata: {}", this, t.getClass().getSimpleName(), t.getMessage(), t);
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw new SshException(t);
            }
        }
        String string2 = this.clientVersion = (numLines = GenericUtils.size(ident = this.doReadIdentification(buffer, true))) <= 0 ? null : ident.remove(numLines - 1);
        if (GenericUtils.isEmpty(this.clientVersion)) {
            buffer.rpos(rpos);
            return false;
        }
        if (debugEnabled) {
            this.log.debug("readIdentification({}) client version string: {}", (Object)this, (Object)this.clientVersion);
        }
        if ((err = SessionContext.isValidVersionPrefix(this.clientVersion) ? (numLines > 1 ? new SshException(2, "Unexpected extra " + (numLines - 1) + " lines from client=" + this.clientVersion) : null) : new SshException(8, "Unsupported protocol version: " + this.clientVersion)) != null) {
            IoSession networkSession = this.getIoSession();
            networkSession.writeBuffer(new ByteArrayBuffer((err.getMessage() + "\n").getBytes(StandardCharsets.UTF_8))).addListener(future -> this.close(true));
            throw err;
        }
        this.signalPeerIdentificationReceived(this.clientVersion, ident);
        this.kexState.set(KexState.INIT);
        this.sendKexInit();
        return true;
    }

    @Override
    protected void receiveKexInit(Map<KexProposalOption, String> proposal, byte[] seed) throws IOException {
        this.mergeProposals(this.clientProposal, proposal);
        this.setClientKexData(seed);
    }

    @Override
    public KeyPair getHostKey() {
        String proposedKey = this.getNegotiatedKexParameter(KexProposalOption.SERVERKEYS);
        String keyType = KeyUtils.getCanonicalKeyType(proposedKey);
        if (GenericUtils.isEmpty(keyType)) {
            return null;
        }
        KeyPairProvider provider = Objects.requireNonNull(this.getKeyPairProvider(), "No host keys provider");
        try {
            OpenSshCertificate publicKey;
            HostKeyCertificateProvider hostKeyCertificateProvider = this.getHostKeyCertificateProvider();
            if (hostKeyCertificateProvider != null && (publicKey = hostKeyCertificateProvider.loadCertificate(this, keyType)) != null) {
                String rawKeyType = publicKey.getRawKeyType();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("getHostKey({}) using certified key {}/{} with ID={}", this, keyType, rawKeyType, publicKey.getId());
                }
                KeyPair keyPair = provider.loadKey(this, rawKeyType);
                ValidateUtils.checkNotNull(keyPair, "No certified private key of type=%s available", (Object)rawKeyType);
                return new KeyPair(publicKey, keyPair.getPrivate());
            }
            return provider.loadKey(this, keyType);
        }
        catch (IOException | Error | GeneralSecurityException e) {
            this.warn("getHostKey({}) failed ({}) to load key of type={}[{}]: {}", this, e.getClass().getSimpleName(), proposedKey, keyType, e.getMessage(), e);
            throw new RuntimeSshException(e);
        }
    }

    @Override
    public int getActiveSessionCountForUser(String userName) {
        if (GenericUtils.isEmpty(userName)) {
            return 0;
        }
        IoSession networkSession = this.getIoSession();
        IoService service = networkSession.getService();
        Map<Long, IoSession> sessionsMap = service.getManagedSessions();
        if (MapEntryUtils.isEmpty(sessionsMap)) {
            return 0;
        }
        int totalCount = 0;
        for (IoSession is : sessionsMap.values()) {
            String sessionUser;
            ServerSession session = (ServerSession)((Object)AbstractServerSession.getSession(is, true));
            if (session == null || GenericUtils.isEmpty(sessionUser = session.getUsername()) || !Objects.equals(sessionUser, userName)) continue;
            ++totalCount;
        }
        return totalCount;
    }

    public long getId() {
        IoSession networkSession = this.getIoSession();
        return networkSession.getId();
    }

    @Override
    protected ConnectionService getConnectionService() {
        return this.currentService instanceof ConnectionService ? (ConnectionService)this.currentService : null;
    }
}

