/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.dynamodbv2.model.ArchivalSummary;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.BillingModeSummary;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughputDescription;
import com.amazonaws.services.dynamodbv2.model.ReplicaDescription;
import com.amazonaws.services.dynamodbv2.model.RestoreSummary;
import com.amazonaws.services.dynamodbv2.model.SSEDescription;
import com.amazonaws.services.dynamodbv2.model.StreamSpecification;
import com.amazonaws.services.dynamodbv2.model.TableStatus;
import com.amazonaws.services.dynamodbv2.model.transform.TableDescriptionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class TableDescription
implements Serializable,
Cloneable,
StructuredPojo {
    private List<AttributeDefinition> attributeDefinitions;
    private String tableName;
    private List<KeySchemaElement> keySchema;
    private String tableStatus;
    private Date creationDateTime;
    private ProvisionedThroughputDescription provisionedThroughput;
    private Long tableSizeBytes;
    private Long itemCount;
    private String tableArn;
    private String tableId;
    private BillingModeSummary billingModeSummary;
    private List<LocalSecondaryIndexDescription> localSecondaryIndexes;
    private List<GlobalSecondaryIndexDescription> globalSecondaryIndexes;
    private StreamSpecification streamSpecification;
    private String latestStreamLabel;
    private String latestStreamArn;
    private String globalTableVersion;
    private List<ReplicaDescription> replicas;
    private RestoreSummary restoreSummary;
    private SSEDescription sSEDescription;
    private ArchivalSummary archivalSummary;

    public List<AttributeDefinition> getAttributeDefinitions() {
        return this.attributeDefinitions;
    }

    public void setAttributeDefinitions(Collection<AttributeDefinition> attributeDefinitions) {
        if (attributeDefinitions == null) {
            this.attributeDefinitions = null;
            return;
        }
        this.attributeDefinitions = new ArrayList<AttributeDefinition>(attributeDefinitions);
    }

    public TableDescription withAttributeDefinitions(AttributeDefinition ... attributeDefinitions) {
        if (this.attributeDefinitions == null) {
            this.setAttributeDefinitions(new ArrayList<AttributeDefinition>(attributeDefinitions.length));
        }
        for (AttributeDefinition ele : attributeDefinitions) {
            this.attributeDefinitions.add(ele);
        }
        return this;
    }

    public TableDescription withAttributeDefinitions(Collection<AttributeDefinition> attributeDefinitions) {
        this.setAttributeDefinitions(attributeDefinitions);
        return this;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public TableDescription withTableName(String tableName) {
        this.setTableName(tableName);
        return this;
    }

    public List<KeySchemaElement> getKeySchema() {
        return this.keySchema;
    }

    public void setKeySchema(Collection<KeySchemaElement> keySchema) {
        if (keySchema == null) {
            this.keySchema = null;
            return;
        }
        this.keySchema = new ArrayList<KeySchemaElement>(keySchema);
    }

    public TableDescription withKeySchema(KeySchemaElement ... keySchema) {
        if (this.keySchema == null) {
            this.setKeySchema(new ArrayList<KeySchemaElement>(keySchema.length));
        }
        for (KeySchemaElement ele : keySchema) {
            this.keySchema.add(ele);
        }
        return this;
    }

    public TableDescription withKeySchema(Collection<KeySchemaElement> keySchema) {
        this.setKeySchema(keySchema);
        return this;
    }

    public void setTableStatus(String tableStatus) {
        this.tableStatus = tableStatus;
    }

    public String getTableStatus() {
        return this.tableStatus;
    }

    public TableDescription withTableStatus(String tableStatus) {
        this.setTableStatus(tableStatus);
        return this;
    }

    public void setTableStatus(TableStatus tableStatus) {
        this.withTableStatus(tableStatus);
    }

    public TableDescription withTableStatus(TableStatus tableStatus) {
        this.tableStatus = tableStatus.toString();
        return this;
    }

    public void setCreationDateTime(Date creationDateTime) {
        this.creationDateTime = creationDateTime;
    }

    public Date getCreationDateTime() {
        return this.creationDateTime;
    }

    public TableDescription withCreationDateTime(Date creationDateTime) {
        this.setCreationDateTime(creationDateTime);
        return this;
    }

    public void setProvisionedThroughput(ProvisionedThroughputDescription provisionedThroughput) {
        this.provisionedThroughput = provisionedThroughput;
    }

    public ProvisionedThroughputDescription getProvisionedThroughput() {
        return this.provisionedThroughput;
    }

    public TableDescription withProvisionedThroughput(ProvisionedThroughputDescription provisionedThroughput) {
        this.setProvisionedThroughput(provisionedThroughput);
        return this;
    }

    public void setTableSizeBytes(Long tableSizeBytes) {
        this.tableSizeBytes = tableSizeBytes;
    }

    public Long getTableSizeBytes() {
        return this.tableSizeBytes;
    }

    public TableDescription withTableSizeBytes(Long tableSizeBytes) {
        this.setTableSizeBytes(tableSizeBytes);
        return this;
    }

    public void setItemCount(Long itemCount) {
        this.itemCount = itemCount;
    }

    public Long getItemCount() {
        return this.itemCount;
    }

    public TableDescription withItemCount(Long itemCount) {
        this.setItemCount(itemCount);
        return this;
    }

    public void setTableArn(String tableArn) {
        this.tableArn = tableArn;
    }

    public String getTableArn() {
        return this.tableArn;
    }

    public TableDescription withTableArn(String tableArn) {
        this.setTableArn(tableArn);
        return this;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public String getTableId() {
        return this.tableId;
    }

    public TableDescription withTableId(String tableId) {
        this.setTableId(tableId);
        return this;
    }

    public void setBillingModeSummary(BillingModeSummary billingModeSummary) {
        this.billingModeSummary = billingModeSummary;
    }

    public BillingModeSummary getBillingModeSummary() {
        return this.billingModeSummary;
    }

    public TableDescription withBillingModeSummary(BillingModeSummary billingModeSummary) {
        this.setBillingModeSummary(billingModeSummary);
        return this;
    }

    public List<LocalSecondaryIndexDescription> getLocalSecondaryIndexes() {
        return this.localSecondaryIndexes;
    }

    public void setLocalSecondaryIndexes(Collection<LocalSecondaryIndexDescription> localSecondaryIndexes) {
        if (localSecondaryIndexes == null) {
            this.localSecondaryIndexes = null;
            return;
        }
        this.localSecondaryIndexes = new ArrayList<LocalSecondaryIndexDescription>(localSecondaryIndexes);
    }

    public TableDescription withLocalSecondaryIndexes(LocalSecondaryIndexDescription ... localSecondaryIndexes) {
        if (this.localSecondaryIndexes == null) {
            this.setLocalSecondaryIndexes(new ArrayList<LocalSecondaryIndexDescription>(localSecondaryIndexes.length));
        }
        for (LocalSecondaryIndexDescription ele : localSecondaryIndexes) {
            this.localSecondaryIndexes.add(ele);
        }
        return this;
    }

    public TableDescription withLocalSecondaryIndexes(Collection<LocalSecondaryIndexDescription> localSecondaryIndexes) {
        this.setLocalSecondaryIndexes(localSecondaryIndexes);
        return this;
    }

    public List<GlobalSecondaryIndexDescription> getGlobalSecondaryIndexes() {
        return this.globalSecondaryIndexes;
    }

    public void setGlobalSecondaryIndexes(Collection<GlobalSecondaryIndexDescription> globalSecondaryIndexes) {
        if (globalSecondaryIndexes == null) {
            this.globalSecondaryIndexes = null;
            return;
        }
        this.globalSecondaryIndexes = new ArrayList<GlobalSecondaryIndexDescription>(globalSecondaryIndexes);
    }

    public TableDescription withGlobalSecondaryIndexes(GlobalSecondaryIndexDescription ... globalSecondaryIndexes) {
        if (this.globalSecondaryIndexes == null) {
            this.setGlobalSecondaryIndexes(new ArrayList<GlobalSecondaryIndexDescription>(globalSecondaryIndexes.length));
        }
        for (GlobalSecondaryIndexDescription ele : globalSecondaryIndexes) {
            this.globalSecondaryIndexes.add(ele);
        }
        return this;
    }

    public TableDescription withGlobalSecondaryIndexes(Collection<GlobalSecondaryIndexDescription> globalSecondaryIndexes) {
        this.setGlobalSecondaryIndexes(globalSecondaryIndexes);
        return this;
    }

    public void setStreamSpecification(StreamSpecification streamSpecification) {
        this.streamSpecification = streamSpecification;
    }

    public StreamSpecification getStreamSpecification() {
        return this.streamSpecification;
    }

    public TableDescription withStreamSpecification(StreamSpecification streamSpecification) {
        this.setStreamSpecification(streamSpecification);
        return this;
    }

    public void setLatestStreamLabel(String latestStreamLabel) {
        this.latestStreamLabel = latestStreamLabel;
    }

    public String getLatestStreamLabel() {
        return this.latestStreamLabel;
    }

    public TableDescription withLatestStreamLabel(String latestStreamLabel) {
        this.setLatestStreamLabel(latestStreamLabel);
        return this;
    }

    public void setLatestStreamArn(String latestStreamArn) {
        this.latestStreamArn = latestStreamArn;
    }

    public String getLatestStreamArn() {
        return this.latestStreamArn;
    }

    public TableDescription withLatestStreamArn(String latestStreamArn) {
        this.setLatestStreamArn(latestStreamArn);
        return this;
    }

    public void setGlobalTableVersion(String globalTableVersion) {
        this.globalTableVersion = globalTableVersion;
    }

    public String getGlobalTableVersion() {
        return this.globalTableVersion;
    }

    public TableDescription withGlobalTableVersion(String globalTableVersion) {
        this.setGlobalTableVersion(globalTableVersion);
        return this;
    }

    public List<ReplicaDescription> getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Collection<ReplicaDescription> replicas) {
        if (replicas == null) {
            this.replicas = null;
            return;
        }
        this.replicas = new ArrayList<ReplicaDescription>(replicas);
    }

    public TableDescription withReplicas(ReplicaDescription ... replicas) {
        if (this.replicas == null) {
            this.setReplicas(new ArrayList<ReplicaDescription>(replicas.length));
        }
        for (ReplicaDescription ele : replicas) {
            this.replicas.add(ele);
        }
        return this;
    }

    public TableDescription withReplicas(Collection<ReplicaDescription> replicas) {
        this.setReplicas(replicas);
        return this;
    }

    public void setRestoreSummary(RestoreSummary restoreSummary) {
        this.restoreSummary = restoreSummary;
    }

    public RestoreSummary getRestoreSummary() {
        return this.restoreSummary;
    }

    public TableDescription withRestoreSummary(RestoreSummary restoreSummary) {
        this.setRestoreSummary(restoreSummary);
        return this;
    }

    public void setSSEDescription(SSEDescription sSEDescription) {
        this.sSEDescription = sSEDescription;
    }

    public SSEDescription getSSEDescription() {
        return this.sSEDescription;
    }

    public TableDescription withSSEDescription(SSEDescription sSEDescription) {
        this.setSSEDescription(sSEDescription);
        return this;
    }

    public void setArchivalSummary(ArchivalSummary archivalSummary) {
        this.archivalSummary = archivalSummary;
    }

    public ArchivalSummary getArchivalSummary() {
        return this.archivalSummary;
    }

    public TableDescription withArchivalSummary(ArchivalSummary archivalSummary) {
        this.setArchivalSummary(archivalSummary);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttributeDefinitions() != null) {
            sb.append("AttributeDefinitions: ").append(this.getAttributeDefinitions()).append(",");
        }
        if (this.getTableName() != null) {
            sb.append("TableName: ").append(this.getTableName()).append(",");
        }
        if (this.getKeySchema() != null) {
            sb.append("KeySchema: ").append(this.getKeySchema()).append(",");
        }
        if (this.getTableStatus() != null) {
            sb.append("TableStatus: ").append(this.getTableStatus()).append(",");
        }
        if (this.getCreationDateTime() != null) {
            sb.append("CreationDateTime: ").append(this.getCreationDateTime()).append(",");
        }
        if (this.getProvisionedThroughput() != null) {
            sb.append("ProvisionedThroughput: ").append(this.getProvisionedThroughput()).append(",");
        }
        if (this.getTableSizeBytes() != null) {
            sb.append("TableSizeBytes: ").append(this.getTableSizeBytes()).append(",");
        }
        if (this.getItemCount() != null) {
            sb.append("ItemCount: ").append(this.getItemCount()).append(",");
        }
        if (this.getTableArn() != null) {
            sb.append("TableArn: ").append(this.getTableArn()).append(",");
        }
        if (this.getTableId() != null) {
            sb.append("TableId: ").append(this.getTableId()).append(",");
        }
        if (this.getBillingModeSummary() != null) {
            sb.append("BillingModeSummary: ").append(this.getBillingModeSummary()).append(",");
        }
        if (this.getLocalSecondaryIndexes() != null) {
            sb.append("LocalSecondaryIndexes: ").append(this.getLocalSecondaryIndexes()).append(",");
        }
        if (this.getGlobalSecondaryIndexes() != null) {
            sb.append("GlobalSecondaryIndexes: ").append(this.getGlobalSecondaryIndexes()).append(",");
        }
        if (this.getStreamSpecification() != null) {
            sb.append("StreamSpecification: ").append(this.getStreamSpecification()).append(",");
        }
        if (this.getLatestStreamLabel() != null) {
            sb.append("LatestStreamLabel: ").append(this.getLatestStreamLabel()).append(",");
        }
        if (this.getLatestStreamArn() != null) {
            sb.append("LatestStreamArn: ").append(this.getLatestStreamArn()).append(",");
        }
        if (this.getGlobalTableVersion() != null) {
            sb.append("GlobalTableVersion: ").append(this.getGlobalTableVersion()).append(",");
        }
        if (this.getReplicas() != null) {
            sb.append("Replicas: ").append(this.getReplicas()).append(",");
        }
        if (this.getRestoreSummary() != null) {
            sb.append("RestoreSummary: ").append(this.getRestoreSummary()).append(",");
        }
        if (this.getSSEDescription() != null) {
            sb.append("SSEDescription: ").append(this.getSSEDescription()).append(",");
        }
        if (this.getArchivalSummary() != null) {
            sb.append("ArchivalSummary: ").append(this.getArchivalSummary());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableDescription)) {
            return false;
        }
        TableDescription other = (TableDescription)obj;
        if (other.getAttributeDefinitions() == null ^ this.getAttributeDefinitions() == null) {
            return false;
        }
        if (other.getAttributeDefinitions() != null && !other.getAttributeDefinitions().equals(this.getAttributeDefinitions())) {
            return false;
        }
        if (other.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (other.getTableName() != null && !other.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (other.getKeySchema() == null ^ this.getKeySchema() == null) {
            return false;
        }
        if (other.getKeySchema() != null && !other.getKeySchema().equals(this.getKeySchema())) {
            return false;
        }
        if (other.getTableStatus() == null ^ this.getTableStatus() == null) {
            return false;
        }
        if (other.getTableStatus() != null && !other.getTableStatus().equals(this.getTableStatus())) {
            return false;
        }
        if (other.getCreationDateTime() == null ^ this.getCreationDateTime() == null) {
            return false;
        }
        if (other.getCreationDateTime() != null && !other.getCreationDateTime().equals(this.getCreationDateTime())) {
            return false;
        }
        if (other.getProvisionedThroughput() == null ^ this.getProvisionedThroughput() == null) {
            return false;
        }
        if (other.getProvisionedThroughput() != null && !other.getProvisionedThroughput().equals(this.getProvisionedThroughput())) {
            return false;
        }
        if (other.getTableSizeBytes() == null ^ this.getTableSizeBytes() == null) {
            return false;
        }
        if (other.getTableSizeBytes() != null && !other.getTableSizeBytes().equals(this.getTableSizeBytes())) {
            return false;
        }
        if (other.getItemCount() == null ^ this.getItemCount() == null) {
            return false;
        }
        if (other.getItemCount() != null && !other.getItemCount().equals(this.getItemCount())) {
            return false;
        }
        if (other.getTableArn() == null ^ this.getTableArn() == null) {
            return false;
        }
        if (other.getTableArn() != null && !other.getTableArn().equals(this.getTableArn())) {
            return false;
        }
        if (other.getTableId() == null ^ this.getTableId() == null) {
            return false;
        }
        if (other.getTableId() != null && !other.getTableId().equals(this.getTableId())) {
            return false;
        }
        if (other.getBillingModeSummary() == null ^ this.getBillingModeSummary() == null) {
            return false;
        }
        if (other.getBillingModeSummary() != null && !other.getBillingModeSummary().equals(this.getBillingModeSummary())) {
            return false;
        }
        if (other.getLocalSecondaryIndexes() == null ^ this.getLocalSecondaryIndexes() == null) {
            return false;
        }
        if (other.getLocalSecondaryIndexes() != null && !other.getLocalSecondaryIndexes().equals(this.getLocalSecondaryIndexes())) {
            return false;
        }
        if (other.getGlobalSecondaryIndexes() == null ^ this.getGlobalSecondaryIndexes() == null) {
            return false;
        }
        if (other.getGlobalSecondaryIndexes() != null && !other.getGlobalSecondaryIndexes().equals(this.getGlobalSecondaryIndexes())) {
            return false;
        }
        if (other.getStreamSpecification() == null ^ this.getStreamSpecification() == null) {
            return false;
        }
        if (other.getStreamSpecification() != null && !other.getStreamSpecification().equals(this.getStreamSpecification())) {
            return false;
        }
        if (other.getLatestStreamLabel() == null ^ this.getLatestStreamLabel() == null) {
            return false;
        }
        if (other.getLatestStreamLabel() != null && !other.getLatestStreamLabel().equals(this.getLatestStreamLabel())) {
            return false;
        }
        if (other.getLatestStreamArn() == null ^ this.getLatestStreamArn() == null) {
            return false;
        }
        if (other.getLatestStreamArn() != null && !other.getLatestStreamArn().equals(this.getLatestStreamArn())) {
            return false;
        }
        if (other.getGlobalTableVersion() == null ^ this.getGlobalTableVersion() == null) {
            return false;
        }
        if (other.getGlobalTableVersion() != null && !other.getGlobalTableVersion().equals(this.getGlobalTableVersion())) {
            return false;
        }
        if (other.getReplicas() == null ^ this.getReplicas() == null) {
            return false;
        }
        if (other.getReplicas() != null && !other.getReplicas().equals(this.getReplicas())) {
            return false;
        }
        if (other.getRestoreSummary() == null ^ this.getRestoreSummary() == null) {
            return false;
        }
        if (other.getRestoreSummary() != null && !other.getRestoreSummary().equals(this.getRestoreSummary())) {
            return false;
        }
        if (other.getSSEDescription() == null ^ this.getSSEDescription() == null) {
            return false;
        }
        if (other.getSSEDescription() != null && !other.getSSEDescription().equals(this.getSSEDescription())) {
            return false;
        }
        if (other.getArchivalSummary() == null ^ this.getArchivalSummary() == null) {
            return false;
        }
        return other.getArchivalSummary() == null || other.getArchivalSummary().equals(this.getArchivalSummary());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttributeDefinitions() == null ? 0 : this.getAttributeDefinitions().hashCode());
        hashCode = 31 * hashCode + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        hashCode = 31 * hashCode + (this.getKeySchema() == null ? 0 : this.getKeySchema().hashCode());
        hashCode = 31 * hashCode + (this.getTableStatus() == null ? 0 : this.getTableStatus().hashCode());
        hashCode = 31 * hashCode + (this.getCreationDateTime() == null ? 0 : this.getCreationDateTime().hashCode());
        hashCode = 31 * hashCode + (this.getProvisionedThroughput() == null ? 0 : this.getProvisionedThroughput().hashCode());
        hashCode = 31 * hashCode + (this.getTableSizeBytes() == null ? 0 : this.getTableSizeBytes().hashCode());
        hashCode = 31 * hashCode + (this.getItemCount() == null ? 0 : this.getItemCount().hashCode());
        hashCode = 31 * hashCode + (this.getTableArn() == null ? 0 : this.getTableArn().hashCode());
        hashCode = 31 * hashCode + (this.getTableId() == null ? 0 : this.getTableId().hashCode());
        hashCode = 31 * hashCode + (this.getBillingModeSummary() == null ? 0 : this.getBillingModeSummary().hashCode());
        hashCode = 31 * hashCode + (this.getLocalSecondaryIndexes() == null ? 0 : this.getLocalSecondaryIndexes().hashCode());
        hashCode = 31 * hashCode + (this.getGlobalSecondaryIndexes() == null ? 0 : this.getGlobalSecondaryIndexes().hashCode());
        hashCode = 31 * hashCode + (this.getStreamSpecification() == null ? 0 : this.getStreamSpecification().hashCode());
        hashCode = 31 * hashCode + (this.getLatestStreamLabel() == null ? 0 : this.getLatestStreamLabel().hashCode());
        hashCode = 31 * hashCode + (this.getLatestStreamArn() == null ? 0 : this.getLatestStreamArn().hashCode());
        hashCode = 31 * hashCode + (this.getGlobalTableVersion() == null ? 0 : this.getGlobalTableVersion().hashCode());
        hashCode = 31 * hashCode + (this.getReplicas() == null ? 0 : this.getReplicas().hashCode());
        hashCode = 31 * hashCode + (this.getRestoreSummary() == null ? 0 : this.getRestoreSummary().hashCode());
        hashCode = 31 * hashCode + (this.getSSEDescription() == null ? 0 : this.getSSEDescription().hashCode());
        hashCode = 31 * hashCode + (this.getArchivalSummary() == null ? 0 : this.getArchivalSummary().hashCode());
        return hashCode;
    }

    public TableDescription clone() {
        try {
            return (TableDescription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TableDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

