/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.core;

import io.javalin.Context;
import io.javalin.Handler;
import io.javalin.Javalin;
import io.javalin.MethodNotAllowedResponse;
import io.javalin.NotFoundResponse;
import io.javalin.RequestLogger;
import io.javalin.core.CachedRequestWrapper;
import io.javalin.core.ErrorMapper;
import io.javalin.core.ExceptionMapper;
import io.javalin.core.HandlerEntry;
import io.javalin.core.HandlerType;
import io.javalin.core.JavalinServlet;
import io.javalin.core.PathMatcher;
import io.javalin.core.util.ContextUtil;
import io.javalin.core.util.LogUtil;
import io.javalin.core.util.MethodNotAllowedUtil;
import io.javalin.core.util.SinglePageHandler;
import io.javalin.core.util.Util;
import io.javalin.staticfiles.ResourceHandler;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.zip.GZIPOutputStream;
import javax.servlet.AsyncContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\u0018\u00002\u00020\u0001Bq\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u000e\u001a\u00020\u000b\u0012\u0006\u0010\u000f\u001a\u00020\u000b\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u000b\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0002\u0010\u0019J\u0010\u00101\u001a\u00020\u000b2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00104\u001a\u00020\u000b2\u0006\u00105\u001a\u00020\u0011H\u0002J\u0016\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;R\u0011\u0010\u000f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001bR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001bR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010\u0014\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u001bR\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100\u00a8\u0006\u0002"}, d2={"Lio/javalin/core/JavalinServlet;", "", "javalin", "Lio/javalin/Javalin;", "matcher", "Lio/javalin/core/PathMatcher;", "exceptionMapper", "Lio/javalin/core/ExceptionMapper;", "errorMapper", "Lio/javalin/core/ErrorMapper;", "debugLogging", "", "requestLogger", "Lio/javalin/RequestLogger;", "dynamicGzipEnabled", "autogeneratedEtagsEnabled", "defaultContentType", "", "maxRequestCacheBodySize", "", "prefer405over404", "singlePageHandler", "Lio/javalin/core/util/SinglePageHandler;", "resourceHandler", "Lio/javalin/staticfiles/ResourceHandler;", "(Lio/javalin/Javalin;Lio/javalin/core/PathMatcher;Lio/javalin/core/ExceptionMapper;Lio/javalin/core/ErrorMapper;ZLio/javalin/RequestLogger;ZZLjava/lang/String;JZLio/javalin/core/util/SinglePageHandler;Lio/javalin/staticfiles/ResourceHandler;)V", "getAutogeneratedEtagsEnabled", "()Z", "getDebugLogging", "getDefaultContentType", "()Ljava/lang/String;", "getDynamicGzipEnabled", "getErrorMapper", "()Lio/javalin/core/ErrorMapper;", "getExceptionMapper", "()Lio/javalin/core/ExceptionMapper;", "getJavalin", "()Lio/javalin/Javalin;", "getMatcher", "()Lio/javalin/core/PathMatcher;", "getMaxRequestCacheBodySize", "()J", "getPrefer405over404", "getRequestLogger", "()Lio/javalin/RequestLogger;", "getResourceHandler", "()Lio/javalin/staticfiles/ResourceHandler;", "getSinglePageHandler", "()Lio/javalin/core/util/SinglePageHandler;", "gzipShouldBeDone", "ctx", "Lio/javalin/Context;", "hasGetHandlerMapped", "requestUri", "service", "", "servletRequest", "Ljavax/servlet/http/HttpServletRequest;", "res", "Ljavax/servlet/http/HttpServletResponse;"})
public final class JavalinServlet {
    @NotNull
    private final Javalin javalin;
    @NotNull
    private final PathMatcher matcher;
    @NotNull
    private final ExceptionMapper exceptionMapper;
    @NotNull
    private final ErrorMapper errorMapper;
    private final boolean debugLogging;
    @Nullable
    private final RequestLogger requestLogger;
    private final boolean dynamicGzipEnabled;
    private final boolean autogeneratedEtagsEnabled;
    @NotNull
    private final String defaultContentType;
    private final long maxRequestCacheBodySize;
    private final boolean prefer405over404;
    @NotNull
    private final SinglePageHandler singlePageHandler;
    @Nullable
    private final ResourceHandler resourceHandler;

    public final void service(@NotNull HttpServletRequest servletRequest, @NotNull HttpServletResponse res) {
        Intrinsics.checkParameterIsNotNull(servletRequest, "servletRequest");
        Intrinsics.checkParameterIsNotNull(res, "res");
        CachedRequestWrapper req = new CachedRequestWrapper(servletRequest, this.maxRequestCacheBodySize);
        HandlerType type = HandlerType.Companion.fromServletRequest((HttpServletRequest)req);
        String requestUri = req.getRequestURI();
        Context ctx = new Context((HttpServletRequest)req, res, this.javalin);
        Function1<Function0<? extends Unit>, Unit> tryWithExceptionMapper$ = new Function1<Function0<? extends Unit>, Unit>(this, ctx){
            final /* synthetic */ JavalinServlet this$0;
            final /* synthetic */ Context $ctx;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Function0<Unit> func) {
                Intrinsics.checkParameterIsNotNull(func, "func");
                ExceptionMapper exceptionMapper = this.this$0.getExceptionMapper();
                Context ctx$iv = this.$ctx;
                try {
                    func.invoke();
                }
                catch (Exception e$iv) {
                    void this_$iv;
                    this_$iv.handle$javalin(e$iv, ctx$iv);
                }
            }
            {
                this.this$0 = javalinServlet;
                this.$ctx = context;
                super(1);
            }
        };
        Function0<Unit> tryBeforeAndEndpointHandlers$ = new Function0<Unit>(this, tryWithExceptionMapper$, requestUri, ctx, type, req, res){
            final /* synthetic */ JavalinServlet this$0;
            final /* synthetic */ service.1 $tryWithExceptionMapper$1;
            final /* synthetic */ String $requestUri;
            final /* synthetic */ Context $ctx;
            final /* synthetic */ HandlerType $type;
            final /* synthetic */ CachedRequestWrapper $req;
            final /* synthetic */ HttpServletResponse $res;

            public final void invoke() {
                this.$tryWithExceptionMapper$1.invoke(new Function0<Unit>(this){
                    final /* synthetic */ service.2 this$0;

                    public final void invoke() {
                        HandlerEntry entry;
                        PathMatcher pathMatcher = this.this$0.this$0.getMatcher();
                        String string = this.this$0.$requestUri;
                        Intrinsics.checkExpressionValueIsNotNull(string, "requestUri");
                        Iterable $receiver$iv = pathMatcher.findEntries(HandlerType.BEFORE, string);
                        for (T element$iv : $receiver$iv) {
                            entry = (HandlerEntry)element$iv;
                            Handler handler = entry.getHandler();
                            Context context = this.this$0.$ctx;
                            String string2 = this.this$0.$requestUri;
                            Intrinsics.checkExpressionValueIsNotNull(string2, "requestUri");
                            handler.handle(ContextUtil.INSTANCE.update(context, entry, string2));
                        }
                        PathMatcher pathMatcher2 = this.this$0.this$0.getMatcher();
                        HandlerType handlerType = this.this$0.$type;
                        String string3 = this.this$0.$requestUri;
                        Intrinsics.checkExpressionValueIsNotNull(string3, "requestUri");
                        $receiver$iv = pathMatcher2.findEntries(handlerType, string3);
                        Object object = $receiver$iv.iterator();
                        if (object.hasNext()) {
                            T element$iv;
                            element$iv = object.next();
                            entry = (HandlerEntry)element$iv;
                            Handler handler = entry.getHandler();
                            Context context = this.this$0.$ctx;
                            String string4 = this.this$0.$requestUri;
                            Intrinsics.checkExpressionValueIsNotNull(string4, "requestUri");
                            handler.handle(ContextUtil.INSTANCE.update(context, entry, string4));
                            return;
                        }
                        if (this.this$0.$type == HandlerType.HEAD) {
                            JavalinServlet javalinServlet = this.this$0.this$0;
                            String string5 = this.this$0.$requestUri;
                            Intrinsics.checkExpressionValueIsNotNull(string5, "requestUri");
                            if (JavalinServlet.access$hasGetHandlerMapped(javalinServlet, string5)) {
                                return;
                            }
                        }
                        if (this.this$0.$type == HandlerType.HEAD || this.this$0.$type == HandlerType.GET) {
                            ResourceHandler resourceHandler = this.this$0.this$0.getResourceHandler();
                            if (resourceHandler != null) {
                                if (resourceHandler.handle((HttpServletRequest)this.this$0.$req, this.this$0.$res)) {
                                    return;
                                }
                            }
                            if (this.this$0.this$0.getSinglePageHandler().handle(this.this$0.$ctx)) {
                                return;
                            }
                        }
                        PathMatcher pathMatcher3 = this.this$0.this$0.getMatcher();
                        String string6 = this.this$0.$requestUri;
                        Intrinsics.checkExpressionValueIsNotNull(string6, "requestUri");
                        List<HandlerType> availableHandlerTypes = MethodNotAllowedUtil.INSTANCE.findAvailableHttpHandlerTypes(pathMatcher3, string6);
                        if (this.this$0.this$0.getPrefer405over404() && !(object = (Collection)availableHandlerTypes).isEmpty()) {
                            throw (Throwable)new MethodNotAllowedResponse(null, MethodNotAllowedUtil.INSTANCE.getAvailableHandlerTypes(this.this$0.$ctx, availableHandlerTypes), 1, null);
                        }
                        throw (Throwable)new NotFoundResponse(null, 1, null);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.this$0 = javalinServlet;
                this.$tryWithExceptionMapper$1 = var2_2;
                this.$requestUri = string;
                this.$ctx = context;
                this.$type = handlerType;
                this.$req = cachedRequestWrapper;
                this.$res = httpServletResponse;
                super(0);
            }
        };
        Function0<Unit> tryErrorHandlers$ = new Function0<Unit>(this, tryWithExceptionMapper$, ctx){
            final /* synthetic */ JavalinServlet this$0;
            final /* synthetic */ service.1 $tryWithExceptionMapper$1;
            final /* synthetic */ Context $ctx;

            public final void invoke() {
                this.$tryWithExceptionMapper$1.invoke(new Function0<Unit>(this){
                    final /* synthetic */ service.3 this$0;

                    public final void invoke() {
                        this.this$0.this$0.getErrorMapper().handle(this.this$0.$ctx.status(), this.this$0.$ctx);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.this$0 = javalinServlet;
                this.$tryWithExceptionMapper$1 = var2_2;
                this.$ctx = context;
                super(0);
            }
        };
        Function0<Unit> tryAfterHandlers$ = new Function0<Unit>(this, tryWithExceptionMapper$, requestUri, ctx){
            final /* synthetic */ JavalinServlet this$0;
            final /* synthetic */ service.1 $tryWithExceptionMapper$1;
            final /* synthetic */ String $requestUri;
            final /* synthetic */ Context $ctx;

            public final void invoke() {
                this.$tryWithExceptionMapper$1.invoke(new Function0<Unit>(this){
                    final /* synthetic */ service.4 this$0;

                    public final void invoke() {
                        PathMatcher pathMatcher = this.this$0.this$0.getMatcher();
                        String string = this.this$0.$requestUri;
                        Intrinsics.checkExpressionValueIsNotNull(string, "requestUri");
                        Iterable $receiver$iv = pathMatcher.findEntries(HandlerType.AFTER, string);
                        for (T element$iv : $receiver$iv) {
                            HandlerEntry entry = (HandlerEntry)element$iv;
                            Handler handler = entry.getHandler();
                            Context context = this.this$0.$ctx;
                            String string2 = this.this$0.$requestUri;
                            Intrinsics.checkExpressionValueIsNotNull(string2, "requestUri");
                            handler.handle(ContextUtil.INSTANCE.update(context, entry, string2));
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.this$0 = javalinServlet;
                this.$tryWithExceptionMapper$1 = var2_2;
                this.$requestUri = string;
                this.$ctx = context;
                super(0);
            }
        };
        Function1<HttpServletResponse, Unit> writeResult$ = new Function1<HttpServletResponse, Unit>(this, ctx, type, req){
            final /* synthetic */ JavalinServlet this$0;
            final /* synthetic */ Context $ctx;
            final /* synthetic */ HandlerType $type;
            final /* synthetic */ CachedRequestWrapper $req;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull HttpServletResponse res) {
                Intrinsics.checkParameterIsNotNull(res, "res");
                if (res.isCommitted() || this.$ctx.resultStream() == null) {
                    return;
                }
                InputStream inputStream = this.$ctx.resultStream();
                if (inputStream == null) {
                    Intrinsics.throwNpe();
                }
                InputStream resultStream = inputStream;
                if (res.getHeader("ETag") != null || this.this$0.getAutogeneratedEtagsEnabled() && this.$type == HandlerType.GET) {
                    String string = res.getHeader("ETag");
                    if (string == null) {
                        string = Util.INSTANCE.getChecksumAndReset(resultStream);
                    }
                    String serverEtag = string;
                    res.setHeader("ETag", serverEtag);
                    if (Intrinsics.areEqual(serverEtag, this.$req.getHeader("If-None-Match"))) {
                        res.setStatus(304);
                        return;
                    }
                }
                if (JavalinServlet.access$gzipShouldBeDone(this.this$0, this.$ctx)) {
                    Closeable closeable = new GZIPOutputStream((OutputStream)res.getOutputStream(), true);
                    Throwable throwable = null;
                    try {
                        GZIPOutputStream gzippedStream = (GZIPOutputStream)closeable;
                        res.setHeader("Content-Encoding", "gzip");
                        long l = ByteStreamsKt.copyTo$default(resultStream, gzippedStream, 0, 2, null);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable, throwable);
                    }
                    resultStream.close();
                    return;
                }
                ServletOutputStream servletOutputStream = res.getOutputStream();
                Intrinsics.checkExpressionValueIsNotNull(servletOutputStream, "res.outputStream");
                ByteStreamsKt.copyTo$default(resultStream, (OutputStream)servletOutputStream, 0, 2, null);
                resultStream.close();
            }
            {
                this.this$0 = javalinServlet;
                this.$ctx = context;
                this.$type = handlerType;
                this.$req = cachedRequestWrapper;
                super(1);
            }
        };
        Function0<Unit> logRequest$ = new Function0<Unit>(this, ctx){
            final /* synthetic */ JavalinServlet this$0;
            final /* synthetic */ Context $ctx;

            public final void invoke() {
                if (this.this$0.getRequestLogger() != null) {
                    this.this$0.getRequestLogger().handle(this.$ctx, Float.valueOf(LogUtil.INSTANCE.executionTimeMs(this.$ctx)));
                } else if (this.this$0.getDebugLogging()) {
                    LogUtil.INSTANCE.logRequestAndResponse(this.$ctx, this.this$0.getMatcher());
                }
            }
            {
                this.this$0 = javalinServlet;
                this.$ctx = context;
                super(0);
            }
        };
        LogUtil.INSTANCE.startTimer(ctx);
        ctx.header("Server", "Javalin");
        ctx.contentType(this.defaultContentType);
        tryBeforeAndEndpointHandlers$.invoke();
        if (ctx.resultFuture() == null) {
            tryErrorHandlers$.invoke();
            tryAfterHandlers$.invoke();
            writeResult$.invoke(res);
            logRequest$.invoke();
            return;
        }
        AsyncContext asyncContext = req.startAsync();
        CompletableFuture<?> completableFuture = ctx.resultFuture();
        if (completableFuture == null) {
            Intrinsics.throwNpe();
        }
        ((CompletableFuture)completableFuture.exceptionally(new Function(this, ctx){
            final /* synthetic */ JavalinServlet this$0;
            final /* synthetic */ Context $ctx;

            @Nullable
            public final Void apply(Throwable throwable) {
                if (throwable instanceof Exception) {
                    this.this$0.getExceptionMapper().handle$javalin((Exception)throwable, this.$ctx);
                }
                return null;
            }
            {
                this.this$0 = javalinServlet;
                this.$ctx = context;
            }
        })).thenAccept(new Consumer<Object>(ctx, tryErrorHandlers$, tryAfterHandlers$, writeResult$, asyncContext, logRequest$){
            final /* synthetic */ Context $ctx;
            final /* synthetic */ service.3 $tryErrorHandlers$3;
            final /* synthetic */ service.4 $tryAfterHandlers$4;
            final /* synthetic */ service.5 $writeResult$5;
            final /* synthetic */ AsyncContext $asyncContext;
            final /* synthetic */ service.6 $logRequest$6;

            public final void accept(Object it) {
                Object object = it;
                if (object instanceof InputStream) {
                    this.$ctx.result((InputStream)it);
                } else if (object instanceof String) {
                    this.$ctx.result((String)it);
                }
                this.$tryErrorHandlers$3.invoke();
                this.$tryAfterHandlers$4.invoke();
                AsyncContext asyncContext = this.$asyncContext;
                Intrinsics.checkExpressionValueIsNotNull(asyncContext, "asyncContext");
                ServletResponse servletResponse = asyncContext.getResponse();
                if (servletResponse == null) {
                    throw new TypeCastException("null cannot be cast to non-null type javax.servlet.http.HttpServletResponse");
                }
                this.$writeResult$5.invoke((HttpServletResponse)servletResponse);
                this.$logRequest$6.invoke();
                this.$asyncContext.complete();
            }
            {
                this.$ctx = context;
                this.$tryErrorHandlers$3 = var2_2;
                this.$tryAfterHandlers$4 = var3_3;
                this.$writeResult$5 = var4_4;
                this.$asyncContext = asyncContext;
                this.$logRequest$6 = var6_6;
            }
        });
    }

    private final boolean hasGetHandlerMapped(String requestUri) {
        Collection collection = this.matcher.findEntries(HandlerType.GET, requestUri);
        return !collection.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean gzipShouldBeDone(Context ctx) {
        if (!this.dynamicGzipEnabled) return false;
        InputStream inputStream = ctx.resultStream();
        if (inputStream == null) return false;
        int n = inputStream.available();
        if (n <= 1500) return false;
        String string = ctx.header("Accept-Encoding");
        if (string == null) {
            string = "";
        }
        if (!StringsKt.contains((CharSequence)string, "gzip", true)) return false;
        return true;
    }

    @NotNull
    public final Javalin getJavalin() {
        return this.javalin;
    }

    @NotNull
    public final PathMatcher getMatcher() {
        return this.matcher;
    }

    @NotNull
    public final ExceptionMapper getExceptionMapper() {
        return this.exceptionMapper;
    }

    @NotNull
    public final ErrorMapper getErrorMapper() {
        return this.errorMapper;
    }

    public final boolean getDebugLogging() {
        return this.debugLogging;
    }

    @Nullable
    public final RequestLogger getRequestLogger() {
        return this.requestLogger;
    }

    public final boolean getDynamicGzipEnabled() {
        return this.dynamicGzipEnabled;
    }

    public final boolean getAutogeneratedEtagsEnabled() {
        return this.autogeneratedEtagsEnabled;
    }

    @NotNull
    public final String getDefaultContentType() {
        return this.defaultContentType;
    }

    public final long getMaxRequestCacheBodySize() {
        return this.maxRequestCacheBodySize;
    }

    public final boolean getPrefer405over404() {
        return this.prefer405over404;
    }

    @NotNull
    public final SinglePageHandler getSinglePageHandler() {
        return this.singlePageHandler;
    }

    @Nullable
    public final ResourceHandler getResourceHandler() {
        return this.resourceHandler;
    }

    public JavalinServlet(@NotNull Javalin javalin, @NotNull PathMatcher matcher, @NotNull ExceptionMapper exceptionMapper, @NotNull ErrorMapper errorMapper, boolean debugLogging, @Nullable RequestLogger requestLogger, boolean dynamicGzipEnabled, boolean autogeneratedEtagsEnabled, @NotNull String defaultContentType, long maxRequestCacheBodySize, boolean prefer405over404, @NotNull SinglePageHandler singlePageHandler, @Nullable ResourceHandler resourceHandler) {
        Intrinsics.checkParameterIsNotNull(javalin, "javalin");
        Intrinsics.checkParameterIsNotNull(matcher, "matcher");
        Intrinsics.checkParameterIsNotNull(exceptionMapper, "exceptionMapper");
        Intrinsics.checkParameterIsNotNull(errorMapper, "errorMapper");
        Intrinsics.checkParameterIsNotNull(defaultContentType, "defaultContentType");
        Intrinsics.checkParameterIsNotNull(singlePageHandler, "singlePageHandler");
        this.javalin = javalin;
        this.matcher = matcher;
        this.exceptionMapper = exceptionMapper;
        this.errorMapper = errorMapper;
        this.debugLogging = debugLogging;
        this.requestLogger = requestLogger;
        this.dynamicGzipEnabled = dynamicGzipEnabled;
        this.autogeneratedEtagsEnabled = autogeneratedEtagsEnabled;
        this.defaultContentType = defaultContentType;
        this.maxRequestCacheBodySize = maxRequestCacheBodySize;
        this.prefer405over404 = prefer405over404;
        this.singlePageHandler = singlePageHandler;
        this.resourceHandler = resourceHandler;
    }

    public static final /* synthetic */ boolean access$hasGetHandlerMapped(JavalinServlet $this, @NotNull String requestUri) {
        return $this.hasGetHandlerMapped(requestUri);
    }

    public static final /* synthetic */ boolean access$gzipShouldBeDone(JavalinServlet $this, @NotNull Context ctx) {
        return $this.gzipShouldBeDone(ctx);
    }
}

