/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableFactory;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTableInterfaceFactory;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.PoolMap;

@InterfaceAudience.Private
@Deprecated
public class HTablePool
implements Closeable {
    private final PoolMap<String, HTableInterface> tables;
    private final int maxSize;
    private final PoolMap.PoolType poolType;
    private final Configuration config;
    private final HTableInterfaceFactory tableFactory;

    public HTablePool() {
        this(HBaseConfiguration.create(), Integer.MAX_VALUE);
    }

    public HTablePool(Configuration config, int maxSize) {
        this(config, maxSize, null, null);
    }

    public HTablePool(Configuration config, int maxSize, HTableInterfaceFactory tableFactory) {
        this(config, maxSize, tableFactory, PoolMap.PoolType.Reusable);
    }

    public HTablePool(Configuration config, int maxSize, PoolMap.PoolType poolType) {
        this(config, maxSize, null, poolType);
    }

    public HTablePool(Configuration config, int maxSize, HTableInterfaceFactory tableFactory, PoolMap.PoolType poolType) {
        this.config = config == null ? HBaseConfiguration.create() : config;
        this.maxSize = maxSize;
        HTableInterfaceFactory hTableInterfaceFactory = this.tableFactory = tableFactory == null ? new HTableFactory() : tableFactory;
        if (poolType == null) {
            this.poolType = PoolMap.PoolType.Reusable;
        } else {
            switch (poolType) {
                case Reusable: 
                case ThreadLocal: {
                    this.poolType = poolType;
                    break;
                }
                default: {
                    this.poolType = PoolMap.PoolType.Reusable;
                }
            }
        }
        this.tables = new PoolMap(this.poolType, this.maxSize);
    }

    public HTableInterface getTable(String tableName) {
        HTableInterface table = this.findOrCreateTable(tableName);
        return new PooledHTable(table);
    }

    private HTableInterface findOrCreateTable(String tableName) {
        HTableInterface table = this.tables.get(tableName);
        if (table == null) {
            table = this.createHTable(tableName);
        }
        return table;
    }

    public HTableInterface getTable(byte[] tableName) {
        return this.getTable(Bytes.toString(tableName));
    }

    public void putTable(HTableInterface table) throws IOException {
        if (!(table instanceof PooledHTable)) {
            throw new IllegalArgumentException("not a pooled table: " + table);
        }
        this.returnTable(((PooledHTable)table).getWrappedTable());
    }

    private void returnTable(HTableInterface table) throws IOException {
        String tableName = Bytes.toString(table.getTableName());
        if (this.tables.size(tableName) >= this.maxSize) {
            this.tables.removeValue(tableName, table);
            this.tableFactory.releaseHTableInterface(table);
            return;
        }
        this.tables.put(tableName, table);
    }

    protected HTableInterface createHTable(String tableName) {
        return this.tableFactory.createHTableInterface(this.config, Bytes.toBytes(tableName));
    }

    public void closeTablePool(String tableName) throws IOException {
        Collection<HTableInterface> tables = this.tables.values(tableName);
        if (tables != null) {
            for (HTableInterface table : tables) {
                this.tableFactory.releaseHTableInterface(table);
            }
        }
        this.tables.remove(tableName);
    }

    public void closeTablePool(byte[] tableName) throws IOException {
        this.closeTablePool(Bytes.toString(tableName));
    }

    @Override
    public void close() throws IOException {
        for (String tableName : this.tables.keySet()) {
            this.closeTablePool(tableName);
        }
        this.tables.clear();
    }

    public int getCurrentPoolSize(String tableName) {
        return this.tables.size(tableName);
    }

    class PooledHTable
    implements HTableInterface {
        private boolean open = false;
        private HTableInterface table;

        public PooledHTable(HTableInterface table) {
            this.table = table;
            this.open = true;
        }

        @Override
        public byte[] getTableName() {
            this.checkState();
            return this.table.getTableName();
        }

        @Override
        public TableName getName() {
            return this.table.getName();
        }

        @Override
        public Configuration getConfiguration() {
            this.checkState();
            return this.table.getConfiguration();
        }

        @Override
        public HTableDescriptor getTableDescriptor() throws IOException {
            this.checkState();
            return this.table.getTableDescriptor();
        }

        @Override
        public boolean exists(Get get) throws IOException {
            this.checkState();
            return this.table.exists(get);
        }

        @Override
        public boolean[] existsAll(List<Get> gets) throws IOException {
            this.checkState();
            return this.table.existsAll(gets);
        }

        @Override
        public Boolean[] exists(List<Get> gets) throws IOException {
            this.checkState();
            return this.table.exists(gets);
        }

        @Override
        public void batch(List<? extends Row> actions, Object[] results) throws IOException, InterruptedException {
            this.checkState();
            this.table.batch(actions, results);
        }

        @Override
        public Object[] batch(List<? extends Row> actions) throws IOException, InterruptedException {
            this.checkState();
            return this.table.batch(actions);
        }

        @Override
        public Result get(Get get) throws IOException {
            this.checkState();
            return this.table.get(get);
        }

        @Override
        public Result[] get(List<Get> gets) throws IOException {
            this.checkState();
            return this.table.get(gets);
        }

        @Override
        @Deprecated
        public Result getRowOrBefore(byte[] row, byte[] family) throws IOException {
            this.checkState();
            return this.table.getRowOrBefore(row, family);
        }

        @Override
        public ResultScanner getScanner(Scan scan) throws IOException {
            this.checkState();
            return this.table.getScanner(scan);
        }

        @Override
        public ResultScanner getScanner(byte[] family) throws IOException {
            this.checkState();
            return this.table.getScanner(family);
        }

        @Override
        public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
            this.checkState();
            return this.table.getScanner(family, qualifier);
        }

        @Override
        public void put(Put put) throws IOException {
            this.checkState();
            this.table.put(put);
        }

        @Override
        public void put(List<Put> puts) throws IOException {
            this.checkState();
            this.table.put(puts);
        }

        @Override
        public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put) throws IOException {
            this.checkState();
            return this.table.checkAndPut(row, family, qualifier, value, put);
        }

        @Override
        public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Put put) throws IOException {
            this.checkState();
            return this.table.checkAndPut(row, family, qualifier, compareOp, value, put);
        }

        @Override
        public void delete(Delete delete) throws IOException {
            this.checkState();
            this.table.delete(delete);
        }

        @Override
        public void delete(List<Delete> deletes) throws IOException {
            this.checkState();
            this.table.delete(deletes);
        }

        @Override
        public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
            this.checkState();
            return this.table.checkAndDelete(row, family, qualifier, value, delete);
        }

        @Override
        public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Delete delete) throws IOException {
            this.checkState();
            return this.table.checkAndDelete(row, family, qualifier, compareOp, value, delete);
        }

        @Override
        public Result increment(Increment increment) throws IOException {
            this.checkState();
            return this.table.increment(increment);
        }

        @Override
        public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
            this.checkState();
            return this.table.incrementColumnValue(row, family, qualifier, amount);
        }

        @Override
        public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability) throws IOException {
            this.checkState();
            return this.table.incrementColumnValue(row, family, qualifier, amount, durability);
        }

        @Override
        public boolean isAutoFlush() {
            this.checkState();
            return this.table.isAutoFlush();
        }

        @Override
        public void flushCommits() throws IOException {
            this.checkState();
            this.table.flushCommits();
        }

        @Override
        public void close() throws IOException {
            this.checkState();
            this.open = false;
            HTablePool.this.returnTable(this.table);
        }

        @Override
        public CoprocessorRpcChannel coprocessorService(byte[] row) {
            this.checkState();
            return this.table.coprocessorService(row);
        }

        @Override
        public <T extends Service, R> Map<byte[], R> coprocessorService(Class<T> service2, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws ServiceException, Throwable {
            this.checkState();
            return this.table.coprocessorService(service2, startKey, endKey, callable);
        }

        @Override
        public <T extends Service, R> void coprocessorService(Class<T> service2, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws ServiceException, Throwable {
            this.checkState();
            this.table.coprocessorService(service2, startKey, endKey, callable, callback);
        }

        public String toString() {
            return "PooledHTable{, table=" + this.table + '}';
        }

        HTableInterface getWrappedTable() {
            return this.table;
        }

        @Override
        public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
            this.checkState();
            this.table.batchCallback(actions, results, callback);
        }

        @Override
        public <R> Object[] batchCallback(List<? extends Row> actions, Batch.Callback<R> callback) throws IOException, InterruptedException {
            this.checkState();
            return this.table.batchCallback(actions, callback);
        }

        @Override
        public void mutateRow(RowMutations rm) throws IOException {
            this.checkState();
            this.table.mutateRow(rm);
        }

        @Override
        public Result append(Append append) throws IOException {
            this.checkState();
            return this.table.append(append);
        }

        @Override
        public void setAutoFlush(boolean autoFlush) {
            this.checkState();
            this.table.setAutoFlush(autoFlush, autoFlush);
        }

        @Override
        public void setAutoFlush(boolean autoFlush, boolean clearBufferOnFail) {
            this.checkState();
            this.table.setAutoFlush(autoFlush, clearBufferOnFail);
        }

        @Override
        public void setAutoFlushTo(boolean autoFlush) {
            this.table.setAutoFlushTo(autoFlush);
        }

        @Override
        public long getWriteBufferSize() {
            this.checkState();
            return this.table.getWriteBufferSize();
        }

        @Override
        public void setWriteBufferSize(long writeBufferSize) throws IOException {
            this.checkState();
            this.table.setWriteBufferSize(writeBufferSize);
        }

        boolean isOpen() {
            return this.open;
        }

        private void checkState() {
            if (!this.isOpen()) {
                throw new IllegalStateException("Table=" + new String(this.table.getTableName()) + " already closed");
            }
        }

        @Override
        public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
            return this.table.incrementColumnValue(row, family, qualifier, amount, writeToWAL);
        }

        @Override
        public <R extends Message> Map<byte[], R> batchCoprocessorService(Descriptors.MethodDescriptor method, Message request, byte[] startKey, byte[] endKey, R responsePrototype) throws ServiceException, Throwable {
            this.checkState();
            return this.table.batchCoprocessorService(method, request, startKey, endKey, responsePrototype);
        }

        @Override
        public <R extends Message> void batchCoprocessorService(Descriptors.MethodDescriptor method, Message request, byte[] startKey, byte[] endKey, R responsePrototype, Batch.Callback<R> callback) throws ServiceException, Throwable {
            this.checkState();
            this.table.batchCoprocessorService(method, request, startKey, endKey, responsePrototype, callback);
        }

        @Override
        public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, RowMutations mutation) throws IOException {
            this.checkState();
            return this.table.checkAndMutate(row, family, qualifier, compareOp, value, mutation);
        }
    }
}

