/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Collection;
import java.util.Iterator;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class RegionReplicaUtil {
    public static final String REGION_REPLICA_WAIT_FOR_PRIMARY_FLUSH_CONF_KEY = "hbase.region.replica.wait.for.primary.flush";
    protected static final boolean DEFAULT_REGION_REPLICA_WAIT_FOR_PRIMARY_FLUSH = true;
    static final int DEFAULT_REPLICA_ID = 0;

    public static HRegionInfo getRegionInfoForReplica(HRegionInfo regionInfo, int replicaId) {
        if (regionInfo.getReplicaId() == replicaId) {
            return regionInfo;
        }
        HRegionInfo replicaInfo = regionInfo.isMetaRegion() ? new HRegionInfo(regionInfo.getRegionId(), regionInfo.getTable(), replicaId) : new HRegionInfo(regionInfo.getTable(), regionInfo.getStartKey(), regionInfo.getEndKey(), regionInfo.isSplit(), regionInfo.getRegionId(), replicaId);
        replicaInfo.setOffline(regionInfo.isOffline());
        return replicaInfo;
    }

    public static HRegionInfo getRegionInfoForDefaultReplica(HRegionInfo regionInfo) {
        return RegionReplicaUtil.getRegionInfoForReplica(regionInfo, 0);
    }

    public static boolean isDefaultReplica(int replicaId) {
        return 0 == replicaId;
    }

    public static boolean isDefaultReplica(HRegionInfo hri) {
        return hri.getReplicaId() == 0;
    }

    public static void removeNonDefaultRegions(Collection<HRegionInfo> regions) {
        Iterator<HRegionInfo> iterator2 = regions.iterator();
        while (iterator2.hasNext()) {
            HRegionInfo hri = iterator2.next();
            if (RegionReplicaUtil.isDefaultReplica(hri)) continue;
            iterator2.remove();
        }
    }

    public static boolean isReplicasForSameRegion(HRegionInfo regionInfoA, HRegionInfo regionInfoB) {
        return RegionReplicaUtil.compareRegionInfosWithoutReplicaId(regionInfoA, regionInfoB) == 0;
    }

    private static int compareRegionInfosWithoutReplicaId(HRegionInfo regionInfoA, HRegionInfo regionInfoB) {
        int result = regionInfoA.getTable().compareTo(regionInfoB.getTable());
        if (result != 0) {
            return result;
        }
        result = Bytes.compareTo(regionInfoA.getStartKey(), regionInfoB.getStartKey());
        if (result != 0) {
            return result;
        }
        result = Bytes.compareTo(regionInfoA.getEndKey(), regionInfoB.getEndKey());
        if (result != 0) {
            if (regionInfoA.getStartKey().length != 0 && regionInfoA.getEndKey().length == 0) {
                return 1;
            }
            if (regionInfoB.getStartKey().length != 0 && regionInfoB.getEndKey().length == 0) {
                return -1;
            }
            return result;
        }
        if (regionInfoA.getRegionId() > regionInfoB.getRegionId()) {
            return 1;
        }
        if (regionInfoA.getRegionId() < regionInfoB.getRegionId()) {
            return -1;
        }
        return 0;
    }
}

