/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockEncodingContext;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Private
public class NoOpDataBlockEncoder
implements HFileDataBlockEncoder {
    public static final NoOpDataBlockEncoder INSTANCE = new NoOpDataBlockEncoder();

    private NoOpDataBlockEncoder() {
    }

    @Override
    public int encode(Cell cell, HFileBlockEncodingContext encodingCtx, DataOutputStream out) throws IOException {
        int klength = KeyValueUtil.keyLength(cell);
        int vlength = cell.getValueLength();
        out.writeInt(klength);
        out.writeInt(vlength);
        CellUtil.writeFlatKey(cell, out);
        out.write(cell.getValueArray(), cell.getValueOffset(), vlength);
        int encodedKvSize = klength + vlength + 8;
        if (encodingCtx.getHFileContext().isIncludesTags()) {
            int tagsLength = cell.getTagsLength();
            out.writeShort(tagsLength);
            if (tagsLength > 0) {
                out.write(cell.getTagsArray(), cell.getTagsOffset(), tagsLength);
            }
            encodedKvSize += tagsLength + 2;
        }
        if (encodingCtx.getHFileContext().isIncludesMvcc()) {
            WritableUtils.writeVLong((DataOutput)out, (long)cell.getSequenceId());
            encodedKvSize += WritableUtils.getVIntSize((long)cell.getSequenceId());
        }
        return encodedKvSize;
    }

    @Override
    public boolean useEncodedScanner() {
        return false;
    }

    @Override
    public void saveMetadata(HFile.Writer writer) {
    }

    @Override
    public DataBlockEncoding getDataBlockEncoding() {
        return DataBlockEncoding.NONE;
    }

    @Override
    public DataBlockEncoding getEffectiveEncodingInCache(boolean isCompaction) {
        return DataBlockEncoding.NONE;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public HFileBlockEncodingContext newDataBlockEncodingContext(byte[] dummyHeader, HFileContext meta) {
        return new HFileBlockDefaultEncodingContext(null, dummyHeader, meta);
    }

    @Override
    public HFileBlockDecodingContext newDataBlockDecodingContext(HFileContext meta) {
        return new HFileBlockDefaultDecodingContext(meta);
    }

    @Override
    public void startBlockEncoding(HFileBlockEncodingContext encodingCtx, DataOutputStream out) throws IOException {
    }

    @Override
    public void endBlockEncoding(HFileBlockEncodingContext encodingCtx, DataOutputStream out, byte[] uncompressedBytesWithHeader, BlockType blockType) throws IOException {
        encodingCtx.postEncoding(BlockType.DATA);
    }
}

