/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.ipc.BalancedQueueRpcExecutor;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.RWQueueRpcExecutor;
import org.apache.hadoop.hbase.ipc.RpcExecutor;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.util.BoundedPriorityBlockingQueue;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor", "Phoenix"})
@InterfaceStability.Evolving
public class SimpleRpcScheduler
extends RpcScheduler {
    private static final Log LOG = LogFactory.getLog(SimpleRpcScheduler.class);
    public static final String CALL_QUEUE_READ_SHARE_CONF_KEY = "hbase.ipc.server.callqueue.read.ratio";
    public static final String CALL_QUEUE_SCAN_SHARE_CONF_KEY = "hbase.ipc.server.callqueue.scan.ratio";
    public static final String CALL_QUEUE_HANDLER_FACTOR_CONF_KEY = "hbase.ipc.server.callqueue.handler.factor";
    public static final String CALL_QUEUE_TYPE_CONF_KEY = "hbase.ipc.server.callqueue.type";
    public static final String CALL_QUEUE_TYPE_DEADLINE_CONF_VALUE = "deadline";
    public static final String CALL_QUEUE_TYPE_FIFO_CONF_VALUE = "fifo";
    public static final String QUEUE_MAX_CALL_DELAY_CONF_KEY = "hbase.ipc.server.queue.max.call.delay";
    private int port;
    private final PriorityFunction priority;
    private final RpcExecutor callExecutor;
    private final RpcExecutor priorityExecutor;
    private final RpcExecutor replicationExecutor;
    private final int highPriorityLevel;
    private Abortable abortable = null;

    public SimpleRpcScheduler(Configuration conf, int handlerCount, int priorityHandlerCount, int replicationHandlerCount, PriorityFunction priority, Abortable server, int highPriorityLevel) {
        int maxQueueLength = conf.getInt("hbase.ipc.server.max.callqueue.length", handlerCount * 10);
        this.priority = priority;
        this.highPriorityLevel = highPriorityLevel;
        this.abortable = server;
        String callQueueType = conf.get(CALL_QUEUE_TYPE_CONF_KEY, CALL_QUEUE_TYPE_DEADLINE_CONF_VALUE);
        float callqReadShare = conf.getFloat(CALL_QUEUE_READ_SHARE_CONF_KEY, 0.0f);
        float callqScanShare = conf.getFloat(CALL_QUEUE_SCAN_SHARE_CONF_KEY, 0.0f);
        float callQueuesHandlersFactor = conf.getFloat(CALL_QUEUE_HANDLER_FACTOR_CONF_KEY, 0.0f);
        int numCallQueues = Math.max(1, Math.round((float)handlerCount * callQueuesHandlersFactor));
        LOG.info((Object)("Using " + callQueueType + " as user call queue, count=" + numCallQueues));
        if (numCallQueues > 1 && callqReadShare > 0.0f) {
            if (callQueueType.equals(CALL_QUEUE_TYPE_DEADLINE_CONF_VALUE)) {
                CallPriorityComparator callPriority = new CallPriorityComparator(conf, this.priority);
                this.callExecutor = new RWQueueRpcExecutor("RW.default", handlerCount, numCallQueues, callqReadShare, callqScanShare, maxQueueLength, conf, this.abortable, BoundedPriorityBlockingQueue.class, callPriority);
            } else {
                this.callExecutor = new RWQueueRpcExecutor("RW.default", handlerCount, numCallQueues, callqReadShare, callqScanShare, maxQueueLength, conf, this.abortable);
            }
        } else if (callQueueType.equals(CALL_QUEUE_TYPE_DEADLINE_CONF_VALUE)) {
            CallPriorityComparator callPriority = new CallPriorityComparator(conf, this.priority);
            this.callExecutor = new BalancedQueueRpcExecutor("B.default", handlerCount, numCallQueues, conf, this.abortable, BoundedPriorityBlockingQueue.class, maxQueueLength, callPriority);
        } else {
            this.callExecutor = new BalancedQueueRpcExecutor("B.default", handlerCount, numCallQueues, maxQueueLength, conf, this.abortable);
        }
        this.priorityExecutor = priorityHandlerCount > 0 ? new BalancedQueueRpcExecutor("Priority", priorityHandlerCount, 2, maxQueueLength) : null;
        this.replicationExecutor = replicationHandlerCount > 0 ? new BalancedQueueRpcExecutor("Replication", replicationHandlerCount, 1, maxQueueLength, conf, this.abortable) : null;
    }

    public SimpleRpcScheduler(Configuration conf, int handlerCount, int priorityHandlerCount, int replicationHandlerCount, PriorityFunction priority, int highPriorityLevel) {
        this(conf, handlerCount, priorityHandlerCount, replicationHandlerCount, priority, null, highPriorityLevel);
    }

    @Override
    public void init(RpcScheduler.Context context) {
        this.port = context.getListenerAddress().getPort();
    }

    @Override
    public void start() {
        this.callExecutor.start(this.port);
        if (this.priorityExecutor != null) {
            this.priorityExecutor.start(this.port);
        }
        if (this.replicationExecutor != null) {
            this.replicationExecutor.start(this.port);
        }
    }

    @Override
    public void stop() {
        this.callExecutor.stop();
        if (this.priorityExecutor != null) {
            this.priorityExecutor.stop();
        }
        if (this.replicationExecutor != null) {
            this.replicationExecutor.stop();
        }
    }

    @Override
    public boolean dispatch(CallRunner callTask) throws InterruptedException {
        RpcServer.Call call2 = callTask.getCall();
        int level = this.priority.getPriority(call2.getHeader(), call2.param, call2.getRequestUser());
        if (this.priorityExecutor != null && level > this.highPriorityLevel) {
            return this.priorityExecutor.dispatch(callTask);
        }
        if (this.replicationExecutor != null && level == 5) {
            return this.replicationExecutor.dispatch(callTask);
        }
        return this.callExecutor.dispatch(callTask);
    }

    @Override
    public int getGeneralQueueLength() {
        return this.callExecutor.getQueueLength();
    }

    @Override
    public int getPriorityQueueLength() {
        return this.priorityExecutor == null ? 0 : this.priorityExecutor.getQueueLength();
    }

    @Override
    public int getReplicationQueueLength() {
        return this.replicationExecutor == null ? 0 : this.replicationExecutor.getQueueLength();
    }

    @Override
    public int getActiveRpcHandlerCount() {
        return this.callExecutor.getActiveHandlerCount() + (this.priorityExecutor == null ? 0 : this.priorityExecutor.getActiveHandlerCount()) + (this.replicationExecutor == null ? 0 : this.replicationExecutor.getActiveHandlerCount());
    }

    private static class CallPriorityComparator
    implements Comparator<CallRunner> {
        private static final int DEFAULT_MAX_CALL_DELAY = 5000;
        private final PriorityFunction priority;
        private final int maxDelay;

        public CallPriorityComparator(Configuration conf, PriorityFunction priority) {
            this.priority = priority;
            this.maxDelay = conf.getInt(SimpleRpcScheduler.QUEUE_MAX_CALL_DELAY_CONF_KEY, 5000);
        }

        @Override
        public int compare(CallRunner a, CallRunner b) {
            RpcServer.Call callA = a.getCall();
            RpcServer.Call callB = b.getCall();
            long deadlineA = this.priority.getDeadline(callA.getHeader(), callA.param);
            long deadlineB = this.priority.getDeadline(callB.getHeader(), callB.param);
            deadlineA = callA.timestamp + Math.min(deadlineA, (long)this.maxDelay);
            deadlineB = callB.timestamp + Math.min(deadlineB, (long)this.maxDelay);
            return Long.compare(deadlineA, deadlineB);
        }
    }
}

