/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.SplitTransaction;
import org.apache.hadoop.hbase.regionserver.SplitTransactionImpl;
import org.apache.hadoop.hbase.util.ReflectionUtils;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
@InterfaceStability.Evolving
public class SplitTransactionFactory
implements Configurable {
    public static final String SPLIT_TRANSACTION_IMPL_KEY = "hbase.regionserver.split.transaction.impl";
    private Configuration conf;

    public SplitTransactionFactory(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public SplitTransaction create(Region r, byte[] splitrow) {
        return (SplitTransaction)ReflectionUtils.instantiateWithCustomCtor(this.conf.getClass(SPLIT_TRANSACTION_IMPL_KEY, SplitTransactionImpl.class, SplitTransactionImpl.class).getName(), new Class[]{Region.class, byte[].class}, new Object[]{r, splitrow});
    }
}

