/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.clustering.plan.strategy;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.client.clustering.plan.strategy.SparkSizeBasedClusteringPlanStrategy;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieSparkCopyOnWriteTable;
import org.apache.hudi.table.HoodieSparkMergeOnReadTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class SparkRecentDaysClusteringPlanStrategy<T extends HoodieRecordPayload<T>>
extends SparkSizeBasedClusteringPlanStrategy<T> {
    private static final Logger LOG = LogManager.getLogger(SparkRecentDaysClusteringPlanStrategy.class);

    public SparkRecentDaysClusteringPlanStrategy(HoodieSparkCopyOnWriteTable<T> table, HoodieSparkEngineContext engineContext, HoodieWriteConfig writeConfig) {
        super(table, engineContext, writeConfig);
    }

    public SparkRecentDaysClusteringPlanStrategy(HoodieSparkMergeOnReadTable<T> table, HoodieSparkEngineContext engineContext, HoodieWriteConfig writeConfig) {
        super(table, engineContext, writeConfig);
    }

    @Override
    protected List<String> filterPartitionPaths(List<String> partitionPaths) {
        int targetPartitionsForClustering = this.getWriteConfig().getTargetPartitionsForClustering();
        int skipPartitionsFromLatestForClustering = this.getWriteConfig().getSkipPartitionsFromLatestForClustering();
        return partitionPaths.stream().sorted(Comparator.reverseOrder()).skip(Math.max(skipPartitionsFromLatestForClustering, 0)).limit(targetPartitionsForClustering > 0 ? (long)targetPartitionsForClustering : (long)partitionPaths.size()).collect(Collectors.toList());
    }
}

