/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.clustering.plan.strategy;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.client.clustering.plan.strategy.SparkSizeBasedClusteringPlanStrategy;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieSparkCopyOnWriteTable;
import org.apache.hudi.table.HoodieSparkMergeOnReadTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class SparkSelectedPartitionsClusteringPlanStrategy<T extends HoodieRecordPayload<T>>
extends SparkSizeBasedClusteringPlanStrategy<T> {
    private static final Logger LOG = LogManager.getLogger(SparkSelectedPartitionsClusteringPlanStrategy.class);
    public static final String CONF_BEGIN_PARTITION = "hoodie.clustering.plan.strategy.cluster.begin.partition";
    public static final String CONF_END_PARTITION = "hoodie.clustering.plan.strategy.cluster.end.partition";

    public SparkSelectedPartitionsClusteringPlanStrategy(HoodieSparkCopyOnWriteTable<T> table, HoodieSparkEngineContext engineContext, HoodieWriteConfig writeConfig) {
        super(table, engineContext, writeConfig);
    }

    public SparkSelectedPartitionsClusteringPlanStrategy(HoodieSparkMergeOnReadTable<T> table, HoodieSparkEngineContext engineContext, HoodieWriteConfig writeConfig) {
        super(table, engineContext, writeConfig);
    }

    @Override
    protected List<String> filterPartitionPaths(List<String> partitionPaths) {
        String beginPartition = this.getWriteConfig().getProps().getProperty(CONF_BEGIN_PARTITION);
        String endPartition = this.getWriteConfig().getProps().getProperty(CONF_END_PARTITION);
        List<String> filteredPartitions = partitionPaths.stream().filter(path -> path.compareTo(beginPartition) >= 0 && path.compareTo(endPartition) <= 0).collect(Collectors.toList());
        LOG.info((Object)("Filtered to the following partitions: " + filteredPartitions));
        return filteredPartitions;
    }
}

