/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction;

import java.io.Serializable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.client.transaction.lock.LockManager;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class TransactionManager
implements Serializable {
    private static final Logger LOG = LogManager.getLogger(TransactionManager.class);
    private final LockManager lockManager;
    private Option<HoodieInstant> currentTxnOwnerInstant;
    private Option<HoodieInstant> lastCompletedTxnOwnerInstant;
    private boolean supportsOptimisticConcurrency;

    public TransactionManager(HoodieWriteConfig config, FileSystem fs) {
        this.lockManager = new LockManager(config, fs);
        this.supportsOptimisticConcurrency = config.getWriteConcurrencyMode().supportsOptimisticConcurrencyControl();
    }

    public synchronized void beginTransaction() {
        if (this.supportsOptimisticConcurrency) {
            LOG.info((Object)"Transaction starting without a transaction owner");
            this.lockManager.lock();
            LOG.info((Object)"Transaction started");
        }
    }

    public synchronized void beginTransaction(Option<HoodieInstant> currentTxnOwnerInstant, Option<HoodieInstant> lastCompletedTxnOwnerInstant) {
        if (this.supportsOptimisticConcurrency) {
            this.lastCompletedTxnOwnerInstant = lastCompletedTxnOwnerInstant;
            this.lockManager.setLatestCompletedWriteInstant(lastCompletedTxnOwnerInstant);
            LOG.info((Object)("Latest completed transaction instant " + lastCompletedTxnOwnerInstant));
            this.currentTxnOwnerInstant = currentTxnOwnerInstant;
            LOG.info((Object)("Transaction starting with transaction owner " + currentTxnOwnerInstant));
            this.lockManager.lock();
            LOG.info((Object)"Transaction started");
        }
    }

    public synchronized void endTransaction() {
        if (this.supportsOptimisticConcurrency) {
            LOG.info((Object)("Transaction ending with transaction owner " + this.currentTxnOwnerInstant));
            this.lockManager.unlock();
            LOG.info((Object)"Transaction ended");
            this.lastCompletedTxnOwnerInstant = Option.empty();
            this.lockManager.resetLatestCompletedWriteInstant();
        }
    }

    public void close() {
        if (this.supportsOptimisticConcurrency) {
            this.lockManager.close();
            LOG.info((Object)"Transaction manager closed");
        }
    }

    public Option<HoodieInstant> getLastCompletedTransactionOwner() {
        return this.lastCompletedTxnOwnerInstant;
    }

    public Option<HoodieInstant> getCurrentTransactionOwner() {
        return this.currentTxnOwnerInstant;
    }
}

