/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.utils;

import java.util.Iterator;

public abstract class LazyIterableIterator<I, O>
implements Iterable<O>,
Iterator<O> {
    protected Iterator<I> inputItr;
    private boolean consumed = false;
    private boolean startCalled = false;
    private boolean endCalled = false;

    public LazyIterableIterator(Iterator<I> in) {
        this.inputItr = in;
    }

    protected abstract void start();

    protected abstract O computeNext();

    protected abstract void end();

    private void invokeStartIfNeeded() {
        if (!this.startCalled) {
            this.startCalled = true;
            try {
                this.start();
            }
            catch (Exception e) {
                throw new RuntimeException("Error in start()");
            }
        }
    }

    private void invokeEndIfNeeded() {
        if (!this.endCalled) {
            this.endCalled = true;
            try {
                this.end();
            }
            catch (Exception e) {
                throw new RuntimeException("Error in end()");
            }
        }
    }

    @Override
    public Iterator<O> iterator() {
        if (this.consumed) {
            throw new RuntimeException("Invalid repeated inputItr consumption.");
        }
        this.consumed = true;
        return this;
    }

    @Override
    public boolean hasNext() {
        boolean ret = this.inputItr.hasNext();
        this.invokeStartIfNeeded();
        if (!ret) {
            this.invokeEndIfNeeded();
        }
        return ret;
    }

    @Override
    public O next() {
        try {
            return this.computeNext();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void remove() {
        throw new RuntimeException("Unsupported remove operation.");
    }
}

