/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.com.beust.jcommander;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.hudi.com.beust.jcommander.DynamicParameter;
import org.apache.hudi.com.beust.jcommander.Parameter;
import org.apache.hudi.com.beust.jcommander.ParameterException;
import org.apache.hudi.com.beust.jcommander.ParametersDelegate;
import org.apache.hudi.com.beust.jcommander.WrappedParameter;
import org.apache.hudi.com.beust.jcommander.internal.Lists;
import org.apache.hudi.com.beust.jcommander.internal.Sets;

public class Parameterized {
    private Field field;
    private Method method;
    private Method getter;
    private WrappedParameter wrappedParameter;
    private ParametersDelegate parametersDelegate;

    public Parameterized(WrappedParameter wrappedParameter, ParametersDelegate parametersDelegate, Field field, Method method) {
        this.wrappedParameter = wrappedParameter;
        this.method = method;
        this.field = field;
        if (this.field != null) {
            if (parametersDelegate == null) {
                Parameterized.setFieldAccessible(this.field);
            } else {
                Parameterized.setFieldAccessibleWithoutFinalCheck(this.field);
            }
        }
        this.parametersDelegate = parametersDelegate;
    }

    private static void describeClassTree(Class<?> clazz, Set<Class<?>> set) {
        if (clazz == null) {
            return;
        }
        if (Object.class.equals(clazz) || set.contains(clazz)) {
            return;
        }
        set.add(clazz);
        Parameterized.describeClassTree(clazz.getSuperclass(), set);
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            Parameterized.describeClassTree(clazz2, set);
        }
    }

    private static Set<Class<?>> describeClassTree(Class<?> clazz) {
        if (clazz == null) {
            return Collections.emptySet();
        }
        Set<Class<?>> set = Sets.newLinkedHashSet();
        Parameterized.describeClassTree(clazz, set);
        return set;
    }

    public static List<Parameterized> parseArg(Object object) {
        List<Parameterized> list = Lists.newArrayList();
        Class<?> clazz = object.getClass();
        Set<Class<?>> set = Parameterized.describeClassTree(clazz);
        for (Class<?> clazz2 : set) {
            DynamicParameter dynamicParameter;
            ParametersDelegate parametersDelegate;
            Parameter parameter;
            for (Field field : clazz2.getDeclaredFields()) {
                parameter = field.getAnnotation(Parameter.class);
                parametersDelegate = field.getAnnotation(ParametersDelegate.class);
                dynamicParameter = field.getAnnotation(DynamicParameter.class);
                if (parameter != null) {
                    list.add(new Parameterized(new WrappedParameter(parameter), null, field, null));
                    continue;
                }
                if (dynamicParameter != null) {
                    list.add(new Parameterized(new WrappedParameter(dynamicParameter), null, field, null));
                    continue;
                }
                if (parametersDelegate == null) continue;
                list.add(new Parameterized(null, parametersDelegate, field, null));
            }
            for (AccessibleObject accessibleObject : clazz2.getDeclaredMethods()) {
                ((Method)accessibleObject).setAccessible(true);
                parameter = ((Method)accessibleObject).getAnnotation(Parameter.class);
                parametersDelegate = ((Method)accessibleObject).getAnnotation(ParametersDelegate.class);
                dynamicParameter = ((Method)accessibleObject).getAnnotation(DynamicParameter.class);
                if (parameter != null) {
                    list.add(new Parameterized(new WrappedParameter(parameter), null, null, (Method)accessibleObject));
                    continue;
                }
                if (dynamicParameter != null) {
                    list.add(new Parameterized(new WrappedParameter(dynamicParameter), null, null, (Method)accessibleObject));
                    continue;
                }
                if (parametersDelegate == null) continue;
                list.add(new Parameterized(null, parametersDelegate, null, (Method)accessibleObject));
            }
        }
        return list;
    }

    public WrappedParameter getWrappedParameter() {
        return this.wrappedParameter;
    }

    public Class<?> getType() {
        if (this.method != null) {
            return this.method.getParameterTypes()[0];
        }
        return this.field.getType();
    }

    public String getName() {
        if (this.method != null) {
            return this.method.getName();
        }
        return this.field.getName();
    }

    public Object get(Object object) {
        try {
            if (this.method != null) {
                if (this.getter == null) {
                    this.getter = this.method.getDeclaringClass().getMethod("g" + this.method.getName().substring(1), new Class[0]);
                }
                return this.getter.invoke(object, new Object[0]);
            }
            return this.field.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException exception) {
            throw new ParameterException(exception);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string = this.method.getName();
            String string2 = Character.toLowerCase(string.charAt(3)) + string.substring(4);
            Object object2 = null;
            try {
                Field field = this.method.getDeclaringClass().getDeclaredField(string2);
                if (field != null) {
                    Parameterized.setFieldAccessible(field);
                    object2 = field.get(object);
                }
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
            return object2;
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.field == null ? 0 : this.field.hashCode());
        n = 31 * n + (this.method == null ? 0 : this.method.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Parameterized parameterized = (Parameterized)object;
        if (this.field == null ? parameterized.field != null : !this.field.equals(parameterized.field)) {
            return false;
        }
        return !(this.method == null ? parameterized.method != null : !this.method.equals(parameterized.method));
    }

    public boolean isDynamicParameter(Field field) {
        if (this.method != null) {
            return this.method.getAnnotation(DynamicParameter.class) != null;
        }
        return this.field.getAnnotation(DynamicParameter.class) != null;
    }

    private static void setFieldAccessible(Field field) {
        if (Modifier.isFinal(field.getModifiers())) {
            throw new ParameterException("Cannot use final field " + field.getDeclaringClass().getName() + "#" + field.getName() + " as a parameter; compile-time constant inlining may hide new values written to it.");
        }
        field.setAccessible(true);
    }

    private static void setFieldAccessibleWithoutFinalCheck(Field field) {
        field.setAccessible(true);
    }

    private static String errorMessage(Method method, Exception exception) {
        return "Could not invoke " + method + "\n    Reason: " + exception.getMessage();
    }

    public void set(Object object, Object object2) {
        try {
            if (this.method != null) {
                this.method.invoke(object, object2);
            } else {
                this.field.set(object, object2);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            throw new ParameterException(Parameterized.errorMessage(this.method, exception));
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof ParameterException) {
                throw (ParameterException)invocationTargetException.getTargetException();
            }
            throw new ParameterException(Parameterized.errorMessage(this.method, invocationTargetException));
        }
    }

    public ParametersDelegate getDelegateAnnotation() {
        return this.parametersDelegate;
    }

    public Type getGenericType() {
        if (this.method != null) {
            return this.method.getGenericParameterTypes()[0];
        }
        return this.field.getGenericType();
    }

    public Parameter getParameter() {
        return this.wrappedParameter.getParameter();
    }

    public Type findFieldGenericType() {
        ParameterizedType parameterizedType;
        Type type;
        if (this.method != null) {
            return null;
        }
        if (this.field.getGenericType() instanceof ParameterizedType && (type = (parameterizedType = (ParameterizedType)this.field.getGenericType()).getActualTypeArguments()[0]) instanceof Class) {
            return type;
        }
        return null;
    }

    public boolean isDynamicParameter() {
        return this.wrappedParameter.getDynamicParameter() != null;
    }
}

