/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.com.yammer.metrics.core;

import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hudi.com.yammer.metrics.core.HealthCheck;

public class HealthCheckRegistry {
    private final ConcurrentMap<String, HealthCheck> healthChecks = new ConcurrentHashMap<String, HealthCheck>();

    public void register(HealthCheck healthCheck) {
        this.healthChecks.putIfAbsent(healthCheck.getName(), healthCheck);
    }

    public void unregister(String name) {
        this.healthChecks.remove(name);
    }

    public void unregister(HealthCheck healthCheck) {
        this.unregister(healthCheck.getName());
    }

    public SortedMap<String, HealthCheck.Result> runHealthChecks() {
        TreeMap results = new TreeMap();
        for (Map.Entry entry : this.healthChecks.entrySet()) {
            HealthCheck.Result result = ((HealthCheck)entry.getValue()).execute();
            results.put(entry.getKey(), result);
        }
        return Collections.unmodifiableSortedMap(results);
    }
}

