/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.log.AbstractHoodieLogRecordReader;
import org.apache.hudi.common.table.log.InstantRange;
import org.apache.hudi.common.util.DefaultSizeEstimator;
import org.apache.hudi.common.util.HoodieRecordSizeEstimator;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.SpillableMapUtils;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieMergedLogRecordScanner
extends AbstractHoodieLogRecordReader
implements Iterable<HoodieRecord<? extends HoodieRecordPayload>> {
    private static final Logger LOG = LogManager.getLogger(HoodieMergedLogRecordScanner.class);
    protected final ExternalSpillableMap<String, HoodieRecord<? extends HoodieRecordPayload>> records;
    private long numMergedRecordsInLog;
    private long maxMemorySizeInBytes;
    private long totalTimeTakenToReadAndMergeBlocks;
    public final HoodieTimer timer = new HoodieTimer();

    protected HoodieMergedLogRecordScanner(FileSystem fs, String basePath, List<String> logFilePaths, Schema readerSchema, String latestInstantTime, Long maxMemorySizeInBytes, boolean readBlocksLazily, boolean reverseReader, int bufferSize, String spillableMapBasePath, Option<InstantRange> instantRange, boolean autoScan, ExternalSpillableMap.DiskMapType diskMapType, boolean isBitCaskDiskMapCompressionEnabled, boolean withOperationField, boolean enableFullScan, Option<String> partitionName) {
        super(fs, basePath, logFilePaths, readerSchema, latestInstantTime, readBlocksLazily, reverseReader, bufferSize, instantRange, withOperationField, enableFullScan, partitionName);
        try {
            this.records = new ExternalSpillableMap(maxMemorySizeInBytes, spillableMapBasePath, new DefaultSizeEstimator(), new HoodieRecordSizeEstimator(readerSchema), diskMapType, isBitCaskDiskMapCompressionEnabled);
            this.maxMemorySizeInBytes = maxMemorySizeInBytes;
        }
        catch (IOException e) {
            throw new HoodieIOException("IOException when creating ExternalSpillableMap at " + spillableMapBasePath, e);
        }
        if (autoScan) {
            this.performScan();
        }
    }

    protected void performScan() {
        this.timer.startTimer();
        this.scan();
        this.totalTimeTakenToReadAndMergeBlocks = this.timer.endTimer();
        this.numMergedRecordsInLog = this.records.size();
        LOG.info((Object)("Number of log files scanned => " + this.logFilePaths.size()));
        LOG.info((Object)("MaxMemoryInBytes allowed for compaction => " + this.maxMemorySizeInBytes));
        LOG.info((Object)("Number of entries in MemoryBasedMap in ExternalSpillableMap => " + this.records.getInMemoryMapNumEntries()));
        LOG.info((Object)("Total size in bytes of MemoryBasedMap in ExternalSpillableMap => " + this.records.getCurrentInMemoryMapSize()));
        LOG.info((Object)("Number of entries in BitCaskDiskMap in ExternalSpillableMap => " + this.records.getDiskBasedMapNumEntries()));
        LOG.info((Object)("Size of file spilled to disk => " + this.records.getSizeOfFileOnDiskInBytes()));
    }

    @Override
    public Iterator<HoodieRecord<? extends HoodieRecordPayload>> iterator() {
        return this.records.iterator();
    }

    public Map<String, HoodieRecord<? extends HoodieRecordPayload>> getRecords() {
        return this.records;
    }

    public long getNumMergedRecordsInLog() {
        return this.numMergedRecordsInLog;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    protected void processNextRecord(HoodieRecord<? extends HoodieRecordPayload> hoodieRecord) throws IOException {
        String key = hoodieRecord.getRecordKey();
        if (this.records.containsKey(key)) {
            HoodieRecord oldRecord = (HoodieRecord)this.records.get(key);
            Object oldValue = oldRecord.getData();
            Object combinedValue = hoodieRecord.getData().preCombine(oldValue);
            boolean choosePrev = combinedValue.equals(oldValue);
            HoodieOperation operation = choosePrev ? oldRecord.getOperation() : hoodieRecord.getOperation();
            this.records.put(key, new HoodieRecord(new HoodieKey(key, hoodieRecord.getPartitionPath()), combinedValue, operation));
        } else {
            this.records.put(key, hoodieRecord);
        }
    }

    @Override
    protected void processNextDeletedKey(HoodieKey hoodieKey) {
        this.records.put(hoodieKey.getRecordKey(), (HoodieRecord<? extends HoodieRecordPayload>)((Serializable)SpillableMapUtils.generateEmptyPayload(hoodieKey.getRecordKey(), hoodieKey.getPartitionPath(), this.getPayloadClassFQN())));
    }

    public long getTotalTimeTakenToReadAndMergeBlocks() {
        return this.totalTimeTakenToReadAndMergeBlocks;
    }

    public void close() {
        if (this.records != null) {
            this.records.close();
        }
    }

    public static class Builder
    extends AbstractHoodieLogRecordReader.Builder {
        protected FileSystem fs;
        protected String basePath;
        protected List<String> logFilePaths;
        protected Schema readerSchema;
        protected String latestInstantTime;
        protected boolean readBlocksLazily;
        protected boolean reverseReader;
        protected int bufferSize;
        protected Long maxMemorySizeInBytes;
        protected String spillableMapBasePath;
        protected ExternalSpillableMap.DiskMapType diskMapType = HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE.defaultValue();
        protected boolean isBitCaskDiskMapCompressionEnabled = HoodieCommonConfig.DISK_MAP_BITCASK_COMPRESSION_ENABLED.defaultValue();
        protected Option<InstantRange> instantRange = Option.empty();
        private boolean autoScan = true;
        private boolean withOperationField = false;
        protected String partitionName;

        @Override
        public Builder withFileSystem(FileSystem fs) {
            this.fs = fs;
            return this;
        }

        @Override
        public Builder withBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        @Override
        public Builder withLogFilePaths(List<String> logFilePaths) {
            this.logFilePaths = logFilePaths;
            return this;
        }

        @Override
        public Builder withReaderSchema(Schema schema2) {
            this.readerSchema = schema2;
            return this;
        }

        @Override
        public Builder withLatestInstantTime(String latestInstantTime) {
            this.latestInstantTime = latestInstantTime;
            return this;
        }

        @Override
        public Builder withReadBlocksLazily(boolean readBlocksLazily) {
            this.readBlocksLazily = readBlocksLazily;
            return this;
        }

        @Override
        public Builder withReverseReader(boolean reverseReader) {
            this.reverseReader = reverseReader;
            return this;
        }

        @Override
        public Builder withBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        @Override
        public Builder withInstantRange(Option<InstantRange> instantRange) {
            this.instantRange = instantRange;
            return this;
        }

        public Builder withMaxMemorySizeInBytes(Long maxMemorySizeInBytes) {
            this.maxMemorySizeInBytes = maxMemorySizeInBytes;
            return this;
        }

        public Builder withSpillableMapBasePath(String spillableMapBasePath) {
            this.spillableMapBasePath = spillableMapBasePath;
            return this;
        }

        public Builder withDiskMapType(ExternalSpillableMap.DiskMapType diskMapType) {
            this.diskMapType = diskMapType;
            return this;
        }

        public Builder withBitCaskDiskMapCompressionEnabled(boolean isBitCaskDiskMapCompressionEnabled) {
            this.isBitCaskDiskMapCompressionEnabled = isBitCaskDiskMapCompressionEnabled;
            return this;
        }

        public Builder withAutoScan(boolean autoScan) {
            this.autoScan = autoScan;
            return this;
        }

        @Override
        public Builder withOperationField(boolean withOperationField) {
            this.withOperationField = withOperationField;
            return this;
        }

        @Override
        public Builder withPartition(String partitionName) {
            this.partitionName = partitionName;
            return this;
        }

        @Override
        public HoodieMergedLogRecordScanner build() {
            return new HoodieMergedLogRecordScanner(this.fs, this.basePath, this.logFilePaths, this.readerSchema, this.latestInstantTime, this.maxMemorySizeInBytes, this.readBlocksLazily, this.reverseReader, this.bufferSize, this.spillableMapBasePath, this.instantRange, this.autoScan, this.diskMapType, this.isBitCaskDiskMapCompressionEnabled, this.withOperationField, true, Option.ofNullable(this.partitionName));
        }
    }
}

