/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log;

import java.io.Serializable;
import java.util.Objects;
import org.apache.hudi.common.table.timeline.HoodieTimeline;

public abstract class InstantRange
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final String startInstant;
    protected final String endInstant;

    public InstantRange(String startInstant, String endInstant) {
        this.startInstant = Objects.requireNonNull(startInstant);
        this.endInstant = Objects.requireNonNull(endInstant);
    }

    public static InstantRange getInstance(String startInstant, String endInstant, RangeType rangeType) {
        switch (rangeType) {
            case OPEN_CLOSE: {
                return new OpenCloseRange(startInstant, endInstant);
            }
            case CLOSE_CLOSE: {
                return new CloseCloseRange(startInstant, endInstant);
            }
        }
        throw new AssertionError();
    }

    public String getStartInstant() {
        return this.startInstant;
    }

    public String getEndInstant() {
        return this.endInstant;
    }

    public abstract boolean isInRange(String var1);

    private static class CloseCloseRange
    extends InstantRange {
        public CloseCloseRange(String startInstant, String endInstant) {
            super(startInstant, endInstant);
        }

        @Override
        public boolean isInRange(String instant) {
            return HoodieTimeline.compareTimestamps(instant, HoodieTimeline.GREATER_THAN_OR_EQUALS, this.startInstant);
        }
    }

    private static class OpenCloseRange
    extends InstantRange {
        public OpenCloseRange(String startInstant, String endInstant) {
            super(startInstant, endInstant);
        }

        @Override
        public boolean isInRange(String instant) {
            return HoodieTimeline.compareTimestamps(instant, HoodieTimeline.GREATER_THAN, this.startInstant);
        }
    }

    public static enum RangeType {
        OPEN_CLOSE,
        CLOSE_CLOSE;

    }
}

