/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log.block;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.util.Option;

public class HoodieCorruptBlock
extends HoodieLogBlock {
    private HoodieCorruptBlock(Option<byte[]> corruptedBytes, FSDataInputStream inputStream, boolean readBlockLazily, Option<HoodieLogBlock.HoodieLogBlockContentLocation> blockContentLocation, Map<HoodieLogBlock.HeaderMetadataType, String> header, Map<HoodieLogBlock.HeaderMetadataType, String> footer) {
        super(header, footer, blockContentLocation, corruptedBytes, inputStream, readBlockLazily);
    }

    @Override
    public byte[] getContentBytes() throws IOException {
        if (!this.getContent().isPresent() && this.readBlockLazily) {
            this.inflate();
        }
        return this.getContent().get();
    }

    @Override
    public HoodieLogBlock.HoodieLogBlockType getBlockType() {
        return HoodieLogBlock.HoodieLogBlockType.CORRUPT_BLOCK;
    }

    public static HoodieLogBlock getBlock(HoodieLogFile logFile, FSDataInputStream inputStream, Option<byte[]> corruptedBytes, boolean readBlockLazily, long position, long blockSize, long blockEndPos, Map<HoodieLogBlock.HeaderMetadataType, String> header, Map<HoodieLogBlock.HeaderMetadataType, String> footer) {
        return new HoodieCorruptBlock(corruptedBytes, inputStream, readBlockLazily, Option.of(new HoodieLogBlock.HoodieLogBlockContentLocation(logFile, position, blockSize, blockEndPos)), header, footer);
    }
}

