/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieTimeline;

public class HoodieInstantTimeGenerator {
    public static final String SECS_INSTANT_TIMESTAMP_FORMAT = "yyyyMMddHHmmss";
    public static final int SECS_INSTANT_ID_LENGTH = "yyyyMMddHHmmss".length();
    public static final String MILLIS_INSTANT_TIMESTAMP_FORMAT = "yyyyMMddHHmmssSSS";
    public static final int MILLIS_INSTANT_ID_LENGTH = "yyyyMMddHHmmssSSS".length();
    public static final int MILLIS_INSTANT_TIMESTAMP_FORMAT_LENGTH = "yyyyMMddHHmmssSSS".length();
    private static DateTimeFormatter MILLIS_INSTANT_TIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyyMMddHHmmss").appendValue(ChronoField.MILLI_OF_SECOND, 3).toFormatter();
    private static final String MILLIS_GRANULARITY_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private static DateTimeFormatter MILLIS_GRANULARITY_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private static AtomicReference<String> lastInstantTime = new AtomicReference<String>(String.valueOf(Integer.MIN_VALUE));
    private static final String ALL_ZERO_TIMESTAMP = "00000000000000";
    private static final String DEFAULT_MILLIS_EXT = "999";

    public static String createNewInstantTime(long milliseconds) {
        return lastInstantTime.updateAndGet(oldVal -> {
            Date d;
            String newCommitTime;
            while (HoodieTimeline.compareTimestamps(newCommitTime = MILLIS_INSTANT_TIME_FORMATTER.format(HoodieInstantTimeGenerator.convertDateToTemporalAccessor(d = new Date(System.currentTimeMillis() + milliseconds))), HoodieActiveTimeline.LESSER_THAN_OR_EQUALS, oldVal)) {
            }
            return newCommitTime;
        });
    }

    public static Date parseDateFromInstantTime(String timestamp) throws ParseException {
        try {
            String timestampInMillis = timestamp;
            if (HoodieInstantTimeGenerator.isSecondGranularity(timestamp)) {
                timestampInMillis = timestamp + DEFAULT_MILLIS_EXT;
            } else if (timestamp.length() > MILLIS_INSTANT_TIMESTAMP_FORMAT_LENGTH) {
                timestampInMillis = timestamp.substring(0, MILLIS_INSTANT_TIMESTAMP_FORMAT_LENGTH);
            }
            LocalDateTime dt = LocalDateTime.parse(timestampInMillis, MILLIS_INSTANT_TIME_FORMATTER);
            return Date.from(dt.atZone(ZoneId.systemDefault()).toInstant());
        }
        catch (DateTimeParseException e) {
            if (timestamp.equals(ALL_ZERO_TIMESTAMP)) {
                return new Date(0L);
            }
            throw e;
        }
    }

    private static boolean isSecondGranularity(String instant) {
        return instant.length() == SECS_INSTANT_ID_LENGTH;
    }

    public static String formatInstantTime(Instant timestamp) {
        return MILLIS_INSTANT_TIME_FORMATTER.format(timestamp);
    }

    public static String formatDate(Date timestamp) {
        return HoodieInstantTimeGenerator.getInstantFromTemporalAccessor(HoodieInstantTimeGenerator.convertDateToTemporalAccessor(timestamp));
    }

    public static String getInstantFromTemporalAccessor(TemporalAccessor temporalAccessor) {
        return MILLIS_INSTANT_TIME_FORMATTER.format(temporalAccessor);
    }

    public static String getInstantForDateString(String dateString) {
        try {
            return HoodieInstantTimeGenerator.getInstantFromTemporalAccessor(LocalDateTime.parse(dateString, MILLIS_GRANULARITY_DATE_FORMATTER));
        }
        catch (Exception e) {
            return HoodieInstantTimeGenerator.getInstantFromTemporalAccessor(LocalDateTime.parse(String.format("%s:%s", dateString, DEFAULT_MILLIS_EXT), MILLIS_GRANULARITY_DATE_FORMATTER));
        }
    }

    private static TemporalAccessor convertDateToTemporalAccessor(Date d) {
        return d.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }
}

