/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.ddl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.fs.StorageSchemes;
import org.apache.hudi.common.util.PartitionPathEncodeUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HoodieHiveSyncException;
import org.apache.hudi.hive.PartitionValueExtractor;
import org.apache.hudi.hive.ddl.DDLExecutor;
import org.apache.hudi.hive.util.HiveSchemaUtil;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.parquet.schema.MessageType;

public abstract class QueryBasedDDLExecutor
implements DDLExecutor {
    private static final Logger LOG = LogManager.getLogger(QueryBasedDDLExecutor.class);
    private final HiveSyncConfig config;
    private final PartitionValueExtractor partitionValueExtractor;
    private final FileSystem fs;

    public QueryBasedDDLExecutor(HiveSyncConfig config, FileSystem fs) {
        this.fs = fs;
        this.config = config;
        try {
            this.partitionValueExtractor = (PartitionValueExtractor)Class.forName(config.partitionValueExtractorClass).newInstance();
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to initialize PartitionValueExtractor class " + config.partitionValueExtractorClass, e);
        }
    }

    public abstract void runSQL(String var1);

    @Override
    public void createDatabase(String databaseName) {
        this.runSQL("create database if not exists " + databaseName);
    }

    @Override
    public void createTable(String tableName, MessageType storageSchema, String inputFormatClass, String outputFormatClass, String serdeClass, Map<String, String> serdeProperties, Map<String, String> tableProperties) {
        try {
            String createSQLQuery = HiveSchemaUtil.generateCreateDDL(tableName, storageSchema, this.config, inputFormatClass, outputFormatClass, serdeClass, serdeProperties, tableProperties);
            LOG.info((Object)("Creating table with " + createSQLQuery));
            this.runSQL(createSQLQuery);
        }
        catch (IOException e) {
            throw new HoodieHiveSyncException("Failed to create table " + tableName, e);
        }
    }

    @Override
    public void updateTableDefinition(String tableName, MessageType newSchema) {
        try {
            String newSchemaStr = HiveSchemaUtil.generateSchemaString(newSchema, this.config.partitionFields, this.config.supportTimestamp);
            String cascadeClause = this.config.partitionFields.size() > 0 ? " cascade" : "";
            StringBuilder sqlBuilder = new StringBuilder("ALTER TABLE ").append("`").append(this.config.databaseName).append("`").append(".").append("`").append(tableName).append("`").append(" REPLACE COLUMNS(").append(newSchemaStr).append(" )").append(cascadeClause);
            LOG.info((Object)("Updating table definition with " + sqlBuilder));
            this.runSQL(sqlBuilder.toString());
        }
        catch (IOException e) {
            throw new HoodieHiveSyncException("Failed to update table for " + tableName, e);
        }
    }

    @Override
    public void addPartitionsToTable(String tableName, List<String> partitionsToAdd) {
        if (partitionsToAdd.isEmpty()) {
            LOG.info((Object)("No partitions to add for " + tableName));
            return;
        }
        LOG.info((Object)("Adding partitions " + partitionsToAdd.size() + " to table " + tableName));
        List<String> sqls = this.constructAddPartitions(tableName, partitionsToAdd);
        sqls.stream().forEach(sql -> this.runSQL((String)sql));
    }

    @Override
    public void updatePartitionsToTable(String tableName, List<String> changedPartitions) {
        if (changedPartitions.isEmpty()) {
            LOG.info((Object)("No partitions to change for " + tableName));
            return;
        }
        LOG.info((Object)("Changing partitions " + changedPartitions.size() + " on " + tableName));
        List<String> sqls = this.constructChangePartitions(tableName, changedPartitions);
        for (String sql : sqls) {
            this.runSQL(sql);
        }
    }

    private List<String> constructAddPartitions(String tableName, List<String> partitions) {
        if (this.config.batchSyncNum <= 0) {
            throw new HoodieHiveSyncException("batch-sync-num for sync hive table must be greater than 0, pls check your parameter");
        }
        ArrayList<String> result = new ArrayList<String>();
        int batchSyncPartitionNum = this.config.batchSyncNum;
        StringBuilder alterSQL = this.getAlterTablePrefix(tableName);
        for (int i = 0; i < partitions.size(); ++i) {
            String partitionClause = this.getPartitionClause(partitions.get(i));
            String fullPartitionPath = FSUtils.getPartitionPath(this.config.basePath, partitions.get(i)).toString();
            alterSQL.append("  PARTITION (").append(partitionClause).append(") LOCATION '").append(fullPartitionPath).append("' ");
            if ((i + 1) % batchSyncPartitionNum != 0) continue;
            result.add(alterSQL.toString());
            alterSQL = this.getAlterTablePrefix(tableName);
        }
        if (partitions.size() % batchSyncPartitionNum != 0) {
            result.add(alterSQL.toString());
        }
        return result;
    }

    private StringBuilder getAlterTablePrefix(String tableName) {
        StringBuilder alterSQL = new StringBuilder("ALTER TABLE ");
        alterSQL.append("`").append(this.config.databaseName).append("`").append(".").append("`").append(tableName).append("`").append(" ADD IF NOT EXISTS ");
        return alterSQL;
    }

    private String getPartitionClause(String partition) {
        List<String> partitionValues = this.partitionValueExtractor.extractPartitionValuesInPath(partition);
        ValidationUtils.checkArgument(this.config.partitionFields.size() == partitionValues.size(), "Partition key parts " + this.config.partitionFields + " does not match with partition values " + partitionValues + ". Check partition strategy. ");
        ArrayList<String> partBuilder = new ArrayList<String>();
        for (int i = 0; i < this.config.partitionFields.size(); ++i) {
            String partitionValue = partitionValues.get(i);
            if (this.config.decodePartition.booleanValue()) {
                partitionValue = PartitionPathEncodeUtils.unescapePathName(partitionValue);
            }
            partBuilder.add("`" + this.config.partitionFields.get(i) + "`='" + partitionValue + "'");
        }
        return String.join((CharSequence)",", partBuilder);
    }

    private List<String> constructChangePartitions(String tableName, List<String> partitions) {
        ArrayList<String> changePartitions = new ArrayList<String>();
        String useDatabase = "USE `" + this.config.databaseName + "`";
        changePartitions.add(useDatabase);
        String alterTable = "ALTER TABLE `" + tableName + "`";
        for (String partition : partitions) {
            String partitionClause = this.getPartitionClause(partition);
            Path partitionPath = FSUtils.getPartitionPath(this.config.basePath, partition);
            String partitionScheme = partitionPath.toUri().getScheme();
            String fullPartitionPath = StorageSchemes.HDFS.getScheme().equals(partitionScheme) ? FSUtils.getDFSFullPartitionPath(this.fs, partitionPath) : partitionPath.toString();
            String changePartition = alterTable + " PARTITION (" + partitionClause + ") SET LOCATION '" + fullPartitionPath + "'";
            changePartitions.add(changePartition);
        }
        return changePartitions;
    }
}

