/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.replication;

import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.hive.replication.GlobalHiveSyncConfig;
import org.apache.hudi.hive.replication.GlobalHiveSyncTool;

public class ReplicationStateSync {
    private GlobalHiveSyncTool globalHiveSyncTool;
    private final GlobalHiveSyncConfig globalHiveSyncConfig;
    private final HiveConf hiveConf;
    private Map<String, Option<String>> replicatedTimeStampMap;
    private Map<String, Option<String>> oldReplicatedTimeStampMap;
    private final String clusterId;

    ReplicationStateSync(GlobalHiveSyncConfig conf, HiveConf hiveConf, String uid) {
        this.globalHiveSyncConfig = conf;
        this.hiveConf = hiveConf;
        this.initGlobalHiveSyncTool();
        this.replicatedTimeStampMap = this.globalHiveSyncTool.getLastReplicatedTimeStampMap();
        this.clusterId = uid;
    }

    private void initGlobalHiveSyncTool() {
        this.globalHiveSyncTool = GlobalHiveSyncTool.buildGlobalHiveSyncTool(this.globalHiveSyncConfig, this.hiveConf);
    }

    public void sync() throws Exception {
        this.replicatedTimeStampMap = this.globalHiveSyncTool.getLastReplicatedTimeStampMap();
        this.oldReplicatedTimeStampMap = this.replicatedTimeStampMap;
        this.globalHiveSyncTool.syncHoodieTable();
        this.replicatedTimeStampMap = this.globalHiveSyncTool.getLastReplicatedTimeStampMap();
    }

    public boolean rollback() {
        if (this.oldReplicatedTimeStampMap != null) {
            this.globalHiveSyncTool.setLastReplicatedTimeStamp(this.oldReplicatedTimeStampMap);
            this.oldReplicatedTimeStampMap = null;
        }
        return true;
    }

    public boolean replicationStateIsInSync(ReplicationStateSync other) {
        return this.globalHiveSyncTool.getLastReplicatedTimeStampMap().equals(other.globalHiveSyncTool.getLastReplicatedTimeStampMap());
    }

    public String toString() {
        return "{ clusterId: " + this.clusterId + " replicatedState: " + this.replicatedTimeStampMap + " }";
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public void close() {
        if (this.globalHiveSyncTool != null) {
            this.globalHiveSyncTool.close();
            this.globalHiveSyncTool = null;
        }
    }
}

