/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.hudi.DataSourceWriteOptions;
import org.apache.hudi.client.HoodieInternalWriteStatus;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.storage.row.HoodieRowCreateHandle;
import org.apache.hudi.io.storage.row.HoodieRowCreateHandleWithoutMetaFields;
import org.apache.hudi.keygen.BuiltinKeyGenerator;
import org.apache.hudi.keygen.NonpartitionedKeyGenerator;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.hudi.table.HoodieTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;

public class BulkInsertDataInternalWriterHelper {
    private static final Logger LOG = LogManager.getLogger(BulkInsertDataInternalWriterHelper.class);
    private final String instantTime;
    private final int taskPartitionId;
    private final long taskId;
    private final long taskEpochId;
    private final HoodieTable hoodieTable;
    private final HoodieWriteConfig writeConfig;
    private final StructType structType;
    private final Boolean arePartitionRecordsSorted;
    private final List<HoodieInternalWriteStatus> writeStatusList = new ArrayList<HoodieInternalWriteStatus>();
    private HoodieRowCreateHandle handle;
    private String lastKnownPartitionPath = null;
    private String fileIdPrefix;
    private int numFilesWritten = 0;
    private Map<String, HoodieRowCreateHandle> handles = new HashMap<String, HoodieRowCreateHandle>();
    private final boolean populateMetaFields;
    private Option<BuiltinKeyGenerator> keyGeneratorOpt = null;
    private boolean simpleKeyGen = false;
    private int simplePartitionFieldIndex = -1;
    private DataType simplePartitionFieldDataType;

    public BulkInsertDataInternalWriterHelper(HoodieTable hoodieTable, HoodieWriteConfig writeConfig, String instantTime, int taskPartitionId, long taskId, long taskEpochId, StructType structType, boolean populateMetaFields, boolean arePartitionRecordsSorted) {
        this.hoodieTable = hoodieTable;
        this.writeConfig = writeConfig;
        this.instantTime = instantTime;
        this.taskPartitionId = taskPartitionId;
        this.taskId = taskId;
        this.taskEpochId = taskEpochId;
        this.structType = structType;
        this.populateMetaFields = populateMetaFields;
        this.arePartitionRecordsSorted = arePartitionRecordsSorted;
        this.fileIdPrefix = UUID.randomUUID().toString();
        if (!populateMetaFields) {
            this.keyGeneratorOpt = this.getKeyGenerator(writeConfig.getProps());
            if (this.keyGeneratorOpt.isPresent() && this.keyGeneratorOpt.get() instanceof SimpleKeyGenerator) {
                this.simpleKeyGen = true;
                this.simplePartitionFieldIndex = (Integer)structType.getFieldIndex(this.keyGeneratorOpt.get().getPartitionPathFields().get(0)).get();
                this.simplePartitionFieldDataType = structType.fields()[this.simplePartitionFieldIndex].dataType();
            }
        }
    }

    private Option<BuiltinKeyGenerator> getKeyGenerator(Properties properties) {
        TypedProperties typedProperties = new TypedProperties();
        typedProperties.putAll((Map<?, ?>)properties);
        if (properties.get(DataSourceWriteOptions.KEYGENERATOR_CLASS_NAME().key()).equals(NonpartitionedKeyGenerator.class.getName())) {
            return Option.empty();
        }
        try {
            return Option.of((BuiltinKeyGenerator)HoodieSparkKeyGeneratorFactory.createKeyGenerator(typedProperties));
        }
        catch (ClassCastException cce) {
            throw new HoodieIOException("Only those key generators implementing BuiltInKeyGenerator interface is supported with virtual keys");
        }
        catch (IOException e) {
            throw new HoodieIOException("Key generator instantiation failed ", e);
        }
    }

    public void write(InternalRow record) throws IOException {
        try {
            String partitionPath = null;
            partitionPath = this.populateMetaFields ? record.getUTF8String(HoodieRecord.HOODIE_META_COLUMNS_NAME_TO_POS.get("_hoodie_partition_path").intValue()).toString() : (!this.keyGeneratorOpt.isPresent() ? "" : (this.simpleKeyGen ? record.get(this.simplePartitionFieldIndex, this.simplePartitionFieldDataType).toString() : this.keyGeneratorOpt.get().getPartitionPath(record, this.structType)));
            if (this.lastKnownPartitionPath == null || !this.lastKnownPartitionPath.equals(partitionPath) || !this.handle.canWrite()) {
                LOG.info((Object)("Creating new file for partition path " + partitionPath));
                this.handle = this.getRowCreateHandle(partitionPath);
                this.lastKnownPartitionPath = partitionPath;
            }
            this.handle.write(record);
        }
        catch (Throwable t) {
            LOG.error((Object)"Global error thrown while trying to write records in HoodieRowCreateHandle ", t);
            throw t;
        }
    }

    public List<HoodieInternalWriteStatus> getWriteStatuses() throws IOException {
        this.close();
        return this.writeStatusList;
    }

    public void abort() {
    }

    private HoodieRowCreateHandle getRowCreateHandle(String partitionPath) throws IOException {
        if (!this.handles.containsKey(partitionPath)) {
            if (this.arePartitionRecordsSorted.booleanValue()) {
                this.close();
            }
            HoodieRowCreateHandle rowCreateHandle = this.populateMetaFields ? new HoodieRowCreateHandle(this.hoodieTable, this.writeConfig, partitionPath, this.getNextFileId(), this.instantTime, this.taskPartitionId, this.taskId, this.taskEpochId, this.structType) : new HoodieRowCreateHandleWithoutMetaFields(this.hoodieTable, this.writeConfig, partitionPath, this.getNextFileId(), this.instantTime, this.taskPartitionId, this.taskId, this.taskEpochId, this.structType);
            this.handles.put(partitionPath, rowCreateHandle);
        } else if (!this.handles.get(partitionPath).canWrite()) {
            this.writeStatusList.add(this.handles.remove(partitionPath).close());
            HoodieRowCreateHandle rowCreateHandle = this.populateMetaFields ? new HoodieRowCreateHandle(this.hoodieTable, this.writeConfig, partitionPath, this.getNextFileId(), this.instantTime, this.taskPartitionId, this.taskId, this.taskEpochId, this.structType) : new HoodieRowCreateHandleWithoutMetaFields(this.hoodieTable, this.writeConfig, partitionPath, this.getNextFileId(), this.instantTime, this.taskPartitionId, this.taskId, this.taskEpochId, this.structType);
            this.handles.put(partitionPath, rowCreateHandle);
        }
        return this.handles.get(partitionPath);
    }

    public void close() throws IOException {
        for (HoodieRowCreateHandle rowCreateHandle : this.handles.values()) {
            this.writeStatusList.add(rowCreateHandle.close());
        }
        this.handles.clear();
        this.handle = null;
    }

    private String getNextFileId() {
        return String.format("%s-%d", this.fileIdPrefix, this.numFilesWritten++);
    }
}

