/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.HoodieRecord;

public interface HoodieFileWriter<R extends IndexedRecord> {
    public void writeAvroWithMetadata(R var1, HoodieRecord var2) throws IOException;

    public boolean canWrite();

    public void close() throws IOException;

    public void writeAvro(String var1, R var2) throws IOException;

    public long getBytesWritten();

    default public void prepRecordWithMetadata(R avroRecord, HoodieRecord record, String instantTime, Integer partitionId, AtomicLong recordIndex, String fileName) {
        String seqId = HoodieRecord.generateSequenceId(instantTime, partitionId, recordIndex.getAndIncrement());
        HoodieAvroUtils.addHoodieKeyToRecord((GenericRecord)avroRecord, record.getRecordKey(), record.getPartitionPath(), fileName);
        HoodieAvroUtils.addCommitMetadataToRecord((GenericRecord)avroRecord, instantTime, seqId);
    }
}

