/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroWriteSupport;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.storage.HoodieAvroParquetConfig;
import org.apache.hudi.io.storage.HoodieFileWriter;
import org.apache.hudi.io.storage.HoodieHFileConfig;
import org.apache.hudi.io.storage.HoodieHFileWriter;
import org.apache.hudi.io.storage.HoodieOrcConfig;
import org.apache.hudi.io.storage.HoodieOrcWriter;
import org.apache.hudi.io.storage.HoodieParquetWriter;
import org.apache.hudi.table.HoodieTable;
import org.apache.parquet.avro.AvroSchemaConverter;

public class HoodieFileWriterFactory {
    public static <T extends HoodieRecordPayload, R extends IndexedRecord, I, K, O> HoodieFileWriter<R> getFileWriter(String instantTime, Path path, HoodieTable<T, I, K, O> hoodieTable, HoodieWriteConfig config, Schema schema2, TaskContextSupplier taskContextSupplier) throws IOException {
        String extension = FSUtils.getFileExtension(path.getName());
        if (HoodieFileFormat.PARQUET.getFileExtension().equals(extension)) {
            return HoodieFileWriterFactory.newParquetFileWriter(instantTime, path, config, schema2, hoodieTable, taskContextSupplier, config.populateMetaFields());
        }
        if (HoodieFileFormat.HFILE.getFileExtension().equals(extension)) {
            return HoodieFileWriterFactory.newHFileFileWriter(instantTime, path, config, schema2, hoodieTable, taskContextSupplier);
        }
        if (HoodieFileFormat.ORC.getFileExtension().equals(extension)) {
            return HoodieFileWriterFactory.newOrcFileWriter(instantTime, path, config, schema2, hoodieTable, taskContextSupplier);
        }
        throw new UnsupportedOperationException(extension + " format not supported yet.");
    }

    private static <T extends HoodieRecordPayload, R extends IndexedRecord> HoodieFileWriter<R> newParquetFileWriter(String instantTime, Path path, HoodieWriteConfig config, Schema schema2, HoodieTable hoodieTable, TaskContextSupplier taskContextSupplier, boolean populateMetaFields) throws IOException {
        return HoodieFileWriterFactory.newParquetFileWriter(instantTime, path, config, schema2, hoodieTable, taskContextSupplier, populateMetaFields, populateMetaFields);
    }

    private static <T extends HoodieRecordPayload, R extends IndexedRecord> HoodieFileWriter<R> newParquetFileWriter(String instantTime, Path path, HoodieWriteConfig config, Schema schema2, HoodieTable hoodieTable, TaskContextSupplier taskContextSupplier, boolean populateMetaFields, boolean enableBloomFilter) throws IOException {
        Option<BloomFilter> filter = enableBloomFilter ? Option.of(HoodieFileWriterFactory.createBloomFilter(config)) : Option.empty();
        HoodieAvroWriteSupport writeSupport = new HoodieAvroWriteSupport(new AvroSchemaConverter(hoodieTable.getHadoopConf()).convert(schema2), schema2, filter);
        HoodieAvroParquetConfig parquetConfig = new HoodieAvroParquetConfig(writeSupport, config.getParquetCompressionCodec(), config.getParquetBlockSize(), config.getParquetPageSize(), config.getParquetMaxFileSize(), hoodieTable.getHadoopConf(), config.getParquetCompressionRatio(), config.parquetDictionaryEnabled());
        return new HoodieParquetWriter(instantTime, path, parquetConfig, schema2, taskContextSupplier, populateMetaFields);
    }

    private static <T extends HoodieRecordPayload, R extends IndexedRecord> HoodieFileWriter<R> newHFileFileWriter(String instantTime, Path path, HoodieWriteConfig config, Schema schema2, HoodieTable hoodieTable, TaskContextSupplier taskContextSupplier) throws IOException {
        BloomFilter filter = HoodieFileWriterFactory.createBloomFilter(config);
        HoodieHFileConfig hfileConfig = new HoodieHFileConfig(hoodieTable.getHadoopConf(), config.getHFileCompressionAlgorithm(), config.getHFileBlockSize(), config.getHFileMaxFileSize(), false, false, true, filter, HoodieHFileConfig.HFILE_COMPARATOR);
        return new HoodieHFileWriter(instantTime, path, hfileConfig, schema2, taskContextSupplier, config.populateMetaFields());
    }

    private static <T extends HoodieRecordPayload, R extends IndexedRecord> HoodieFileWriter<R> newOrcFileWriter(String instantTime, Path path, HoodieWriteConfig config, Schema schema2, HoodieTable hoodieTable, TaskContextSupplier taskContextSupplier) throws IOException {
        BloomFilter filter = HoodieFileWriterFactory.createBloomFilter(config);
        HoodieOrcConfig orcConfig = new HoodieOrcConfig(hoodieTable.getHadoopConf(), config.getOrcCompressionCodec(), config.getOrcStripeSize(), config.getOrcBlockSize(), config.getOrcMaxFileSize(), filter);
        return new HoodieOrcWriter(instantTime, path, orcConfig, schema2, taskContextSupplier);
    }

    private static BloomFilter createBloomFilter(HoodieWriteConfig config) {
        return BloomFilterFactory.createBloomFilter(config.getBloomFilterNumEntries(), config.getBloomFilterFPP(), config.getDynamicBloomFilterMaxNumEntries(), config.getBloomFilterType());
    }
}

