/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage.row;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.fs.HoodieWrapperFileSystem;
import org.apache.hudi.io.storage.row.HoodieInternalRowFileWriter;
import org.apache.hudi.io.storage.row.HoodieRowParquetConfig;
import org.apache.hudi.io.storage.row.HoodieRowParquetWriteSupport;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.spark.sql.catalyst.InternalRow;

public class HoodieInternalRowParquetWriter
extends ParquetWriter<InternalRow>
implements HoodieInternalRowFileWriter {
    private final Path file;
    private final HoodieWrapperFileSystem fs;
    private final long maxFileSize;
    private final HoodieRowParquetWriteSupport writeSupport;

    public HoodieInternalRowParquetWriter(Path file, HoodieRowParquetConfig parquetConfig) throws IOException {
        super(HoodieWrapperFileSystem.convertToHoodiePath(file, parquetConfig.getHadoopConf()), ParquetFileWriter.Mode.CREATE, (WriteSupport)parquetConfig.getWriteSupport(), parquetConfig.getCompressionCodecName(), parquetConfig.getBlockSize(), parquetConfig.getPageSize(), parquetConfig.getPageSize(), true, false, DEFAULT_WRITER_VERSION, FSUtils.registerFileSystem(file, parquetConfig.getHadoopConf()));
        this.file = HoodieWrapperFileSystem.convertToHoodiePath(file, parquetConfig.getHadoopConf());
        this.fs = (HoodieWrapperFileSystem)this.file.getFileSystem(FSUtils.registerFileSystem(file, parquetConfig.getHadoopConf()));
        this.maxFileSize = parquetConfig.getMaxFileSize() + Math.round((double)parquetConfig.getMaxFileSize() * parquetConfig.getCompressionRatio());
        this.writeSupport = (HoodieRowParquetWriteSupport)((Object)parquetConfig.getWriteSupport());
    }

    @Override
    public boolean canWrite() {
        return this.fs.getBytesWritten(this.file) < this.maxFileSize;
    }

    @Override
    public void writeRow(String key, InternalRow row) throws IOException {
        super.write((Object)row);
        this.writeSupport.add(key);
    }

    @Override
    public void writeRow(InternalRow row) throws IOException {
        super.write((Object)row);
    }

    @Override
    public void close() throws IOException {
        super.close();
    }
}

