/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieInstantInfo;
import org.apache.hudi.avro.model.HoodieMetadataRecord;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.client.AbstractHoodieWriteClient;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.ConsistencyGuardConfig;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieDeleteBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.config.metrics.HoodieMetricsGraphiteConfig;
import org.apache.hudi.config.metrics.HoodieMetricsJmxConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.metadata.HoodieBackedTableMetadata;
import org.apache.hudi.metadata.HoodieMetadataMetrics;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataKeyGenerator;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class HoodieBackedTableMetadataWriter
implements HoodieTableMetadataWriter {
    private static final Logger LOG = LogManager.getLogger(HoodieBackedTableMetadataWriter.class);
    private static final String RECORD_KEY_FIELD = "key";
    protected HoodieWriteConfig metadataWriteConfig;
    protected HoodieWriteConfig dataWriteConfig;
    protected String tableName;
    protected HoodieBackedTableMetadata metadata;
    protected HoodieTableMetaClient metadataMetaClient;
    protected HoodieTableMetaClient dataMetaClient;
    protected Option<HoodieMetadataMetrics> metrics;
    protected boolean enabled;
    protected SerializableConfiguration hadoopConf;
    protected final transient HoodieEngineContext engineContext;

    protected <T extends SpecificRecordBase> HoodieBackedTableMetadataWriter(Configuration hadoopConf, HoodieWriteConfig writeConfig, HoodieEngineContext engineContext, Option<T> actionMetadata, Option<String> inflightInstantTimestamp) {
        this.dataWriteConfig = writeConfig;
        this.engineContext = engineContext;
        this.hadoopConf = new SerializableConfiguration(hadoopConf);
        if (writeConfig.isMetadataTableEnabled()) {
            this.tableName = writeConfig.getTableName() + "_metadata";
            this.metadataWriteConfig = this.createMetadataWriteConfig(writeConfig);
            this.enabled = true;
            ValidationUtils.checkArgument(!this.metadataWriteConfig.isAutoClean(), "Cleaning is controlled internally for Metadata table.");
            ValidationUtils.checkArgument(!this.metadataWriteConfig.inlineCompactionEnabled(), "Compaction is controlled internally for metadata table.");
            ValidationUtils.checkArgument(this.metadataWriteConfig.shouldAutoCommit(), "Auto commit is required for Metadata Table");
            ValidationUtils.checkArgument(!this.metadataWriteConfig.isMetadataTableEnabled(), "File listing cannot be used for Metadata Table");
            this.initRegistry();
            this.dataMetaClient = HoodieTableMetaClient.builder().setConf(hadoopConf).setBasePath(this.dataWriteConfig.getBasePath()).build();
            this.initialize(engineContext, actionMetadata, inflightInstantTimestamp);
            this.initTableMetadata();
        } else {
            this.enabled = false;
            this.metrics = Option.empty();
        }
    }

    public HoodieBackedTableMetadataWriter(Configuration hadoopConf, HoodieWriteConfig writeConfig, HoodieEngineContext engineContext) {
        this(hadoopConf, writeConfig, engineContext, Option.empty(), Option.empty());
    }

    protected abstract void initRegistry();

    private HoodieWriteConfig createMetadataWriteConfig(HoodieWriteConfig writeConfig) {
        int parallelism = writeConfig.getMetadataInsertParallelism();
        int minCommitsToKeep = Math.max(writeConfig.getMetadataMinCommitsToKeep(), writeConfig.getMinCommitsToKeep());
        int maxCommitsToKeep = Math.max(writeConfig.getMetadataMaxCommitsToKeep(), writeConfig.getMaxCommitsToKeep());
        HoodieWriteConfig.Builder builder = HoodieWriteConfig.newBuilder().withTimelineLayoutVersion(TimelineLayoutVersion.CURR_VERSION).withConsistencyGuardConfig(ConsistencyGuardConfig.newBuilder().withConsistencyCheckEnabled(writeConfig.getConsistencyGuardConfig().isConsistencyCheckEnabled()).withInitialConsistencyCheckIntervalMs(writeConfig.getConsistencyGuardConfig().getInitialConsistencyCheckIntervalMs()).withMaxConsistencyCheckIntervalMs(writeConfig.getConsistencyGuardConfig().getMaxConsistencyCheckIntervalMs()).withMaxConsistencyChecks(writeConfig.getConsistencyGuardConfig().getMaxConsistencyChecks()).build()).withWriteConcurrencyMode(WriteConcurrencyMode.SINGLE_WRITER).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(false).withFileListingParallelism(writeConfig.getFileListingParallelism()).build()).withAutoCommit(true).withAvroSchemaValidate(true).withEmbeddedTimelineServerEnabled(false).withMarkersType(MarkerType.DIRECT.name()).withRollbackUsingMarkers(false).withPath(HoodieTableMetadata.getMetadataTableBasePath(writeConfig.getBasePath())).withSchema(HoodieMetadataRecord.getClassSchema().toString()).forTable(this.tableName).withCompactionConfig(HoodieCompactionConfig.newBuilder().withAsyncClean(writeConfig.isMetadataAsyncClean()).withAutoClean(false).withCleanerParallelism(parallelism).withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS).withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.LAZY).retainCommits(writeConfig.getMetadataCleanerCommitsRetained()).archiveCommitsWith(minCommitsToKeep, maxCommitsToKeep).withInlineCompaction(false).withMaxNumDeltaCommitsBeforeCompaction(writeConfig.getMetadataCompactDeltaCommitMax()).withAutoArchive(false).build()).withParallelism(parallelism, parallelism).withDeleteParallelism(parallelism).withRollbackParallelism(parallelism).withFinalizeWriteParallelism(parallelism).withAllowMultiWriteOnSameInstant(true).withKeyGenerator(HoodieTableMetadataKeyGenerator.class.getCanonicalName()).withPopulateMetaFields(this.dataWriteConfig.getMetadataConfig().populateMetaFields());
        Properties properties = new Properties();
        properties.put(HoodieTableConfig.RECORDKEY_FIELDS.key(), RECORD_KEY_FIELD);
        properties.put("hoodie.datasource.write.recordkey.field", RECORD_KEY_FIELD);
        builder.withProperties(properties);
        if (writeConfig.isMetricsOn()) {
            builder.withMetricsConfig(HoodieMetricsConfig.newBuilder().withReporterType(writeConfig.getMetricsReporterType().toString()).withExecutorMetrics(writeConfig.isExecutorMetricsEnabled()).on(true).build());
            switch (writeConfig.getMetricsReporterType()) {
                case GRAPHITE: {
                    builder.withMetricsGraphiteConfig(HoodieMetricsGraphiteConfig.newBuilder().onGraphitePort(writeConfig.getGraphiteServerPort()).toGraphiteHost(writeConfig.getGraphiteServerHost()).usePrefix(writeConfig.getGraphiteMetricPrefix()).build());
                    break;
                }
                case JMX: {
                    builder.withMetricsJmxConfig(HoodieMetricsJmxConfig.newBuilder().onJmxPort(writeConfig.getJmxPort()).toJmxHost(writeConfig.getJmxHost()).build());
                    break;
                }
                case DATADOG: 
                case PROMETHEUS: 
                case PROMETHEUS_PUSHGATEWAY: 
                case CONSOLE: 
                case INMEMORY: 
                case CLOUDWATCH: {
                    break;
                }
                default: {
                    throw new HoodieMetadataException("Unsupported Metrics Reporter type " + (Object)((Object)writeConfig.getMetricsReporterType()));
                }
            }
        }
        return builder.build();
    }

    public HoodieWriteConfig getWriteConfig() {
        return this.metadataWriteConfig;
    }

    public HoodieBackedTableMetadata metadata() {
        return this.metadata;
    }

    protected abstract <T extends SpecificRecordBase> void initialize(HoodieEngineContext var1, Option<T> var2, Option<String> var3);

    public void initTableMetadata() {
        try {
            if (this.metadata != null) {
                this.metadata.close();
            }
            this.metadata = new HoodieBackedTableMetadata(this.engineContext, this.dataWriteConfig.getMetadataConfig(), this.dataWriteConfig.getBasePath(), this.dataWriteConfig.getSpillableMapBasePath());
            this.metadataMetaClient = this.metadata.getMetadataMetaClient();
        }
        catch (Exception e) {
            throw new HoodieException("Error initializing metadata table for reads", e);
        }
    }

    protected <T extends SpecificRecordBase> void bootstrapIfNeeded(HoodieEngineContext engineContext, HoodieTableMetaClient dataMetaClient, Option<T> actionMetadata, Option<String> inflightInstantTimestamp) throws IOException {
        HoodieTimer timer = new HoodieTimer().startTimer();
        boolean exists = dataMetaClient.getFs().exists(new Path(this.metadataWriteConfig.getBasePath(), ".hoodie"));
        boolean rebootstrap = false;
        if (exists) {
            HoodieTableMetaClient metadataMetaClient = HoodieTableMetaClient.builder().setConf(this.hadoopConf.get()).setBasePath(this.metadataWriteConfig.getBasePath()).build();
            Option<HoodieInstant> latestMetadataInstant = metadataMetaClient.getActiveTimeline().filterCompletedInstants().lastInstant();
            rebootstrap = this.isBootstrapNeeded(latestMetadataInstant, actionMetadata);
        }
        if (rebootstrap) {
            this.metrics.ifPresent(m -> m.updateMetrics("rebootstrap", 1L));
            LOG.info((Object)"Deleting Metadata Table directory so that it can be re-bootstrapped");
            dataMetaClient.getFs().delete(new Path(this.metadataWriteConfig.getBasePath()), true);
            exists = false;
        }
        if (!exists && this.bootstrapFromFilesystem(engineContext, dataMetaClient, inflightInstantTimestamp)) {
            this.metrics.ifPresent(m -> m.updateMetrics("initialize", timer.endTimer()));
        }
    }

    private <T extends SpecificRecordBase> boolean isBootstrapNeeded(Option<HoodieInstant> latestMetadataInstant, Option<T> actionMetadata) {
        if (!latestMetadataInstant.isPresent()) {
            LOG.warn((Object)"Metadata Table will need to be re-bootstrapped as no instants were found");
            return true;
        }
        String latestMetadataInstantTimestamp = latestMetadataInstant.get().getTimestamp();
        if (latestMetadataInstantTimestamp.equals("00000000000000")) {
            return false;
        }
        if (this.dataMetaClient.getActiveTimeline().getAllCommitsTimeline().isBeforeTimelineStarts(latestMetadataInstant.get().getTimestamp()) && !this.isCommitRevertedByInFlightAction(actionMetadata, latestMetadataInstantTimestamp)) {
            LOG.error((Object)("Metadata Table will need to be re-bootstrapped as un-synced instants have been archived. latestMetadataInstant=" + latestMetadataInstant.get().getTimestamp() + ", latestDataInstant=" + this.dataMetaClient.getActiveTimeline().firstInstant().get().getTimestamp()));
            return true;
        }
        return false;
    }

    private <T extends SpecificRecordBase> boolean isCommitRevertedByInFlightAction(Option<T> actionMetadata, String latestMetadataInstantTimestamp) {
        String INSTANT_ACTION;
        if (!actionMetadata.isPresent()) {
            return false;
        }
        switch (INSTANT_ACTION = actionMetadata.get() instanceof HoodieRollbackMetadata ? "rollback" : (actionMetadata.get() instanceof HoodieRestoreMetadata ? "restore" : "")) {
            case "rollback": {
                List<HoodieInstantInfo> rollbackedInstants = ((HoodieRollbackMetadata)((Object)actionMetadata.get())).getInstantsRollback();
                List affectedInstantTimestamps = rollbackedInstants.stream().map(instant -> instant.getCommitTime().toString()).collect(Collectors.toList());
                if (!affectedInstantTimestamps.contains(latestMetadataInstantTimestamp)) break;
                return true;
            }
            case "restore": {
                List<HoodieInstantInfo> restoredInstants = ((HoodieRestoreMetadata)((Object)actionMetadata.get())).getRestoreInstantInfo();
                List affectedInstantTimestamps = restoredInstants.stream().map(instant -> instant.getCommitTime().toString()).collect(Collectors.toList());
                if (!affectedInstantTimestamps.contains(latestMetadataInstantTimestamp)) break;
                return true;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    private boolean bootstrapFromFilesystem(HoodieEngineContext engineContext, HoodieTableMetaClient dataMetaClient, Option<String> inflightInstantTimestamp) throws IOException {
        ValidationUtils.checkState(this.enabled, "Metadata table cannot be initialized as it is not enabled");
        List pendingDataInstant = dataMetaClient.getActiveTimeline().getInstants().filter(i -> !i.isCompleted()).filter(i -> !inflightInstantTimestamp.isPresent() || !i.getTimestamp().equals(inflightInstantTimestamp.get())).collect(Collectors.toList());
        if (!pendingDataInstant.isEmpty()) {
            this.metrics.ifPresent(m -> m.updateMetrics("bootstrap_error", 1L));
            LOG.warn((Object)("Cannot bootstrap metadata table as operation(s) are in progress on the dataset: " + Arrays.toString(pendingDataInstant.toArray())));
            return false;
        }
        String createInstantTime = dataMetaClient.getActiveTimeline().filterCompletedInstants().getReverseOrderedInstants().findFirst().map(HoodieInstant::getTimestamp).orElse("00000000000000");
        LOG.info((Object)("Creating a new metadata table in " + this.metadataWriteConfig.getBasePath() + " at instant " + createInstantTime));
        HoodieTableMetaClient.withPropertyBuilder().setTableType(HoodieTableType.MERGE_ON_READ).setTableName(this.tableName).setArchiveLogFolder(HoodieTableConfig.ARCHIVELOG_FOLDER.defaultValue()).setPayloadClassName(HoodieMetadataPayload.class.getName()).setBaseFileFormat(HoodieFileFormat.HFILE.toString()).setRecordKeyFields(RECORD_KEY_FIELD).setPopulateMetaFields(this.dataWriteConfig.getMetadataConfig().populateMetaFields()).setKeyGeneratorClassProp(HoodieTableMetadataKeyGenerator.class.getCanonicalName()).initTable(this.hadoopConf.get(), this.metadataWriteConfig.getBasePath());
        this.initTableMetadata();
        this.initializeFileGroups(dataMetaClient, MetadataPartitionType.FILES, createInstantTime, 1);
        LOG.info((Object)("Initializing metadata table by using file listings in " + this.dataWriteConfig.getBasePath()));
        List<DirectoryInfo> dirInfoList = this.listAllPartitions(dataMetaClient);
        this.bootstrapCommit(dirInfoList, createInstantTime);
        return true;
    }

    private List<DirectoryInfo> listAllPartitions(HoodieTableMetaClient datasetMetaClient) {
        LinkedList<Path> pathsToList = new LinkedList<Path>();
        pathsToList.add(new Path(this.dataWriteConfig.getBasePath()));
        LinkedList<DirectoryInfo> partitionsToBootstrap = new LinkedList<DirectoryInfo>();
        int fileListingParallelism = this.metadataWriteConfig.getFileListingParallelism();
        SerializableConfiguration conf = new SerializableConfiguration(datasetMetaClient.getHadoopConf());
        String dirFilterRegex = this.dataWriteConfig.getMetadataConfig().getDirectoryFilterRegex();
        String datasetBasePath = datasetMetaClient.getBasePath();
        while (!pathsToList.isEmpty()) {
            int numDirsToList = Math.min(fileListingParallelism, pathsToList.size());
            List<DirectoryInfo> processedDirectories = this.engineContext.map(pathsToList.subList(0, numDirsToList), path -> {
                FileSystem fs = path.getFileSystem(conf.get());
                String relativeDirPath = FSUtils.getRelativePartitionPath(new Path(datasetBasePath), path);
                return new DirectoryInfo(relativeDirPath, fs.listStatus(path));
            }, numDirsToList);
            pathsToList = new LinkedList(pathsToList.subList(numDirsToList, pathsToList.size()));
            for (DirectoryInfo dirInfo : processedDirectories) {
                Path partitionPath;
                String relativePath;
                if (!dirFilterRegex.isEmpty() && !(relativePath = dirInfo.getRelativePath()).isEmpty() && (partitionPath = new Path(datasetBasePath, relativePath)).getName().matches(dirFilterRegex)) {
                    LOG.info((Object)("Ignoring directory " + partitionPath + " which matches the filter regex " + dirFilterRegex));
                    continue;
                }
                if (dirInfo.isHoodiePartition()) {
                    partitionsToBootstrap.add(dirInfo);
                    continue;
                }
                pathsToList.addAll(dirInfo.getSubDirectories());
            }
        }
        return partitionsToBootstrap;
    }

    private void initializeFileGroups(HoodieTableMetaClient dataMetaClient, MetadataPartitionType metadataPartition, String instantTime, int fileGroupCount) throws IOException {
        HashMap<HoodieLogBlock.HeaderMetadataType, String> blockHeader = new HashMap<HoodieLogBlock.HeaderMetadataType, String>();
        blockHeader.put(HoodieLogBlock.HeaderMetadataType.INSTANT_TIME, instantTime);
        HoodieDeleteBlock block = new HoodieDeleteBlock(new HoodieKey[0], blockHeader);
        LOG.info((Object)String.format("Creating %d file groups for partition %s with base fileId %s at instant time %s", fileGroupCount, metadataPartition.partitionPath(), metadataPartition.getFileIdPrefix(), instantTime));
        for (int i = 0; i < fileGroupCount; ++i) {
            String fileGroupFileId = String.format("%s%04d", metadataPartition.getFileIdPrefix(), i);
            try {
                HoodieLogFormat.Writer writer = HoodieLogFormat.newWriterBuilder().onParentPath(FSUtils.getPartitionPath(this.metadataWriteConfig.getBasePath(), metadataPartition.partitionPath())).withFileId(fileGroupFileId).overBaseCommit(instantTime).withLogVersion(HoodieLogFile.LOGFILE_BASE_VERSION).withFileSize(0L).withSizeThreshold(this.metadataWriteConfig.getLogFileMaxSize()).withFs(dataMetaClient.getFs()).withRolloverLogWriteToken("0-0-0").withLogWriteToken("0-0-0").withFileExtension(".log").build();
                writer.appendBlock(block);
                writer.close();
                continue;
            }
            catch (InterruptedException e) {
                throw new HoodieException("Failed to created fileGroup " + fileGroupFileId + " for partition " + metadataPartition.partitionPath(), e);
            }
        }
    }

    private <T> void processAndCommit(String instantTime, ConvertMetadataFunction convertMetadataFunction, boolean canTriggerTableService) {
        if (this.enabled && this.metadata != null) {
            List<HoodieRecord> records = convertMetadataFunction.convertMetadata();
            this.commit(this.engineContext.parallelize(records, 1), MetadataPartitionType.FILES.partitionPath(), instantTime, canTriggerTableService);
        }
    }

    @Override
    public void update(HoodieCommitMetadata commitMetadata, String instantTime, boolean isTableServiceAction) {
        this.processAndCommit(instantTime, () -> HoodieTableMetadataUtil.convertMetadataToRecords(commitMetadata, instantTime), !isTableServiceAction);
    }

    @Override
    public void update(HoodieCleanMetadata cleanMetadata, String instantTime) {
        this.processAndCommit(instantTime, () -> HoodieTableMetadataUtil.convertMetadataToRecords(cleanMetadata, instantTime), false);
    }

    @Override
    public void update(HoodieRestoreMetadata restoreMetadata, String instantTime) {
        this.processAndCommit(instantTime, () -> HoodieTableMetadataUtil.convertMetadataToRecords(this.metadataMetaClient.getActiveTimeline(), restoreMetadata, instantTime, this.metadata.getSyncedInstantTime()), false);
    }

    @Override
    public void update(HoodieRollbackMetadata rollbackMetadata, String instantTime) {
        if (this.enabled && this.metadata != null) {
            Option<String> latestCompaction;
            String rollbackInstant = rollbackMetadata.getCommitsRollback().get(0);
            boolean wasSynced = this.metadataMetaClient.getActiveTimeline().containsInstant(new HoodieInstant(false, "deltacommit", rollbackInstant));
            if (!wasSynced && (latestCompaction = this.metadata.getLatestCompactionTime()).isPresent()) {
                wasSynced = HoodieTimeline.compareTimestamps(rollbackInstant, HoodieTimeline.LESSER_THAN_OR_EQUALS, latestCompaction.get());
            }
            List<HoodieRecord> records = HoodieTableMetadataUtil.convertMetadataToRecords(this.metadataMetaClient.getActiveTimeline(), rollbackMetadata, instantTime, this.metadata.getSyncedInstantTime(), wasSynced);
            this.commit(this.engineContext.parallelize(records, 1), MetadataPartitionType.FILES.partitionPath(), instantTime, false);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.metadata != null) {
            this.metadata.close();
        }
    }

    protected abstract void commit(HoodieData<HoodieRecord> var1, String var2, String var3, boolean var4);

    protected void compactIfNecessary(AbstractHoodieWriteClient writeClient, String instantTime) {
        writeClient.runAnyPendingCompactions();
        String latestDeltacommitTime = this.metadataMetaClient.reloadActiveTimeline().getDeltaCommitTimeline().filterCompletedInstants().lastInstant().get().getTimestamp();
        List pendingInstants = this.dataMetaClient.reloadActiveTimeline().filterInflightsAndRequested().findInstantsBefore(latestDeltacommitTime).getInstants().collect(Collectors.toList());
        if (!pendingInstants.isEmpty()) {
            LOG.info((Object)String.format("Cannot compact metadata table as there are %d inflight instants before latest deltacommit %s: %s", pendingInstants.size(), latestDeltacommitTime, Arrays.toString(pendingInstants.toArray())));
            return;
        }
        String compactionInstantTime = latestDeltacommitTime + "001";
        if (writeClient.scheduleCompactionAtInstant(compactionInstantTime, Option.empty())) {
            writeClient.compact(compactionInstantTime);
        }
    }

    protected void doClean(AbstractHoodieWriteClient writeClient, String instantTime) {
        writeClient.clean(instantTime + "002");
    }

    protected void bootstrapCommit(List<DirectoryInfo> partitionInfoList, String createInstantTime) {
        List<String> partitions = partitionInfoList.stream().map(p -> p.getRelativePath().isEmpty() ? "." : p.getRelativePath()).collect(Collectors.toList());
        int totalFiles = partitionInfoList.stream().mapToInt(p -> p.getTotalFiles()).sum();
        HoodieRecord<HoodieMetadataPayload> allPartitionRecord = HoodieMetadataPayload.createPartitionListRecord(partitions);
        if (partitions.isEmpty()) {
            this.commit(this.engineContext.parallelize(Collections.singletonList(allPartitionRecord), 1), MetadataPartitionType.FILES.partitionPath(), createInstantTime, false);
            return;
        }
        HoodieData<HoodieRecord> partitionRecords = this.engineContext.parallelize(Arrays.asList(allPartitionRecord), 1);
        if (!partitionInfoList.isEmpty()) {
            HoodieData<HoodieRecord> fileListRecords = this.engineContext.parallelize(partitionInfoList, partitionInfoList.size()).map(partitionInfo -> HoodieMetadataPayload.createPartitionFilesRecord(partitionInfo.getRelativePath().isEmpty() ? "." : partitionInfo.getRelativePath(), Option.of(partitionInfo.getFileNameToSizeMap()), Option.empty()));
            partitionRecords = partitionRecords.union(fileListRecords);
        }
        LOG.info((Object)("Committing " + partitions.size() + " partitions and " + totalFiles + " files to metadata"));
        ValidationUtils.checkState(partitionRecords.count() == (long)(partitions.size() + 1));
        this.commit(partitionRecords, MetadataPartitionType.FILES.partitionPath(), createInstantTime, false);
    }

    static class DirectoryInfo
    implements Serializable {
        private final String relativePath;
        private HashMap<String, Long> filenameToSizeMap;
        private final List<Path> subDirectories = new ArrayList<Path>();
        private boolean isHoodiePartition = false;

        public DirectoryInfo(String relativePath, FileStatus[] fileStatus) {
            this.relativePath = relativePath;
            this.filenameToSizeMap = new HashMap(fileStatus.length);
            for (FileStatus status : fileStatus) {
                if (status.isDirectory()) {
                    if (status.getPath().getName().equals(".hoodie")) continue;
                    this.subDirectories.add(status.getPath());
                    continue;
                }
                if (status.getPath().getName().equals(".hoodie_partition_metadata")) {
                    this.isHoodiePartition = true;
                    continue;
                }
                if (!FSUtils.isDataFile(status.getPath())) continue;
                this.filenameToSizeMap.put(status.getPath().getName(), status.getLen());
            }
        }

        String getRelativePath() {
            return this.relativePath;
        }

        int getTotalFiles() {
            return this.filenameToSizeMap.size();
        }

        boolean isHoodiePartition() {
            return this.isHoodiePartition;
        }

        List<Path> getSubDirectories() {
            return this.subDirectories;
        }

        Map<String, Long> getFileNameToSizeMap() {
            return this.filenameToSizeMap;
        }
    }

    private static interface ConvertMetadataFunction {
        public List<HoodieRecord> convertMetadata();
    }
}

