/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.jetty.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hudi.org.apache.jetty.client.AbstractConnectionPool;
import org.apache.hudi.org.apache.jetty.client.ConnectionPool;
import org.apache.hudi.org.apache.jetty.client.api.Connection;
import org.apache.hudi.org.apache.jetty.client.api.Destination;
import org.apache.hudi.org.apache.jetty.util.Callback;
import org.apache.hudi.org.apache.jetty.util.annotation.ManagedObject;
import org.apache.hudi.org.apache.jetty.util.component.Dumpable;

@ManagedObject
public class RoundRobinConnectionPool
extends AbstractConnectionPool
implements ConnectionPool.Multiplexable {
    private final List<Entry> entries;
    private int maxMultiplex;
    private int index;

    public RoundRobinConnectionPool(Destination destination, int maxConnections, Callback requester) {
        this(destination, maxConnections, requester, 1);
    }

    public RoundRobinConnectionPool(Destination destination, int maxConnections, Callback requester, int maxMultiplex) {
        super(destination, maxConnections, requester);
        this.entries = new ArrayList<Entry>(maxConnections);
        for (int i = 0; i < maxConnections; ++i) {
            this.entries.add(new Entry());
        }
        this.maxMultiplex = maxMultiplex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxMultiplex() {
        RoundRobinConnectionPool roundRobinConnectionPool = this;
        synchronized (roundRobinConnectionPool) {
            return this.maxMultiplex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxMultiplex(int maxMultiplex) {
        RoundRobinConnectionPool roundRobinConnectionPool = this;
        synchronized (roundRobinConnectionPool) {
            this.maxMultiplex = maxMultiplex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onCreated(Connection connection) {
        RoundRobinConnectionPool roundRobinConnectionPool = this;
        synchronized (roundRobinConnectionPool) {
            for (Entry entry : this.entries) {
                if (entry.connection != null) continue;
                entry.connection = connection;
                break;
            }
        }
        this.idle(connection, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Connection activate() {
        Connection connection = null;
        RoundRobinConnectionPool roundRobinConnectionPool = this;
        synchronized (roundRobinConnectionPool) {
            int capacity = this.getMaxConnectionCount();
            for (int offset = 0; offset < capacity; ++offset) {
                Entry entry;
                int idx = this.index + offset;
                if (idx >= capacity) {
                    idx -= capacity;
                }
                if ((entry = this.entries.get(idx)).connection == null) break;
                if (entry.active >= this.getMaxMultiplex()) continue;
                ++entry.active;
                ++entry.used;
                connection = entry.connection;
                this.index += offset + 1;
                if (this.index < capacity) break;
                this.index -= capacity;
                break;
            }
        }
        return connection == null ? null : this.active(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive(Connection connection) {
        RoundRobinConnectionPool roundRobinConnectionPool = this;
        synchronized (roundRobinConnectionPool) {
            for (Entry entry : this.entries) {
                if (entry.connection != connection) continue;
                return entry.active > 0;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean release(Connection connection) {
        boolean found = false;
        boolean idle = false;
        RoundRobinConnectionPool roundRobinConnectionPool = this;
        synchronized (roundRobinConnectionPool) {
            for (Entry entry : this.entries) {
                if (entry.connection != connection) continue;
                found = true;
                int active = --entry.active;
                idle = active == 0;
                break;
            }
        }
        if (!found) {
            return false;
        }
        this.released(connection);
        if (idle) {
            return this.idle(connection, this.isClosed());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Connection connection) {
        boolean found = false;
        RoundRobinConnectionPool roundRobinConnectionPool = this;
        synchronized (roundRobinConnectionPool) {
            for (Entry entry : this.entries) {
                if (entry.connection != connection) continue;
                found = true;
                entry.reset();
                break;
            }
        }
        if (found) {
            this.released(connection);
            this.removed(connection);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(Appendable out, String indent) throws IOException {
        ArrayList<Entry> connections;
        RoundRobinConnectionPool roundRobinConnectionPool = this;
        synchronized (roundRobinConnectionPool) {
            connections = new ArrayList<Entry>(this.entries);
        }
        Dumpable.dumpObjects(out, indent, out, connections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int present = 0;
        int active = 0;
        RoundRobinConnectionPool roundRobinConnectionPool = this;
        synchronized (roundRobinConnectionPool) {
            for (Entry entry : this.entries) {
                if (entry.connection == null) continue;
                ++present;
                if (entry.active <= 0) continue;
                ++active;
            }
        }
        return String.format("%s@%x[c=%d/%d,a=%d]", this.getClass().getSimpleName(), this.hashCode(), present, this.getMaxConnectionCount(), active);
    }

    private static class Entry {
        private Connection connection;
        private int active;
        private long used;

        private Entry() {
        }

        private void reset() {
            this.connection = null;
            this.active = 0;
            this.used = 0L;
        }

        public String toString() {
            return String.format("{u=%d,c=%s}", this.used, this.connection);
        }
    }
}

