/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.jetty.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import org.apache.hudi.org.apache.jetty.io.AbstractEndPoint;
import org.apache.hudi.org.apache.jetty.io.EofException;
import org.apache.hudi.org.apache.jetty.io.ManagedSelector;
import org.apache.hudi.org.apache.jetty.util.BufferUtil;
import org.apache.hudi.org.apache.jetty.util.log.Log;
import org.apache.hudi.org.apache.jetty.util.log.Logger;
import org.apache.hudi.org.apache.jetty.util.thread.Invocable;
import org.apache.hudi.org.apache.jetty.util.thread.Scheduler;

public abstract class ChannelEndPoint
extends AbstractEndPoint
implements ManagedSelector.Selectable {
    private static final Logger LOG = Log.getLogger(ChannelEndPoint.class);
    private final ByteChannel _channel;
    private final GatheringByteChannel _gather;
    protected final ManagedSelector _selector;
    protected final SelectionKey _key;
    private boolean _updatePending;
    protected int _currentInterestOps;
    protected int _desiredInterestOps;
    private final ManagedSelector.SelectorUpdate _updateKeyAction = new ManagedSelector.SelectorUpdate(){

        @Override
        public void update(Selector selector) {
            ChannelEndPoint.this.updateKey();
        }
    };
    private final Runnable _runFillable = new RunnableCloseable("runFillable"){

        @Override
        public Invocable.InvocationType getInvocationType() {
            return ChannelEndPoint.this.getFillInterest().getCallbackInvocationType();
        }

        @Override
        public void run() {
            ChannelEndPoint.this.getFillInterest().fillable();
        }
    };
    private final Runnable _runCompleteWrite = new RunnableCloseable("runCompleteWrite"){

        @Override
        public Invocable.InvocationType getInvocationType() {
            return ChannelEndPoint.this.getWriteFlusher().getCallbackInvocationType();
        }

        @Override
        public void run() {
            ChannelEndPoint.this.getWriteFlusher().completeWrite();
        }

        @Override
        public String toString() {
            return String.format("CEP:%s:%s:%s->%s", new Object[]{ChannelEndPoint.this, this._operation, this.getInvocationType(), ChannelEndPoint.this.getWriteFlusher()});
        }
    };
    private final Runnable _runCompleteWriteFillable = new RunnableCloseable("runCompleteWriteFillable"){

        @Override
        public Invocable.InvocationType getInvocationType() {
            Invocable.InvocationType flushT;
            Invocable.InvocationType fillT = ChannelEndPoint.this.getFillInterest().getCallbackInvocationType();
            if (fillT == (flushT = ChannelEndPoint.this.getWriteFlusher().getCallbackInvocationType())) {
                return fillT;
            }
            if (fillT == Invocable.InvocationType.EITHER && flushT == Invocable.InvocationType.NON_BLOCKING) {
                return Invocable.InvocationType.EITHER;
            }
            if (fillT == Invocable.InvocationType.NON_BLOCKING && flushT == Invocable.InvocationType.EITHER) {
                return Invocable.InvocationType.EITHER;
            }
            return Invocable.InvocationType.BLOCKING;
        }

        @Override
        public void run() {
            ChannelEndPoint.this.getWriteFlusher().completeWrite();
            ChannelEndPoint.this.getFillInterest().fillable();
        }
    };

    public ChannelEndPoint(ByteChannel channel, ManagedSelector selector, SelectionKey key, Scheduler scheduler) {
        super(scheduler);
        this._channel = channel;
        this._selector = selector;
        this._key = key;
        this._gather = channel instanceof GatheringByteChannel ? (GatheringByteChannel)((Object)channel) : null;
    }

    @Override
    public boolean isOptimizedForDirectBuffers() {
        return true;
    }

    @Override
    public boolean isOpen() {
        return this._channel.isOpen();
    }

    @Override
    public void doClose() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("doClose {}", this);
        }
        try {
            this._channel.close();
        }
        catch (IOException e) {
            LOG.debug(e);
        }
        finally {
            super.doClose();
        }
    }

    @Override
    public void onClose() {
        try {
            super.onClose();
        }
        finally {
            if (this._selector != null) {
                this._selector.destroyEndPoint(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int fill(ByteBuffer buffer) throws IOException {
        int filled;
        if (this.isInputShutdown()) {
            return -1;
        }
        int pos = BufferUtil.flipToFill(buffer);
        try {
            filled = this._channel.read(buffer);
            if (filled > 0) {
                this.notIdle();
            } else if (filled == -1) {
                this.shutdownInput();
            }
        }
        catch (IOException e) {
            LOG.debug(e);
            this.shutdownInput();
            filled = -1;
        }
        finally {
            BufferUtil.flipToFlush(buffer, pos);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("filled {} {}", filled, BufferUtil.toDetailString(buffer));
        }
        return filled;
    }

    @Override
    public boolean flush(ByteBuffer ... buffers) throws IOException {
        long flushed = 0L;
        try {
            if (buffers.length == 1) {
                flushed = this._channel.write(buffers[0]);
            } else if (this._gather != null && buffers.length > 1) {
                flushed = this._gather.write(buffers, 0, buffers.length);
            } else {
                for (ByteBuffer b : buffers) {
                    if (!b.hasRemaining()) continue;
                    int l = this._channel.write(b);
                    if (l > 0) {
                        flushed += (long)l;
                    }
                    if (b.hasRemaining()) break;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("flushed {} {}", flushed, this);
            }
        }
        catch (IOException e) {
            throw new EofException(e);
        }
        if (flushed > 0L) {
            this.notIdle();
        }
        for (ByteBuffer b : buffers) {
            if (BufferUtil.isEmpty(b)) continue;
            return false;
        }
        return true;
    }

    public ByteChannel getChannel() {
        return this._channel;
    }

    @Override
    public Object getTransport() {
        return this._channel;
    }

    @Override
    protected void needsFillInterest() {
        this.changeInterests(1);
    }

    @Override
    protected void onIncompleteFlush() {
        this.changeInterests(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Runnable onSelected() {
        Runnable task;
        boolean flushable;
        int newInterestOps;
        int oldInterestOps;
        int readyOps = this._key.readyOps();
        ChannelEndPoint channelEndPoint = this;
        synchronized (channelEndPoint) {
            this._updatePending = true;
            oldInterestOps = this._desiredInterestOps;
            this._desiredInterestOps = newInterestOps = oldInterestOps & ~readyOps;
        }
        boolean fillable = (readyOps & 1) != 0;
        boolean bl = flushable = (readyOps & 4) != 0;
        if (LOG.isDebugEnabled()) {
            LOG.debug("onSelected {}->{} r={} w={} for {}", oldInterestOps, newInterestOps, fillable, flushable, this);
        }
        Runnable runnable = fillable ? (flushable ? this._runCompleteWriteFillable : this._runFillable) : (task = flushable ? this._runCompleteWrite : null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("task {}", task);
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateKey() {
        try {
            int newInterestOps;
            int oldInterestOps;
            ChannelEndPoint channelEndPoint = this;
            synchronized (channelEndPoint) {
                this._updatePending = false;
                oldInterestOps = this._currentInterestOps;
                newInterestOps = this._desiredInterestOps;
                if (oldInterestOps != newInterestOps) {
                    this._currentInterestOps = newInterestOps;
                    this._key.interestOps(newInterestOps);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Key interests updated {} -> {} on {}", oldInterestOps, newInterestOps, this);
            }
        }
        catch (CancelledKeyException x) {
            LOG.debug("Ignoring key update for concurrently closed channel {}", this);
            this.close();
        }
        catch (Throwable x) {
            LOG.warn("Ignoring key update for " + this, x);
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeInterests(int operation) {
        int newInterestOps;
        int oldInterestOps;
        boolean pending;
        ChannelEndPoint channelEndPoint = this;
        synchronized (channelEndPoint) {
            pending = this._updatePending;
            oldInterestOps = this._desiredInterestOps;
            newInterestOps = oldInterestOps | operation;
            if (newInterestOps != oldInterestOps) {
                this._desiredInterestOps = newInterestOps;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("changeInterests p={} {}->{} for {}", pending, oldInterestOps, newInterestOps, this);
        }
        if (!pending && this._selector != null) {
            this._selector.submit(this._updateKeyAction);
        }
    }

    @Override
    public String toEndPointString() {
        return String.format("%s{io=%d/%d,kio=%d,kro=%d}", super.toEndPointString(), this._currentInterestOps, this._desiredInterestOps, ManagedSelector.safeInterestOps(this._key), ManagedSelector.safeReadyOps(this._key));
    }

    private abstract class RunnableCloseable
    extends RunnableTask
    implements Closeable {
        protected RunnableCloseable(String op) {
            super(op);
        }

        @Override
        public void close() {
            try {
                ChannelEndPoint.this.close();
            }
            catch (Throwable x) {
                LOG.warn(x);
            }
        }
    }

    private abstract class RunnableTask
    implements Runnable,
    Invocable {
        final String _operation;

        protected RunnableTask(String op) {
            this._operation = op;
        }

        public String toString() {
            return String.format("CEP:%s:%s:%s", new Object[]{ChannelEndPoint.this, this._operation, this.getInvocationType()});
        }
    }
}

