/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.table.WorkloadStat;

public class WorkloadProfile
implements Serializable {
    protected final HashMap<String, WorkloadStat> partitionPathStatMap;
    protected final WorkloadStat globalStat;
    private WriteOperationType operationType;

    public WorkloadProfile(Pair<HashMap<String, WorkloadStat>, WorkloadStat> profile) {
        this.partitionPathStatMap = profile.getLeft();
        this.globalStat = profile.getRight();
    }

    public WorkloadProfile(Pair<HashMap<String, WorkloadStat>, WorkloadStat> profile, WriteOperationType operationType) {
        this(profile);
        this.operationType = operationType;
    }

    public WorkloadStat getGlobalStat() {
        return this.globalStat;
    }

    public Set<String> getPartitionPaths() {
        return this.partitionPathStatMap.keySet();
    }

    public HashMap<String, WorkloadStat> getPartitionPathStatMap() {
        return this.partitionPathStatMap;
    }

    public WorkloadStat getWorkloadStat(String partitionPath) {
        return this.partitionPathStatMap.get(partitionPath);
    }

    public WriteOperationType getOperationType() {
        return this.operationType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WorkloadProfile {");
        sb.append("globalStat=").append(this.globalStat).append(", ");
        sb.append("partitionStat=").append(this.partitionPathStatMap).append(", ");
        sb.append("operationType=").append((Object)this.operationType);
        sb.append('}');
        return sb.toString();
    }
}

