/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.clean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

class PartitionCleanStat
implements Serializable {
    private final String partitionPath;
    private final List<String> deletePathPatterns = new ArrayList<String>();
    private final List<String> successDeleteFiles = new ArrayList<String>();
    private final List<String> failedDeleteFiles = new ArrayList<String>();
    private final List<String> deleteBootstrapBasePathPatterns = new ArrayList<String>();
    private final List<String> successfulDeleteBootstrapBaseFiles = new ArrayList<String>();
    private final List<String> failedDeleteBootstrapBaseFiles = new ArrayList<String>();

    PartitionCleanStat(String partitionPath) {
        this.partitionPath = partitionPath;
    }

    void addDeletedFileResult(String deletePathStr, boolean success, boolean isBootstrapBasePath) {
        if (success) {
            if (isBootstrapBasePath) {
                this.successfulDeleteBootstrapBaseFiles.add(deletePathStr);
            } else {
                this.successDeleteFiles.add(deletePathStr);
            }
        } else if (isBootstrapBasePath) {
            this.failedDeleteBootstrapBaseFiles.add(deletePathStr);
        } else {
            this.failedDeleteFiles.add(deletePathStr);
        }
    }

    void addDeleteFilePatterns(String deletePathStr, boolean isBootstrapBasePath) {
        if (isBootstrapBasePath) {
            this.deleteBootstrapBasePathPatterns.add(deletePathStr);
        } else {
            this.deletePathPatterns.add(deletePathStr);
        }
    }

    PartitionCleanStat merge(PartitionCleanStat other) {
        if (!this.partitionPath.equals(other.partitionPath)) {
            throw new RuntimeException(String.format("partitionPath is not a match: (%s, %s)", this.partitionPath, other.partitionPath));
        }
        this.successDeleteFiles.addAll(other.successDeleteFiles);
        this.deletePathPatterns.addAll(other.deletePathPatterns);
        this.failedDeleteFiles.addAll(other.failedDeleteFiles);
        this.deleteBootstrapBasePathPatterns.addAll(other.deleteBootstrapBasePathPatterns);
        this.successfulDeleteBootstrapBaseFiles.addAll(other.successfulDeleteBootstrapBaseFiles);
        this.failedDeleteBootstrapBaseFiles.addAll(other.failedDeleteBootstrapBaseFiles);
        return this;
    }

    public List<String> deletePathPatterns() {
        return this.deletePathPatterns;
    }

    public List<String> successDeleteFiles() {
        return this.successDeleteFiles;
    }

    public List<String> failedDeleteFiles() {
        return this.failedDeleteFiles;
    }

    public List<String> getDeleteBootstrapBasePathPatterns() {
        return this.deleteBootstrapBasePathPatterns;
    }

    public List<String> getSuccessfulDeleteBootstrapBaseFiles() {
        return this.successfulDeleteBootstrapBaseFiles;
    }

    public List<String> getFailedDeleteBootstrapBaseFiles() {
        return this.failedDeleteBootstrapBaseFiles;
    }
}

