/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.cluster;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.clustering.run.strategy.SparkSingleFileSortExecutionStrategy;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieClusteringException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.cluster.strategy.ClusteringExecutionStrategy;
import org.apache.hudi.table.action.commit.BaseSparkCommitActionExecutor;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaRDD;

public class SparkExecuteClusteringCommitActionExecutor<T extends HoodieRecordPayload<T>>
extends BaseSparkCommitActionExecutor<T> {
    private static final Logger LOG = LogManager.getLogger(SparkExecuteClusteringCommitActionExecutor.class);
    private final HoodieClusteringPlan clusteringPlan;

    public SparkExecuteClusteringCommitActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable table, String instantTime) {
        super(context, config, table, instantTime, WriteOperationType.CLUSTER);
        this.clusteringPlan = ClusteringUtils.getClusteringPlan(table.getMetaClient(), HoodieTimeline.getReplaceCommitRequestedInstant(instantTime)).map(Pair::getRight).orElseThrow(() -> new HoodieClusteringException("Unable to read clustering plan for instant: " + instantTime));
    }

    @Override
    public HoodieWriteMetadata<JavaRDD<WriteStatus>> execute() {
        HoodieInstant instant = HoodieTimeline.getReplaceCommitRequestedInstant(this.instantTime);
        this.table.getActiveTimeline().transitionReplaceRequestedToInflight(instant, Option.empty());
        this.table.getMetaClient().reloadActiveTimeline();
        Schema schema2 = HoodieAvroUtils.addMetadataFields(new Schema.Parser().parse(this.config.getSchema()));
        HoodieWriteMetadata<JavaRDD<WriteStatus>> writeMetadata = ((ClusteringExecutionStrategy)ReflectionUtils.loadClass(this.config.getClusteringExecutionStrategyClass(), new Class[]{HoodieTable.class, HoodieEngineContext.class, HoodieWriteConfig.class}, new Object[]{this.table, this.context, this.config})).performClustering(this.clusteringPlan, schema2, this.instantTime);
        JavaRDD writeStatusRDD = (JavaRDD)writeMetadata.getWriteStatuses();
        JavaRDD<WriteStatus> statuses = this.updateIndex((JavaRDD<WriteStatus>)writeStatusRDD, writeMetadata);
        writeMetadata.setWriteStats(statuses.map(WriteStatus::getStat).collect());
        writeMetadata.setPartitionToReplaceFileIds(this.getPartitionToReplacedFileIds(writeMetadata));
        this.commitOnAutoCommit(writeMetadata);
        if (!writeMetadata.getCommitMetadata().isPresent()) {
            HoodieCommitMetadata commitMetadata = CommitUtils.buildMetadata(writeMetadata.getWriteStats().get(), writeMetadata.getPartitionToReplaceFileIds(), this.extraMetadata, this.operationType, this.getSchemaToStoreInCommit(), this.getCommitActionType());
            writeMetadata.setCommitMetadata(Option.of(commitMetadata));
        }
        return writeMetadata;
    }

    private void validateWriteResult(HoodieWriteMetadata<JavaRDD<WriteStatus>> writeMetadata) {
        if (writeMetadata.getWriteStatuses().isEmpty()) {
            throw new HoodieClusteringException("Clustering plan produced 0 WriteStatus for " + this.instantTime + " #groups: " + this.clusteringPlan.getInputGroups().size() + " expected at least " + this.clusteringPlan.getInputGroups().stream().mapToInt(HoodieClusteringGroup::getNumOutputFileGroups).sum() + " write statuses");
        }
    }

    @Override
    protected String getCommitActionType() {
        return "replacecommit";
    }

    @Override
    protected Map<String, List<String>> getPartitionToReplacedFileIds(HoodieWriteMetadata<JavaRDD<WriteStatus>> writeMetadata) {
        Set newFilesWritten = writeMetadata.getWriteStats().get().stream().map(s -> new HoodieFileGroupId(s.getPartitionPath(), s.getFileId())).collect(Collectors.toSet());
        if (SparkSingleFileSortExecutionStrategy.class.getName().equals(this.config.getClusteringExecutionStrategyClass())) {
            return ClusteringUtils.getFileGroupsFromClusteringPlan(this.clusteringPlan).collect(Collectors.groupingBy(fg -> fg.getPartitionPath(), Collectors.mapping(fg -> fg.getFileId(), Collectors.toList())));
        }
        return ClusteringUtils.getFileGroupsFromClusteringPlan(this.clusteringPlan).filter(fg -> !newFilesWritten.contains(fg)).collect(Collectors.groupingBy(fg -> fg.getPartitionPath(), Collectors.mapping(fg -> fg.getFileId(), Collectors.toList())));
    }
}

