/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.io.Serializable;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.WorkloadProfile;
import org.apache.hudi.table.WorkloadStat;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.commit.SparkInsertOverwriteCommitActionExecutor;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.PairFunction;
import scala.Tuple2;

public class SparkDeletePartitionCommitActionExecutor<T extends HoodieRecordPayload<T>>
extends SparkInsertOverwriteCommitActionExecutor<T> {
    private List<String> partitions;

    public SparkDeletePartitionCommitActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable table, String instantTime, List<String> partitions) {
        super(context, config, table, instantTime, null, WriteOperationType.DELETE_PARTITION);
        this.partitions = partitions;
    }

    @Override
    public HoodieWriteMetadata<JavaRDD<WriteStatus>> execute() {
        JavaSparkContext jsc = HoodieSparkEngineContext.getSparkContext(this.context);
        HoodieTimer timer = new HoodieTimer().startTimer();
        Map partitionToReplaceFileIds = jsc.parallelize(this.partitions, this.partitions.size()).distinct().mapToPair((PairFunction & Serializable)partitionPath -> new Tuple2(partitionPath, this.getAllExistingFileIds((String)partitionPath))).collectAsMap();
        HoodieWriteMetadata<JavaRDD<WriteStatus>> result = new HoodieWriteMetadata<JavaRDD<WriteStatus>>();
        result.setPartitionToReplaceFileIds(partitionToReplaceFileIds);
        result.setIndexUpdateDuration(Duration.ofMillis(timer.endTimer()));
        result.setWriteStatuses(jsc.emptyRDD());
        this.saveWorkloadProfileMetadataToInflight(new WorkloadProfile(Pair.of(new HashMap(), new WorkloadStat())), this.instantTime);
        this.commitOnAutoCommit(result);
        return result;
    }
}

