/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact.strategy;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.action.compact.strategy.DayBasedCompactionStrategy;

public class BoundedPartitionAwareCompactionStrategy
extends DayBasedCompactionStrategy {
    private final ThreadLocal<SimpleDateFormat> dateFormat = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy/MM/dd"));

    @Override
    public List<HoodieCompactionOperation> orderAndFilter(HoodieWriteConfig writeConfig, List<HoodieCompactionOperation> operations, List<HoodieCompactionPlan> pendingCompactionPlans) {
        String earliestPartitionPathToCompact = this.dateFormat.get().format(BoundedPartitionAwareCompactionStrategy.getDateAtOffsetFromToday(-1 * writeConfig.getTargetPartitionsPerDayBasedCompaction()));
        return operations.stream().collect(Collectors.groupingBy(HoodieCompactionOperation::getPartitionPath)).entrySet().stream().sorted(Map.Entry.comparingByKey(DayBasedCompactionStrategy.comparator)).filter(e -> DayBasedCompactionStrategy.comparator.compare(earliestPartitionPathToCompact, (String)e.getKey()) >= 0).flatMap(e -> ((List)e.getValue()).stream()).collect(Collectors.toList());
    }

    @Override
    public List<String> filterPartitionPaths(HoodieWriteConfig writeConfig, List<String> partitionPaths) {
        String earliestPartitionPathToCompact = this.dateFormat.get().format(BoundedPartitionAwareCompactionStrategy.getDateAtOffsetFromToday(-1 * writeConfig.getTargetPartitionsPerDayBasedCompaction()));
        return partitionPaths.stream().map(partition -> partition.replace("/", "-")).sorted(Comparator.reverseOrder()).map(partitionPath -> partitionPath.replace("-", "/")).filter(e -> DayBasedCompactionStrategy.comparator.compare(earliestPartitionPathToCompact, (String)e) >= 0).collect(Collectors.toList());
    }

    public static Date getDateAtOffsetFromToday(int offset) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, offset);
        return calendar.getTime();
    }
}

