/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.io.IOException;
import java.util.List;
import org.apache.hudi.avro.model.HoodieRollbackRequest;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieRollbackException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.rollback.BaseRollbackPlanActionExecutor;
import org.apache.hudi.table.action.rollback.ListingBasedRollbackHelper;
import org.apache.hudi.table.action.rollback.ListingBasedRollbackRequest;
import org.apache.hudi.table.action.rollback.RollbackUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ListingBasedRollbackStrategy
implements BaseRollbackPlanActionExecutor.RollbackStrategy {
    private static final Logger LOG = LogManager.getLogger(ListingBasedRollbackStrategy.class);
    protected final HoodieTable table;
    protected final HoodieEngineContext context;
    protected final HoodieWriteConfig config;
    protected final String instantTime;

    public ListingBasedRollbackStrategy(HoodieTable table, HoodieEngineContext context, HoodieWriteConfig config, String instantTime) {
        this.table = table;
        this.context = context;
        this.config = config;
        this.instantTime = instantTime;
    }

    @Override
    public List<HoodieRollbackRequest> getRollbackRequests(HoodieInstant instantToRollback) {
        try {
            List<ListingBasedRollbackRequest> rollbackRequests = null;
            rollbackRequests = this.table.getMetaClient().getTableType() == HoodieTableType.COPY_ON_WRITE ? RollbackUtils.generateRollbackRequestsByListingCOW(this.context, this.table.getMetaClient().getBasePath()) : RollbackUtils.generateRollbackRequestsUsingFileListingMOR(instantToRollback, this.table, this.context);
            List<HoodieRollbackRequest> listingBasedRollbackRequests = new ListingBasedRollbackHelper(this.table.getMetaClient(), this.config).getRollbackRequestsForRollbackPlan(this.context, instantToRollback, rollbackRequests);
            return listingBasedRollbackRequests;
        }
        catch (IOException e) {
            LOG.error((Object)("Generating rollback requests failed for " + instantToRollback.getTimestamp()), (Throwable)e);
            throw new HoodieRollbackException("Generating rollback requests failed for " + instantToRollback.getTimestamp(), e);
        }
    }
}

