/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.MarkerUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.marker.DirectWriteMarkers;
import org.apache.hudi.table.upgrade.BaseUpgradeDowngradeHelper;
import org.apache.hudi.table.upgrade.DowngradeHandler;

public class TwoToOneDowngradeHandler
implements DowngradeHandler {
    @Override
    public Map<ConfigProperty, String> downgrade(HoodieWriteConfig config, HoodieEngineContext context, String instantTime, BaseUpgradeDowngradeHelper upgradeDowngradeHelper) {
        HoodieTable table = upgradeDowngradeHelper.getTable(config, context);
        HoodieTableMetaClient metaClient = table.getMetaClient();
        HoodieTimeline inflightTimeline = metaClient.getCommitsTimeline().filterPendingExcludingCompaction();
        List commits = inflightTimeline.getReverseOrderedInstants().collect(Collectors.toList());
        for (HoodieInstant inflightInstant : commits) {
            try {
                this.convertToDirectMarkers(inflightInstant.getTimestamp(), table, context, config.getMarkersDeleteParallelism());
            }
            catch (IOException e) {
                throw new HoodieException("Converting marker files to DIRECT style failed during downgrade", e);
            }
        }
        return Collections.EMPTY_MAP;
    }

    private void convertToDirectMarkers(String commitInstantTime, HoodieTable table, HoodieEngineContext context, int parallelism) throws IOException {
        block4: {
            FileSystem fileSystem;
            String markerDir;
            block3: {
                markerDir = table.getMetaClient().getMarkerFolderPath(commitInstantTime);
                fileSystem = FSUtils.getFs(markerDir, context.getHadoopConf().newCopy());
                Option<MarkerType> markerTypeOption = MarkerUtils.readMarkerType(fileSystem, markerDir);
                if (!markerTypeOption.isPresent()) break block3;
                switch (markerTypeOption.get()) {
                    case TIMELINE_SERVER_BASED: {
                        Map<String, Set<String>> markersMap = MarkerUtils.readTimelineServerBasedMarkersFromFileSystem(markerDir, fileSystem, context, parallelism);
                        DirectWriteMarkers directWriteMarkers = new DirectWriteMarkers(table, commitInstantTime);
                        markersMap.values().stream().flatMap(Collection::stream).forEach(directWriteMarkers::create);
                        MarkerUtils.deleteMarkerTypeFile(fileSystem, markerDir);
                        this.deleteTimelineBasedMarkerFiles(context, markerDir, fileSystem, parallelism);
                        break block4;
                    }
                    default: {
                        throw new HoodieException("The marker type \"" + markerTypeOption.get().name() + "\" is not supported for rollback.");
                    }
                }
            }
            this.deleteTimelineBasedMarkerFiles(context, markerDir, fileSystem, parallelism);
        }
    }

    private void deleteTimelineBasedMarkerFiles(HoodieEngineContext context, String markerDir, FileSystem fileSystem, int parallelism) throws IOException {
        Predicate<FileStatus> prefixFilter = fileStatus -> fileStatus.getPath().getName().startsWith("MARKERS");
        FSUtils.parallelizeSubPathProcess(context, fileSystem, new Path(markerDir), parallelism, prefixFilter, pairOfSubPathAndConf -> FSUtils.deleteSubPath((String)pairOfSubPathAndConf.getKey(), (SerializableConfiguration)pairOfSubPathAndConf.getValue(), false));
    }
}

