/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.avro;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Conversion;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.parquet.Preconditions;
import org.apache.parquet.avro.AvroDataSupplier;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.avro.SpecificDataSupplier;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;

public class AvroWriteSupport<T>
extends WriteSupport<T> {
    public static final String AVRO_DATA_SUPPLIER = "parquet.avro.write.data.supplier";
    static final String AVRO_SCHEMA = "parquet.avro.schema";
    private static final Schema MAP_KEY_SCHEMA = Schema.create((Schema.Type)Schema.Type.STRING);
    public static final String WRITE_OLD_LIST_STRUCTURE = "parquet.avro.write-old-list-structure";
    static final boolean WRITE_OLD_LIST_STRUCTURE_DEFAULT = true;
    private static final String MAP_REPEATED_NAME = "key_value";
    private static final String MAP_KEY_NAME = "key";
    private static final String MAP_VALUE_NAME = "value";
    private static final String LIST_REPEATED_NAME = "list";
    private static final String OLD_LIST_REPEATED_NAME = "array";
    static final String LIST_ELEMENT_NAME = "element";
    private RecordConsumer recordConsumer;
    private MessageType rootSchema;
    private Schema rootAvroSchema;
    private LogicalType rootLogicalType;
    private Conversion<?> rootConversion;
    private GenericData model;
    private ListWriter listWriter;

    public static void setAvroDataSupplier(Configuration configuration, Class<? extends AvroDataSupplier> suppClass) {
        configuration.set(AVRO_DATA_SUPPLIER, suppClass.getName());
    }

    public AvroWriteSupport() {
    }

    @Deprecated
    public AvroWriteSupport(MessageType schema2, Schema avroSchema) {
        this.rootSchema = schema2;
        this.rootAvroSchema = avroSchema;
        this.rootLogicalType = this.rootAvroSchema.getLogicalType();
        this.model = null;
    }

    public AvroWriteSupport(MessageType schema2, Schema avroSchema, GenericData model) {
        this.rootSchema = schema2;
        this.rootAvroSchema = avroSchema;
        this.rootLogicalType = this.rootAvroSchema.getLogicalType();
        this.model = model;
    }

    public String getName() {
        return "avro";
    }

    public static void setSchema(Configuration configuration, Schema schema2) {
        configuration.set(AVRO_SCHEMA, schema2.toString());
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        boolean writeOldListStructure;
        if (this.rootAvroSchema == null) {
            this.rootAvroSchema = new Schema.Parser().parse(configuration.get(AVRO_SCHEMA));
            this.rootSchema = new AvroSchemaConverter().convert(this.rootAvroSchema);
        }
        if (this.model == null) {
            this.model = AvroWriteSupport.getDataModel(configuration);
        }
        this.listWriter = (writeOldListStructure = configuration.getBoolean(WRITE_OLD_LIST_STRUCTURE, true)) ? new TwoLevelListWriter() : new ThreeLevelListWriter();
        HashMap<String, String> extraMetaData = new HashMap<String, String>();
        extraMetaData.put(AVRO_SCHEMA, this.rootAvroSchema.toString());
        return new WriteSupport.WriteContext(this.rootSchema, extraMetaData);
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.recordConsumer = recordConsumer;
    }

    public void write(IndexedRecord record) {
        this.write((T)record);
    }

    public void write(T record) {
        if (this.rootLogicalType != null) {
            Conversion conversion = this.model.getConversionByClass(record.getClass(), this.rootLogicalType);
            this.recordConsumer.startMessage();
            this.writeRecordFields((GroupType)this.rootSchema, this.rootAvroSchema, this.convert(this.rootAvroSchema, this.rootLogicalType, conversion, record));
            this.recordConsumer.endMessage();
        } else {
            this.recordConsumer.startMessage();
            this.writeRecordFields((GroupType)this.rootSchema, this.rootAvroSchema, record);
            this.recordConsumer.endMessage();
        }
    }

    private void writeRecord(GroupType schema2, Schema avroSchema, Object record) {
        this.recordConsumer.startGroup();
        this.writeRecordFields(schema2, avroSchema, record);
        this.recordConsumer.endGroup();
    }

    private void writeRecordFields(GroupType schema2, Schema avroSchema, Object record) {
        List fields = schema2.getFields();
        List avroFields = avroSchema.getFields();
        int index = 0;
        for (int avroIndex = 0; avroIndex < avroFields.size(); ++avroIndex) {
            Schema.Field avroField = (Schema.Field)avroFields.get(avroIndex);
            if (avroField.schema().getType().equals((Object)Schema.Type.NULL)) continue;
            Type fieldType = (Type)fields.get(index);
            Object value = this.model.getField(record, avroField.name(), avroIndex);
            if (value != null) {
                this.recordConsumer.startField(fieldType.getName(), index);
                this.writeValue(fieldType, avroField.schema(), value);
                this.recordConsumer.endField(fieldType.getName(), index);
            } else if (fieldType.isRepetition(Type.Repetition.REQUIRED)) {
                throw new RuntimeException("Null-value for required field: " + avroField.name());
            }
            ++index;
        }
    }

    private <V> void writeMap(GroupType schema2, Schema avroSchema, Map<CharSequence, V> map) {
        GroupType innerGroup = schema2.getType(0).asGroupType();
        Type keyType = innerGroup.getType(0);
        Type valueType = innerGroup.getType(1);
        this.recordConsumer.startGroup();
        if (map.size() > 0) {
            this.recordConsumer.startField(MAP_REPEATED_NAME, 0);
            for (Map.Entry<CharSequence, V> entry : map.entrySet()) {
                this.recordConsumer.startGroup();
                this.recordConsumer.startField(MAP_KEY_NAME, 0);
                this.writeValue(keyType, MAP_KEY_SCHEMA, entry.getKey());
                this.recordConsumer.endField(MAP_KEY_NAME, 0);
                V value = entry.getValue();
                if (value != null) {
                    this.recordConsumer.startField(MAP_VALUE_NAME, 1);
                    this.writeValue(valueType, avroSchema.getValueType(), value);
                    this.recordConsumer.endField(MAP_VALUE_NAME, 1);
                } else if (!valueType.isRepetition(Type.Repetition.OPTIONAL)) {
                    throw new RuntimeException("Null map value for " + avroSchema.getName());
                }
                this.recordConsumer.endGroup();
            }
            this.recordConsumer.endField(MAP_REPEATED_NAME, 0);
        }
        this.recordConsumer.endGroup();
    }

    private void writeUnion(GroupType parquetSchema, Schema avroSchema, Object value) {
        this.recordConsumer.startGroup();
        int avroIndex = this.model.resolveUnion(avroSchema, value);
        GroupType parquetGroup = parquetSchema.asGroupType();
        int parquetIndex = avroIndex;
        for (int i = 0; i < avroIndex; ++i) {
            if (!((Schema)avroSchema.getTypes().get(i)).getType().equals((Object)Schema.Type.NULL)) continue;
            --parquetIndex;
        }
        String memberName = "member" + parquetIndex;
        this.recordConsumer.startField(memberName, parquetIndex);
        this.writeValue(parquetGroup.getType(parquetIndex), (Schema)avroSchema.getTypes().get(avroIndex), value);
        this.recordConsumer.endField(memberName, parquetIndex);
        this.recordConsumer.endGroup();
    }

    private void writeValue(Type type, Schema avroSchema, Object value) {
        Schema nonNullAvroSchema = AvroSchemaConverter.getNonNull(avroSchema);
        LogicalType logicalType = nonNullAvroSchema.getLogicalType();
        if (logicalType != null) {
            Conversion conversion = this.model.getConversionByClass(value.getClass(), logicalType);
            this.writeValueWithoutConversion(type, nonNullAvroSchema, this.convert(nonNullAvroSchema, logicalType, conversion, value));
        } else {
            this.writeValueWithoutConversion(type, nonNullAvroSchema, value);
        }
    }

    private <D> Object convert(Schema schema2, LogicalType logicalType, Conversion<D> conversion, Object datum) {
        if (conversion == null) {
            return datum;
        }
        Class fromClass = conversion.getConvertedType();
        switch (schema2.getType()) {
            case RECORD: {
                return conversion.toRecord(fromClass.cast(datum), schema2, logicalType);
            }
            case ENUM: {
                return conversion.toEnumSymbol(fromClass.cast(datum), schema2, logicalType);
            }
            case ARRAY: {
                return conversion.toArray(fromClass.cast(datum), schema2, logicalType);
            }
            case MAP: {
                return conversion.toMap(fromClass.cast(datum), schema2, logicalType);
            }
            case FIXED: {
                return conversion.toFixed(fromClass.cast(datum), schema2, logicalType);
            }
            case STRING: {
                return conversion.toCharSequence(fromClass.cast(datum), schema2, logicalType);
            }
            case BYTES: {
                return conversion.toBytes(fromClass.cast(datum), schema2, logicalType);
            }
            case INT: {
                return conversion.toInt(fromClass.cast(datum), schema2, logicalType);
            }
            case LONG: {
                return conversion.toLong(fromClass.cast(datum), schema2, logicalType);
            }
            case FLOAT: {
                return conversion.toFloat(fromClass.cast(datum), schema2, logicalType);
            }
            case DOUBLE: {
                return conversion.toDouble(fromClass.cast(datum), schema2, logicalType);
            }
            case BOOLEAN: {
                return conversion.toBoolean(fromClass.cast(datum), schema2, logicalType);
            }
        }
        return datum;
    }

    private void writeValueWithoutConversion(Type type, Schema avroSchema, Object value) {
        switch (avroSchema.getType()) {
            case BOOLEAN: {
                this.recordConsumer.addBoolean(((Boolean)value).booleanValue());
                break;
            }
            case INT: {
                if (value instanceof Character) {
                    this.recordConsumer.addInteger((int)((Character)value).charValue());
                    break;
                }
                this.recordConsumer.addInteger(((Number)value).intValue());
                break;
            }
            case LONG: {
                this.recordConsumer.addLong(((Number)value).longValue());
                break;
            }
            case FLOAT: {
                this.recordConsumer.addFloat(((Number)value).floatValue());
                break;
            }
            case DOUBLE: {
                this.recordConsumer.addDouble(((Number)value).doubleValue());
                break;
            }
            case FIXED: {
                this.recordConsumer.addBinary(Binary.fromReusedByteArray((byte[])((GenericFixed)value).bytes()));
                break;
            }
            case BYTES: {
                if (value instanceof byte[]) {
                    this.recordConsumer.addBinary(Binary.fromReusedByteArray((byte[])((byte[])value)));
                    break;
                }
                this.recordConsumer.addBinary(Binary.fromReusedByteBuffer((ByteBuffer)((ByteBuffer)value)));
                break;
            }
            case STRING: {
                this.recordConsumer.addBinary(this.fromAvroString(value));
                break;
            }
            case RECORD: {
                this.writeRecord(type.asGroupType(), avroSchema, value);
                break;
            }
            case ENUM: {
                this.recordConsumer.addBinary(Binary.fromString((String)value.toString()));
                break;
            }
            case ARRAY: {
                this.listWriter.writeList(type.asGroupType(), avroSchema, value);
                break;
            }
            case MAP: {
                this.writeMap(type.asGroupType(), avroSchema, (Map)value);
                break;
            }
            case UNION: {
                this.writeUnion(type.asGroupType(), avroSchema, value);
            }
        }
    }

    private Binary fromAvroString(Object value) {
        if (value instanceof Utf8) {
            Utf8 utf8 = (Utf8)value;
            return Binary.fromReusedByteArray((byte[])utf8.getBytes(), (int)0, (int)utf8.getByteLength());
        }
        return Binary.fromCharSequence((CharSequence)((CharSequence)value));
    }

    private static GenericData getDataModel(Configuration conf) {
        Class suppClass = conf.getClass(AVRO_DATA_SUPPLIER, SpecificDataSupplier.class, AvroDataSupplier.class);
        return ((AvroDataSupplier)ReflectionUtils.newInstance((Class)suppClass, (Configuration)conf)).get();
    }

    private class ThreeLevelListWriter
    extends ListWriter {
        private ThreeLevelListWriter() {
        }

        @Override
        protected void writeCollection(GroupType type, Schema schema2, Collection<?> collection) {
            if (collection.size() > 0) {
                AvroWriteSupport.this.recordConsumer.startField(AvroWriteSupport.LIST_REPEATED_NAME, 0);
                GroupType repeatedType = type.getType(0).asGroupType();
                Type elementType = repeatedType.getType(0);
                for (Object element : collection) {
                    AvroWriteSupport.this.recordConsumer.startGroup();
                    if (element != null) {
                        AvroWriteSupport.this.recordConsumer.startField(AvroWriteSupport.LIST_ELEMENT_NAME, 0);
                        AvroWriteSupport.this.writeValue(elementType, schema2.getElementType(), element);
                        AvroWriteSupport.this.recordConsumer.endField(AvroWriteSupport.LIST_ELEMENT_NAME, 0);
                    } else if (!elementType.isRepetition(Type.Repetition.OPTIONAL)) {
                        throw new RuntimeException("Null list element for " + schema2.getName());
                    }
                    AvroWriteSupport.this.recordConsumer.endGroup();
                }
                AvroWriteSupport.this.recordConsumer.endField(AvroWriteSupport.LIST_REPEATED_NAME, 0);
            }
        }

        @Override
        protected void writeObjectArray(GroupType type, Schema schema2, Object[] array) {
            if (array.length > 0) {
                AvroWriteSupport.this.recordConsumer.startField(AvroWriteSupport.LIST_REPEATED_NAME, 0);
                GroupType repeatedType = type.getType(0).asGroupType();
                Type elementType = repeatedType.getType(0);
                for (Object element : array) {
                    AvroWriteSupport.this.recordConsumer.startGroup();
                    if (element != null) {
                        AvroWriteSupport.this.recordConsumer.startField(AvroWriteSupport.LIST_ELEMENT_NAME, 0);
                        AvroWriteSupport.this.writeValue(elementType, schema2.getElementType(), element);
                        AvroWriteSupport.this.recordConsumer.endField(AvroWriteSupport.LIST_ELEMENT_NAME, 0);
                    } else if (!elementType.isRepetition(Type.Repetition.OPTIONAL)) {
                        throw new RuntimeException("Null list element for " + schema2.getName());
                    }
                    AvroWriteSupport.this.recordConsumer.endGroup();
                }
                AvroWriteSupport.this.recordConsumer.endField(AvroWriteSupport.LIST_REPEATED_NAME, 0);
            }
        }

        @Override
        protected void startArray() {
            AvroWriteSupport.this.recordConsumer.startField(AvroWriteSupport.LIST_REPEATED_NAME, 0);
            AvroWriteSupport.this.recordConsumer.startGroup();
            AvroWriteSupport.this.recordConsumer.startField(AvroWriteSupport.LIST_ELEMENT_NAME, 0);
        }

        @Override
        protected void endArray() {
            AvroWriteSupport.this.recordConsumer.endField(AvroWriteSupport.LIST_ELEMENT_NAME, 0);
            AvroWriteSupport.this.recordConsumer.endGroup();
            AvroWriteSupport.this.recordConsumer.endField(AvroWriteSupport.LIST_REPEATED_NAME, 0);
        }
    }

    private class TwoLevelListWriter
    extends ListWriter {
        private TwoLevelListWriter() {
        }

        @Override
        public void writeCollection(GroupType schema2, Schema avroSchema, Collection<?> array) {
            if (array.size() > 0) {
                AvroWriteSupport.this.recordConsumer.startField(AvroWriteSupport.OLD_LIST_REPEATED_NAME, 0);
                try {
                    for (Object elt : array) {
                        AvroWriteSupport.this.writeValue(schema2.getType(0), avroSchema.getElementType(), elt);
                    }
                }
                catch (NullPointerException e) {
                    int i = 0;
                    for (Object elt : array) {
                        if (elt == null) {
                            throw new NullPointerException("Array contains a null element at " + i + "\nSet parquet.avro.write-old-list-structure=false to turn on support for arrays with null elements.");
                        }
                        ++i;
                    }
                    throw e;
                }
                AvroWriteSupport.this.recordConsumer.endField(AvroWriteSupport.OLD_LIST_REPEATED_NAME, 0);
            }
        }

        @Override
        protected void writeObjectArray(GroupType type, Schema schema2, Object[] array) {
            if (array.length > 0) {
                AvroWriteSupport.this.recordConsumer.startField(AvroWriteSupport.OLD_LIST_REPEATED_NAME, 0);
                try {
                    for (Object element : array) {
                        AvroWriteSupport.this.writeValue(type.getType(0), schema2.getElementType(), element);
                    }
                }
                catch (NullPointerException e) {
                    for (int i = 0; i < array.length; ++i) {
                        if (array[i] != null) continue;
                        throw new NullPointerException("Array contains a null element at " + i + "\nSet parquet.avro.write-old-list-structure=false to turn on support for arrays with null elements.");
                    }
                    throw e;
                }
                AvroWriteSupport.this.recordConsumer.endField(AvroWriteSupport.OLD_LIST_REPEATED_NAME, 0);
            }
        }

        @Override
        protected void startArray() {
            AvroWriteSupport.this.recordConsumer.startField(AvroWriteSupport.OLD_LIST_REPEATED_NAME, 0);
        }

        @Override
        protected void endArray() {
            AvroWriteSupport.this.recordConsumer.endField(AvroWriteSupport.OLD_LIST_REPEATED_NAME, 0);
        }
    }

    private abstract class ListWriter {
        private ListWriter() {
        }

        protected abstract void writeCollection(GroupType var1, Schema var2, Collection<?> var3);

        protected abstract void writeObjectArray(GroupType var1, Schema var2, Object[] var3);

        protected abstract void startArray();

        protected abstract void endArray();

        public void writeList(GroupType schema2, Schema avroSchema, Object value) {
            AvroWriteSupport.this.recordConsumer.startGroup();
            if (value instanceof Collection) {
                this.writeCollection(schema2, avroSchema, (Collection)value);
            } else {
                Class<?> arrayClass = value.getClass();
                Preconditions.checkArgument((boolean)arrayClass.isArray(), (String)("Cannot write unless collection or array: " + arrayClass.getName()));
                this.writeJavaArray(schema2, avroSchema, arrayClass, value);
            }
            AvroWriteSupport.this.recordConsumer.endGroup();
        }

        public void writeJavaArray(GroupType schema2, Schema avroSchema, Class<?> arrayClass, Object value) {
            Class<?> elementClass = arrayClass.getComponentType();
            if (!elementClass.isPrimitive()) {
                this.writeObjectArray(schema2, avroSchema, (Object[])value);
                return;
            }
            switch (avroSchema.getElementType().getType()) {
                case BOOLEAN: {
                    Preconditions.checkArgument((elementClass == Boolean.TYPE ? 1 : 0) != 0, (String)("Cannot write as boolean array: " + arrayClass.getName()));
                    this.writeBooleanArray((boolean[])value);
                    break;
                }
                case INT: {
                    if (elementClass == Byte.TYPE) {
                        this.writeByteArray((byte[])value);
                        break;
                    }
                    if (elementClass == Character.TYPE) {
                        this.writeCharArray((char[])value);
                        break;
                    }
                    if (elementClass == Short.TYPE) {
                        this.writeShortArray((short[])value);
                        break;
                    }
                    if (elementClass == Integer.TYPE) {
                        this.writeIntArray((int[])value);
                        break;
                    }
                    throw new IllegalArgumentException("Cannot write as an int array: " + arrayClass.getName());
                }
                case LONG: {
                    Preconditions.checkArgument((elementClass == Long.TYPE ? 1 : 0) != 0, (String)("Cannot write as long array: " + arrayClass.getName()));
                    this.writeLongArray((long[])value);
                    break;
                }
                case FLOAT: {
                    Preconditions.checkArgument((elementClass == Float.TYPE ? 1 : 0) != 0, (String)("Cannot write as float array: " + arrayClass.getName()));
                    this.writeFloatArray((float[])value);
                    break;
                }
                case DOUBLE: {
                    Preconditions.checkArgument((elementClass == Double.TYPE ? 1 : 0) != 0, (String)("Cannot write as double array: " + arrayClass.getName()));
                    this.writeDoubleArray((double[])value);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Cannot write " + avroSchema.getElementType() + " array: " + arrayClass.getName());
                }
            }
        }

        protected void writeBooleanArray(boolean[] array) {
            if (array.length > 0) {
                this.startArray();
                for (boolean element : array) {
                    AvroWriteSupport.this.recordConsumer.addBoolean(element);
                }
                this.endArray();
            }
        }

        protected void writeByteArray(byte[] array) {
            if (array.length > 0) {
                this.startArray();
                for (byte element : array) {
                    AvroWriteSupport.this.recordConsumer.addInteger((int)element);
                }
                this.endArray();
            }
        }

        protected void writeShortArray(short[] array) {
            if (array.length > 0) {
                this.startArray();
                for (short element : array) {
                    AvroWriteSupport.this.recordConsumer.addInteger((int)element);
                }
                this.endArray();
            }
        }

        protected void writeCharArray(char[] array) {
            if (array.length > 0) {
                this.startArray();
                for (char element : array) {
                    AvroWriteSupport.this.recordConsumer.addInteger((int)element);
                }
                this.endArray();
            }
        }

        protected void writeIntArray(int[] array) {
            if (array.length > 0) {
                this.startArray();
                for (int element : array) {
                    AvroWriteSupport.this.recordConsumer.addInteger(element);
                }
                this.endArray();
            }
        }

        protected void writeLongArray(long[] array) {
            if (array.length > 0) {
                this.startArray();
                for (long element : array) {
                    AvroWriteSupport.this.recordConsumer.addLong(element);
                }
                this.endArray();
            }
        }

        protected void writeFloatArray(float[] array) {
            if (array.length > 0) {
                this.startArray();
                for (float element : array) {
                    AvroWriteSupport.this.recordConsumer.addFloat(element);
                }
                this.endArray();
            }
        }

        protected void writeDoubleArray(double[] array) {
            if (array.length > 0) {
                this.startArray();
                for (double element : array) {
                    AvroWriteSupport.this.recordConsumer.addDouble(element);
                }
                this.endArray();
            }
        }
    }
}

