/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.analysis;

import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.SparkAdapterSupport$class;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.plans.logical.CompactionPath;
import org.apache.spark.sql.catalyst.plans.logical.CompactionShowOnPath;
import org.apache.spark.sql.catalyst.plans.logical.CompactionShowOnTable;
import org.apache.spark.sql.catalyst.plans.logical.CompactionTable;
import org.apache.spark.sql.catalyst.plans.logical.DeleteFromTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.MergeIntoTable;
import org.apache.spark.sql.catalyst.plans.logical.UpdateTable;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.execution.datasources.CreateTable;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.hudi.HoodieSqlUtils$;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.hudi.analysis.HoodieAnalysis$;
import org.apache.spark.sql.hudi.command.CompactionHoodiePathCommand;
import org.apache.spark.sql.hudi.command.CompactionHoodieTableCommand;
import org.apache.spark.sql.hudi.command.CompactionShowHoodiePathCommand;
import org.apache.spark.sql.hudi.command.CompactionShowHoodieTableCommand;
import org.apache.spark.sql.hudi.command.CreateHoodieTableAsSelectCommand;
import org.apache.spark.sql.hudi.command.DeleteHoodieTableCommand;
import org.apache.spark.sql.hudi.command.InsertIntoHoodieTableCommand;
import org.apache.spark.sql.hudi.command.MergeIntoHoodieTableCommand;
import org.apache.spark.sql.hudi.command.UpdateHoodieTableCommand;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005-t!B\u0001\u0003\u0011\u0003y\u0011A\u0004%p_\u0012LW-\u00118bYf\u001c\u0018n\u001d\u0006\u0003\u0007\u0011\t\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u0003\u000b\u0019\tA\u0001[;eS*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001A\u0011\u0001#E\u0007\u0002\u0005\u0019)!C\u0001E\u0001'\tq\u0001j\\8eS\u0016\fe.\u00197zg&\u001c8cA\t\u00155A\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\t1\u0011I\\=SK\u001a\u0004\"!F\u000e\n\u0005q1\"\u0001D*fe&\fG.\u001b>bE2,\u0007\"\u0002\u0010\u0012\t\u0003y\u0012A\u0002\u001fj]&$h\bF\u0001\u0010\u0011\u0015\t\u0013\u0003\"\u0001#\u0003U\u0019Wo\u001d;p[J+7o\u001c7vi&|gNU;mKN$\u0012a\t\t\u0004I1zcBA\u0013+\u001d\t1\u0013&D\u0001(\u0015\tAc\"\u0001\u0004=e>|GOP\u0005\u0002/%\u00111FF\u0001\ba\u0006\u001c7.Y4f\u0013\ticFA\u0002TKFT!a\u000b\f\u0011\tU\u0001$GN\u0005\u0003cY\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0005M\"T\"\u0001\u0004\n\u0005U2!\u0001D*qCJ\\7+Z:tS>t\u0007cA\u001c=}5\t\u0001H\u0003\u0002:u\u0005)!/\u001e7fg*\u00111HB\u0001\tG\u0006$\u0018\r\\=ti&\u0011Q\b\u000f\u0002\u0005%VdW\r\u0005\u0002@\t6\t\u0001I\u0003\u0002B\u0005\u00069An\\4jG\u0006d'BA\";\u0003\u0015\u0001H.\u00198t\u0013\t)\u0005IA\u0006M_\u001eL7-\u00197QY\u0006t\u0007\"B$\u0012\t\u0003\u0011\u0013\u0001H2vgR|W\u000eU8ti\"{7MU3t_2,H/[8o%VdWm\u001d\u0005\b\u0013F\t\t\u0011\"!K\u0003\u0015\t\u0007\u000f\u001d7z)\rY\u0015Q\n\t\u0003!13AA\u0005\u0002A\u001bN)AJ\u000e(T5A\u0011q*U\u0007\u0002!*\u0011QAC\u0005\u0003%B\u00131c\u00159be.\fE-\u00199uKJ\u001cV\u000f\u001d9peR\u0004\"!\u0006+\n\u0005U3\"a\u0002)s_\u0012,8\r\u001e\u0005\t/2\u0013)\u001a!C\u00011\u0006a1\u000f]1sWN+7o]5p]V\t!\u0007\u0003\u0005[\u0019\nE\t\u0015!\u00033\u00035\u0019\b/\u0019:l'\u0016\u001c8/[8oA!)a\u0004\u0014C\u00019R\u00111*\u0018\u0005\u0006/n\u0003\rA\r\u0005\u0006\u00132#\te\u0018\u000b\u0003}\u0001DQ!\u00190A\u0002y\nA\u0001\u001d7b]\"91\rTA\u0001\n\u0003!\u0017\u0001B2paf$\"aS3\t\u000f]\u0013\u0007\u0013!a\u0001e!9q\rTI\u0001\n\u0003A\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0002S*\u0012!G[\u0016\u0002WB\u0011A.]\u0007\u0002[*\u0011an\\\u0001\nk:\u001c\u0007.Z2lK\u0012T!\u0001\u001d\f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002s[\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u000fQd\u0015\u0011!C!k\u0006i\u0001O]8ek\u000e$\bK]3gSb,\u0012A\u001e\t\u0003orl\u0011\u0001\u001f\u0006\u0003sj\fA\u0001\\1oO*\t10\u0001\u0003kCZ\f\u0017BA?y\u0005\u0019\u0019FO]5oO\"Aq\u0010TA\u0001\n\u0003\t\t!\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\u0004A\u0019Q#!\u0002\n\u0007\u0005\u001daCA\u0002J]RD\u0011\"a\u0003M\u0003\u0003%\t!!\u0004\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011qBA\u000b!\r)\u0012\u0011C\u0005\u0004\u0003'1\"aA!os\"Q\u0011qCA\u0005\u0003\u0003\u0005\r!a\u0001\u0002\u0007a$\u0013\u0007C\u0005\u0002\u001c1\u000b\t\u0011\"\u0011\u0002\u001e\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002 A1\u0011\u0011EA\u0014\u0003\u001fi!!a\t\u000b\u0007\u0005\u0015b#\u0001\u0006d_2dWm\u0019;j_:LA!!\u000b\u0002$\tA\u0011\n^3sCR|'\u000fC\u0005\u0002.1\u000b\t\u0011\"\u0001\u00020\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u00022\u0005]\u0002cA\u000b\u00024%\u0019\u0011Q\u0007\f\u0003\u000f\t{w\u000e\\3b]\"Q\u0011qCA\u0016\u0003\u0003\u0005\r!a\u0004\t\u0013\u0005mB*!A\u0005B\u0005u\u0012\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005\r\u0001\"CA!\u0019\u0006\u0005I\u0011IA\"\u0003!!xn\u0015;sS:<G#\u0001<\t\u0013\u0005\u001dC*!A\u0005B\u0005%\u0013AB3rk\u0006d7\u000f\u0006\u0003\u00022\u0005-\u0003BCA\f\u0003\u000b\n\t\u00111\u0001\u0002\u0010!)q\u000b\u0013a\u0001e!I\u0011\u0011K\t\u0002\u0002\u0013\u0005\u00151K\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t)&a\u0017\u0011\tU\t9FM\u0005\u0004\u000332\"AB(qi&|g\u000eC\u0005\u0002^\u0005=\u0013\u0011!a\u0001\u0017\u0006\u0019\u0001\u0010\n\u0019\t\u0013\u0005\u0005\u0014#!A\u0005\n\u0005\r\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!\u001a\u0011\u0007]\f9'C\u0002\u0002ja\u0014aa\u00142kK\u000e$\b")
public class HoodieAnalysis
extends Rule<LogicalPlan>
implements SparkAdapterSupport,
Product,
Serializable {
    private final SparkSession sparkSession;
    private final SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    public static Option<SparkSession> unapply(HoodieAnalysis hoodieAnalysis) {
        return HoodieAnalysis$.MODULE$.unapply(hoodieAnalysis);
    }

    public static Seq<Function1<SparkSession, Rule<LogicalPlan>>> customPostHocResolutionRules() {
        return HoodieAnalysis$.MODULE$.customPostHocResolutionRules();
    }

    public static Seq<Function1<SparkSession, Rule<LogicalPlan>>> customResolutionRules() {
        return HoodieAnalysis$.MODULE$.customResolutionRules();
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        HoodieAnalysis hoodieAnalysis = this;
        synchronized (hoodieAnalysis) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport$class.sparkAdapter(this);
                this.bitmap$0 = true;
            }
            return this.sparkAdapter;
        }
    }

    @Override
    public SparkAdapter sparkAdapter() {
        return this.bitmap$0 ? this.sparkAdapter : this.sparkAdapter$lzycompute();
    }

    public SparkSession sparkSession() {
        return this.sparkSession;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public LogicalPlan apply(LogicalPlan plan) {
        void var5_15;
        LogicalPlan logicalPlan = plan;
        if (logicalPlan instanceof MergeIntoTable) {
            MergeIntoTable mergeIntoTable = (MergeIntoTable)logicalPlan;
            LogicalPlan target = mergeIntoTable.targetTable();
            if (mergeIntoTable.resolved() && HoodieSqlUtils$.MODULE$.isHoodieTable(target, this.sparkSession())) {
                MergeIntoHoodieTableCommand mergeIntoHoodieTableCommand = new MergeIntoHoodieTableCommand(mergeIntoTable);
                return var5_15;
            }
        }
        if (logicalPlan instanceof UpdateTable) {
            UpdateTable updateTable = (UpdateTable)logicalPlan;
            LogicalPlan table = updateTable.table();
            if (updateTable.resolved() && HoodieSqlUtils$.MODULE$.isHoodieTable(table, this.sparkSession())) {
                UpdateHoodieTableCommand updateHoodieTableCommand = new UpdateHoodieTableCommand(updateTable);
                return var5_15;
            }
        }
        if (logicalPlan instanceof DeleteFromTable) {
            DeleteFromTable deleteFromTable = (DeleteFromTable)logicalPlan;
            LogicalPlan table = deleteFromTable.table();
            if (deleteFromTable.resolved() && HoodieSqlUtils$.MODULE$.isHoodieTable(table, this.sparkSession())) {
                DeleteHoodieTableCommand deleteHoodieTableCommand = new DeleteHoodieTableCommand(deleteFromTable);
                return var5_15;
            }
        }
        if (this.sparkAdapter().isInsertInto(logicalPlan)) {
            LogicalRelation logicalRelation;
            Tuple4 tuple4;
            Tuple5 tuple5 = (Tuple5)this.sparkAdapter().getInsertIntoChildren(logicalPlan).get();
            if (tuple5 == null) throw new MatchError((Object)tuple5);
            LogicalPlan table = (LogicalPlan)tuple5._1();
            Map partition = (Map)tuple5._2();
            LogicalPlan query = (LogicalPlan)tuple5._3();
            boolean overwrite = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
            Tuple4 tuple42 = tuple4 = new Tuple4((Object)table, (Object)partition, (Object)query, (Object)BoxesRunTime.boxToBoolean((boolean)overwrite));
            LogicalPlan table2 = (LogicalPlan)tuple42._1();
            Map partition2 = (Map)tuple42._2();
            LogicalPlan query2 = (LogicalPlan)tuple42._3();
            boolean overwrite2 = BoxesRunTime.unboxToBoolean((Object)tuple42._4());
            LogicalPlan logicalPlan2 = table2;
            LogicalPlan logicalPlan3 = logicalPlan2 instanceof LogicalRelation && HoodieSqlUtils$.MODULE$.isHoodieTable((LogicalPlan)(logicalRelation = (LogicalRelation)logicalPlan2), this.sparkSession()) ? new InsertIntoHoodieTableCommand(logicalRelation, query2, (Map<String, Option<String>>)partition2, overwrite2) : logicalPlan;
            LogicalPlan logicalPlan4 = logicalPlan3;
            return var5_15;
        }
        if (logicalPlan instanceof CreateTable) {
            Some some;
            LogicalPlan query;
            CreateTable createTable = (CreateTable)logicalPlan;
            CatalogTable table = createTable.tableDesc();
            SaveMode mode = createTable.mode();
            Option option = createTable.query();
            if (option instanceof Some && (query = (LogicalPlan)(some = (Some)option).x()).resolved() && HoodieSqlUtils$.MODULE$.isHoodieTable(table)) {
                CreateHoodieTableAsSelectCommand createHoodieTableAsSelectCommand = new CreateHoodieTableAsSelectCommand(table, mode, query);
                return var5_15;
            }
        }
        if (logicalPlan instanceof CompactionTable) {
            CompactionTable compactionTable = (CompactionTable)logicalPlan;
            LogicalPlan table = compactionTable.table();
            Enumeration.Value operation = compactionTable.operation();
            Option<Object> options = compactionTable.instantTimestamp();
            if (table.resolved() && HoodieSqlUtils$.MODULE$.isHoodieTable(table, this.sparkSession())) {
                TableIdentifier tableId = HoodieSqlUtils$.MODULE$.getTableIdentify(table);
                CatalogTable catalogTable = this.sparkSession().sessionState().catalog().getTableMetadata(tableId);
                CompactionHoodieTableCommand compactionHoodieTableCommand = new CompactionHoodieTableCommand(catalogTable, operation, options);
                return var5_15;
            }
        }
        if (logicalPlan instanceof CompactionPath) {
            CompactionPath compactionPath = (CompactionPath)logicalPlan;
            String path = compactionPath.path();
            Enumeration.Value operation = compactionPath.operation();
            Option<Object> options = compactionPath.instantTimestamp();
            CompactionHoodiePathCommand compactionHoodiePathCommand = new CompactionHoodiePathCommand(path, operation, options);
            return var5_15;
        }
        if (logicalPlan instanceof CompactionShowOnTable) {
            CompactionShowOnTable compactionShowOnTable = (CompactionShowOnTable)logicalPlan;
            LogicalPlan table = compactionShowOnTable.table();
            int limit = compactionShowOnTable.limit();
            if (HoodieSqlUtils$.MODULE$.isHoodieTable(table, this.sparkSession())) {
                TableIdentifier tableId = HoodieSqlUtils$.MODULE$.getTableIdentify(table);
                CatalogTable catalogTable = this.sparkSession().sessionState().catalog().getTableMetadata(tableId);
                CompactionShowHoodieTableCommand compactionShowHoodieTableCommand = new CompactionShowHoodieTableCommand(catalogTable, limit);
                return var5_15;
            }
        }
        if (logicalPlan instanceof CompactionShowOnPath) {
            CompactionShowOnPath compactionShowOnPath = (CompactionShowOnPath)logicalPlan;
            String path = compactionShowOnPath.path();
            int limit = compactionShowOnPath.limit();
            CompactionShowHoodiePathCommand compactionShowHoodiePathCommand = new CompactionShowHoodiePathCommand(path, limit);
            return var5_15;
        }
        LogicalPlan logicalPlan5 = plan;
        return var5_15;
    }

    public HoodieAnalysis copy(SparkSession sparkSession) {
        return new HoodieAnalysis(sparkSession);
    }

    public SparkSession copy$default$1() {
        return this.sparkSession();
    }

    public String productPrefix() {
        return "HoodieAnalysis";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 0: 
        }
        return this.sparkSession();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HoodieAnalysis;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HoodieAnalysis)) return false;
        boolean bl = true;
        if (!bl) return false;
        HoodieAnalysis hoodieAnalysis = (HoodieAnalysis)x$1;
        SparkSession sparkSession = this.sparkSession();
        SparkSession sparkSession2 = hoodieAnalysis.sparkSession();
        if (sparkSession == null) {
            if (sparkSession2 != null) {
                return false;
            }
        } else if (!sparkSession.equals(sparkSession2)) return false;
        if (!hoodieAnalysis.canEqual(this)) return false;
        return true;
    }

    public HoodieAnalysis(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        SparkAdapterSupport$class.$init$(this);
        Product.class.$init$((Product)this);
    }
}

