# udf

## Description

Supports using UDF in data integration by the transform.
Need to specify the function name and class name and put UDF jars in Flink's classpath or import them via 'Flink run -c xxx.jar'

:::tip

This transform **ONLY** supported by Flink.

:::

## Options

| name           | type        | required | default value |
| -------------- | ----------- | -------- | ------------- |
| function       | string      | yes      | -             |

### function [string]

A config prefix, use like `function.test="xxx.Test"`.

### common options [string]

Transform plugin common parameters, please refer to [Transform Plugin](common-options.mdx) for details

## Examples

Use `udf` in sql.

```bash
  udf {
    function.test_1 = "com.example.udf.flink.TestUDF"
    function.test_2 = "com.example.udf.flink.TestUDTF"
  }
  
  # Use the specify function (confirm that the fake table exists)
  sql {
    sql = "select test_1(name), age from fake"
  }
```
