/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.translation.spark.common.source.micro;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.common.utils.SerializationUtils;
import org.apache.seatunnel.translation.source.BaseSourceFunction;
import org.apache.seatunnel.translation.spark.common.Handover;
import org.apache.seatunnel.translation.spark.common.ReaderState;
import org.apache.seatunnel.translation.spark.common.source.batch.ParallelBatchPartitionReader;
import org.apache.seatunnel.translation.util.ThreadPoolExecutorFactory;

public class ParallelMicroBatchPartitionReader
extends ParallelBatchPartitionReader {
    protected static final Integer CHECKPOINT_SLEEP_INTERVAL = 10;
    protected volatile Integer checkpointId;
    protected final Integer checkpointInterval;
    protected final String checkpointPath;
    protected final String hdfsRoot;
    protected final String hdfsUser;
    protected Map<Integer, List<byte[]>> restoredState;
    protected ScheduledThreadPoolExecutor executor;
    protected FileSystem fileSystem;

    public ParallelMicroBatchPartitionReader(SeaTunnelSource<SeaTunnelRow, ?, ?> source, Integer parallelism, Integer subtaskId, Integer checkpointId, Integer checkpointInterval, String checkpointPath, String hdfsRoot, String hdfsUser) {
        super(source, parallelism, subtaskId);
        this.checkpointId = checkpointId;
        this.checkpointInterval = checkpointInterval;
        this.checkpointPath = checkpointPath;
        this.hdfsRoot = hdfsRoot;
        this.hdfsUser = hdfsUser;
    }

    @Override
    protected BaseSourceFunction<SeaTunnelRow> createInternalSource() {
        return new ParallelBatchPartitionReader.InternalParallelSource(this.source, this.restoredState, this.parallelism, this.subtaskId);
    }

    @Override
    protected void prepare() {
        try {
            this.fileSystem = this.getFileSystem();
            this.restoredState = this.restoreState(this.checkpointId - 1);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        super.prepare();
        this.prepareCheckpoint();
    }

    protected FileSystem getFileSystem() throws URISyntaxException, IOException, InterruptedException {
        Configuration configuration = new Configuration();
        configuration.set("fs.defaultFS", this.hdfsRoot);
        if (StringUtils.isNotBlank(this.hdfsUser)) {
            return FileSystem.get((URI)new URI(this.hdfsRoot), (Configuration)configuration, (String)this.hdfsUser);
        }
        return FileSystem.get((URI)new URI(this.hdfsRoot), (Configuration)configuration);
    }

    protected ReaderState snapshotState() {
        Map<Integer, List<byte[]>> bytes;
        try {
            bytes = this.internalSource.snapshotState(this.checkpointId.intValue());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Integer n = this.checkpointId;
        Integer n2 = this.checkpointId = Integer.valueOf(this.checkpointId + 1);
        return new ReaderState(bytes, this.subtaskId, n);
    }

    public void prepareCheckpoint() {
        this.executor = ThreadPoolExecutorFactory.createScheduledThreadPoolExecutor(1, String.format("parallel-reader-checkpoint-executor-%s", this.subtaskId));
        this.executor.schedule(this::virtualCheckpoint, (long)this.checkpointInterval.intValue(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void virtualCheckpoint() {
        try {
            Object object = this.checkpointLock;
            synchronized (object) {
                while (!this.handover.isEmpty()) {
                    Thread.sleep(CHECKPOINT_SLEEP_INTERVAL.intValue());
                }
                Handover handover = this.handover;
                synchronized (handover) {
                    int currentCheckpoint = this.checkpointId;
                    ReaderState readerState = this.snapshotState();
                    this.saveState(readerState, currentCheckpoint);
                    this.internalSource.notifyCheckpointComplete(currentCheckpoint);
                    this.running = false;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred in virtual checkpoint execution.", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Map<Integer, List<byte[]>> restoreState(int checkpointId) throws IOException {
        Path hdfsPath = this.getCheckpointPathWithId(checkpointId);
        if (!this.fileSystem.exists(hdfsPath)) {
            return null;
        }
        try (FSDataInputStream inputStream = this.fileSystem.open(hdfsPath);){
            Map<Integer, List<byte[]>> map2;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                int i = 0;
                int defaultLen = 1024;
                byte[] buffer = new byte[1024];
                while ((i = inputStream.read(buffer)) != -1) {
                    out.write(buffer, 0, i);
                }
                map2 = ((ReaderState)SerializationUtils.deserialize(out.toByteArray())).getBytes();
            }
            return map2;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void saveState(ReaderState readerState, int checkpointId) throws IOException {
        byte[] bytes = SerializationUtils.serialize(readerState);
        Path hdfsPath = this.getCheckpointPathWithId(checkpointId);
        if (!this.fileSystem.exists(hdfsPath)) {
            this.fileSystem.createNewFile(hdfsPath);
        }
        try (FSDataOutputStream outputStream = this.fileSystem.append(hdfsPath);){
            outputStream.write(bytes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Path getCheckpointPathWithId(int checkpointId) {
        return new Path(this.checkpointPath + File.separator + this.subtaskId + File.separator + checkpointId);
    }

    @Override
    public void close() throws IOException {
        this.fileSystem.close();
        this.executor.shutdown();
        super.close();
    }
}

