/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.translation.spark.source;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.common.utils.SerializationUtils;
import org.apache.seatunnel.translation.spark.source.batch.BatchSourceReader;
import org.apache.seatunnel.translation.spark.source.micro.MicroBatchSourceReader;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.DataSourceV2;
import org.apache.spark.sql.sources.v2.MicroBatchReadSupport;
import org.apache.spark.sql.sources.v2.ReadSupport;
import org.apache.spark.sql.sources.v2.reader.DataSourceReader;
import org.apache.spark.sql.sources.v2.reader.streaming.MicroBatchReader;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeaTunnelSourceSupport
implements DataSourceV2,
ReadSupport,
MicroBatchReadSupport,
DataSourceRegister {
    private static final Logger LOG = LoggerFactory.getLogger(SeaTunnelSourceSupport.class);
    public static final String SEA_TUNNEL_SOURCE_NAME = "SeaTunnelSource";
    public static final Integer CHECKPOINT_INTERVAL_DEFAULT = 10000;

    public String shortName() {
        return SEA_TUNNEL_SOURCE_NAME;
    }

    public DataSourceReader createReader(StructType rowType, DataSourceOptions options) {
        return this.createReader(options);
    }

    public DataSourceReader createReader(DataSourceOptions options) {
        SeaTunnelSource<SeaTunnelRow, ?, ?> seaTunnelSource = this.getSeaTunnelSource(options);
        int parallelism = options.getInt("source.parallelism", 1);
        return new BatchSourceReader(seaTunnelSource, parallelism);
    }

    public MicroBatchReader createMicroBatchReader(Optional<StructType> rowTypeOptional, String checkpointLocation, DataSourceOptions options) {
        SeaTunnelSource<SeaTunnelRow, ?, ?> seaTunnelSource = this.getSeaTunnelSource(options);
        Integer parallelism = options.getInt("source.parallelism", 1);
        Integer checkpointInterval = options.getInt("checkpoint.interval", CHECKPOINT_INTERVAL_DEFAULT.intValue());
        String checkpointPath = StringUtils.replacePattern(checkpointLocation, "sources/\\d+", "sources-state");
        Configuration configuration = ((SparkSession)SparkSession.getActiveSession().get()).sparkContext().hadoopConfiguration();
        String hdfsRoot = options.get("hdfs.root").orElse(FileSystem.getDefaultUri((Configuration)configuration).toString());
        String hdfsUser = options.get("hdfs.user").orElse("");
        Integer checkpointId = options.getInt("checkpoint.id", 1);
        return new MicroBatchSourceReader(seaTunnelSource, parallelism, checkpointId, checkpointInterval, checkpointPath, hdfsRoot, hdfsUser);
    }

    private SeaTunnelSource<SeaTunnelRow, ?, ?> getSeaTunnelSource(DataSourceOptions options) {
        return (SeaTunnelSource)SerializationUtils.stringToObject((String)options.get("source.serialization").orElseThrow(() -> new UnsupportedOperationException("Serialization information for the SeaTunnelSource is required")));
    }
}

